/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.util.Arrays;
import java.util.concurrent.Callable;
import jeeves.JeevesCacheManager;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.ThesaurusFinder;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.search.CodeListTranslator;
import org.fao.geonet.kernel.search.DbDescTranslator;
import org.fao.geonet.kernel.search.JSONLocTranslator;
import org.fao.geonet.kernel.search.TermUriTranslator;
import org.fao.geonet.kernel.search.Translator;
import org.fao.geonet.kernel.search.TranslatorCachingWrapper;
import org.fao.geonet.utils.Log;
import org.springframework.context.ConfigurableApplicationContext;

public class TranslatorFactory {
    public static final Translator IDENTITY_TRANSLATOR = new Translator(){
        private static final long serialVersionUID = 1L;

        @Override
        public String translate(String key) {
            return key;
        }
    };

    public Translator getTranslator(String translatorString, String langCode) {
        try {
            return this.getTranslatorUnhandled(translatorString, langCode);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.search", (String)("Error creating translator " + translatorString + " (" + langCode + ")"), (Throwable)e);
            return IDENTITY_TRANSLATOR;
        }
    }

    private Translator getTranslatorUnhandled(String translatorString, final String langCode) throws Exception {
        Translator translator;
        if (translatorString == null || translatorString.length() == 0) {
            return IDENTITY_TRANSLATOR;
        }
        String key = translatorString + langCode;
        String[] parts = translatorString.split(":", 2);
        if (parts.length != 2) {
            throw new AssertionError((Object)String.format("Check the translator configuration '%s' of the config-summary.xml. It must be of the form nameOfTranslator:TranslatorParam.", translatorString));
        }
        String type = parts[0];
        final String param = parts[1];
        final ConfigurableApplicationContext context = ApplicationContextHolder.get();
        if (TranslatorTypes.CODELIST.toString().equals(type)) {
            translator = new CodeListTranslator((SchemaManager)context.getBean(SchemaManager.class), langCode, param);
        } else if (TranslatorTypes.APPLOC.toString().equals(type)) {
            translator = new JSONLocTranslator(context, langCode, param);
        } else if (TranslatorTypes.TERM.toString().equals(type)) {
            translator = JeevesCacheManager.findInEternalCache(key, new Callable<Translator>(){

                @Override
                public Translator call() {
                    try {
                        TermUriTranslator termUriTranslator = new TermUriTranslator((ThesaurusFinder)context.getBean(ThesaurusManager.class), langCode, param);
                        return new TranslatorCachingWrapper(termUriTranslator);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        } else if (TranslatorTypes.DB.toString().equals(type)) {
            translator = JeevesCacheManager.findInTenSecondCache(key, new Callable<Translator>(){

                @Override
                public Translator call() {
                    try {
                        return new DbDescTranslator(context, langCode, param);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        } else {
            throw new AssertionError((Object)String.format("'%s' is not a recognized type of translator. Supported types are: %s", type, Arrays.asList(TranslatorTypes.values())));
        }
        return translator;
    }

    private static enum TranslatorTypes {
        CODELIST("codelist"),
        APPLOC("apploc"),
        TERM("term"),
        DB("db");

        public final String name;

        private TranslatorTypes(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

