/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.oaipmh.services;

import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.oaipmh.Lib;
import org.fao.geonet.kernel.oaipmh.ResumptionTokenCache;
import org.fao.geonet.kernel.oaipmh.services.AbstractTokenLister;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.oaipmh.requests.TokenListRequest;
import org.fao.oaipmh.responses.Header;
import org.fao.oaipmh.responses.ListIdentifiersResponse;
import org.fao.oaipmh.responses.ListResponse;
import org.fao.oaipmh.util.SearchResult;

public class ListIdentifiers
extends AbstractTokenLister {
    public ListIdentifiers(ResumptionTokenCache cache, SettingManager sm, SchemaManager scm) {
        super(cache, sm, scm);
    }

    @Override
    public String getVerb() {
        return "ListIdentifiers";
    }

    @Override
    public ListResponse processRequest(TokenListRequest req, int pos, SearchResult result, ServiceContext context) throws Exception {
        ListIdentifiersResponse res = new ListIdentifiersResponse();
        int num = 0;
        while (num < this.getMaxRecords() && pos < result.getIds().size()) {
            int id = (Integer)result.getIds().get(pos);
            Header h = this.buildHeader(context, id, result.prefix);
            if (h != null) {
                res.addHeader(h);
                ++num;
            }
            ++pos;
        }
        return res;
    }

    private Header buildHeader(ServiceContext context, int id, String prefix) {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SchemaManager sm = gc.getBean(SchemaManager.class);
        AbstractMetadata metadata = gc.getBean(IMetadataUtils.class).findOne(id);
        if (metadata == null) {
            return null;
        }
        String uuid = metadata.getUuid();
        String schema = metadata.getDataInfo().getSchemaId();
        ISODate changeDate = metadata.getDataInfo().getChangeDate();
        if (!prefix.equals(schema) && !Lib.existsConverter(sm.getSchemaDir(schema), prefix)) {
            return null;
        }
        Header h = new Header();
        h.setIdentifier(uuid);
        h.setDateStamp(changeDate);
        for (MetadataCategory category : metadata.getCategories()) {
            h.addSet(category.getName());
        }
        return h;
    }
}

