/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.datamanager.base;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataDataInfo;
import org.fao.geonet.domain.MetadataHarvestInfo;
import org.fao.geonet.domain.MetadataRatingByIp;
import org.fao.geonet.domain.MetadataRatingByIpId;
import org.fao.geonet.domain.MetadataSourceInfo;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.XmlSerializer;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataSchemaUtils;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.kernel.search.index.IndexingList;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.LanguageRepository;
import org.fao.geonet.repository.MetadataRatingByIpRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.SimpleMetadata;
import org.fao.geonet.repository.reports.MetadataReportsQueries;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.web.DefaultLanguage;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.util.UriComponentsBuilder;

public class BaseMetadataUtils
implements IMetadataUtils {
    @Autowired
    private MetadataRepository metadataRepository;
    private ServiceContext servContext;
    @Autowired
    protected IMetadataSchemaUtils metadataSchemaUtils;
    @Autowired
    protected IMetadataIndexer metadataIndexer;
    @Autowired
    protected SchemaManager schemaManager;
    @Autowired
    protected MetadataRatingByIpRepository ratingByIpRepository;
    @Autowired
    protected LanguageRepository languageRepository;
    @Autowired
    @Lazy
    protected SettingManager settingManager;
    @Autowired
    private IndexingList indexingList;
    @Autowired
    private EsSearchManager searchManager;
    @Autowired
    private GeonetworkDataDirectory dataDirectory;
    @Autowired(required=false)
    protected XmlSerializer xmlSerializer;
    @Autowired
    private DefaultLanguage defaultLanguage;
    private Path stylePath;
    protected IMetadataManager metadataManager;

    @Override
    public void setMetadataManager(IMetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    @Override
    public void init(ServiceContext context, Boolean force) throws Exception {
        this.servContext = context;
        this.stylePath = this.dataDirectory.resolveWebResource("xsl");
    }

    @PostConstruct
    public void init() {
        this.metadataIndexer.setMetadataUtils(this);
    }

    @Override
    @Nullable
    public String getMetadataUuid(@Nonnull String id) throws Exception {
        AbstractMetadata metadata = this.findOne(id);
        if (metadata == null) {
            return null;
        }
        return metadata.getUuid();
    }

    protected ServiceContext getServiceContext() {
        ServiceContext context = ServiceContext.get();
        return context == null ? this.servContext : context;
    }

    @Override
    public Integer startEditingSession(ServiceContext context, String id) throws Exception {
        if (Log.isDebugEnabled((String)"geonetwork.editor.session")) {
            Log.debug((String)"geonetwork.editor.session", (Object)("Editing session starts for record " + id));
        }
        boolean keepXlinkAttributes = true;
        boolean forEditing = false;
        boolean withValidationErrors = false;
        Element metadataBeforeAnyChanges = this.metadataManager.getMetadata(context, id, forEditing, false, withValidationErrors, keepXlinkAttributes);
        context.getUserSession().setProperty("metadata.before.any.changes" + id, metadataBeforeAnyChanges);
        return Integer.valueOf(id);
    }

    @Override
    public void cancelEditingSession(ServiceContext context, String id) throws Exception {
        UserSession session = context.getUserSession();
        Element metadataBeforeAnyChanges = (Element)session.getProperty("metadata.before.any.changes" + id);
        if (Log.isDebugEnabled((String)"geonetwork.editor.session")) {
            Log.debug((String)"geonetwork.editor.session", (Object)("Editing session end. Cancel changes. Restore record " + id + ". Replace by original record which was: "));
        }
        if (metadataBeforeAnyChanges != null) {
            if (Log.isDebugEnabled((String)"geonetwork.editor.session")) {
                Log.debug((String)"geonetwork.editor.session", (Object)" > restoring record: ");
                Log.debug((String)"geonetwork.editor.session", (Object)Xml.getString((Element)metadataBeforeAnyChanges));
            }
            Element info = metadataBeforeAnyChanges.getChild("info", Edit.NAMESPACE);
            boolean validate = false;
            boolean ufo = false;
            metadataBeforeAnyChanges.removeChild("info", Edit.NAMESPACE);
            this.metadataManager.updateMetadata(context, id, metadataBeforeAnyChanges, validate, ufo, context.getLanguage(), info.getChildText("changeDate"), true, IndexingMode.full);
            this.endEditingSession(id, session);
        } else if (Log.isDebugEnabled((String)"geonetwork.editor.session")) {
            Log.debug((String)"geonetwork.editor.session", (Object)(" > nothing to cancel for record " + id + ". Original record was null. Use starteditingsession to."));
        }
    }

    @Override
    public void endEditingSession(String id, UserSession session) {
        if (Log.isDebugEnabled((String)"geonetwork.editor.session")) {
            Log.debug((String)"geonetwork.editor.session", (Object)"Editing session end.");
        }
        session.removeProperty("metadata.before.any.changes" + id);
        this.metadataManager.getEditLib().clearVersion(id);
    }

    @Override
    public Element enumerateTree(Element md) throws Exception {
        this.metadataManager.getEditLib().enumerateTree(md);
        return md;
    }

    @Override
    public String extractUUID(String schema, Element md) throws Exception {
        Path styleSheet = this.metadataSchemaUtils.getSchemaDir(schema).resolve("extract-uuid.xsl");
        String uuid = Xml.transform((Element)md, (Path)styleSheet).getText().trim();
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)("Extracted UUID '" + uuid + "' for schema '" + schema + "'"));
        }
        md.detach();
        return uuid;
    }

    @Override
    public String extractDefaultLanguage(String schema, Element md) throws Exception {
        Path styleSheet = this.metadataSchemaUtils.getSchemaDir(schema).resolve("extract-default-language.xsl");
        String defaultLanguageValue = Xml.transform((Element)md, (Path)styleSheet).getText().trim();
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)("Extracted default language '" + defaultLanguageValue + "' for schema '" + schema + "'"));
        }
        md.detach();
        return defaultLanguageValue;
    }

    @Override
    public LinkedHashMap<String, String> extractTitles(String schema, Element md) throws Exception {
        Path styleSheet = this.metadataSchemaUtils.getSchemaDir(schema).resolve("extract-titles.xsl");
        Element root = Xml.transform((Element)md, (Path)styleSheet);
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>();
        root.getChildren("title").forEach(o -> {
            Element e;
            String lang;
            if (o instanceof Element && (lang = (e = (Element)o).getAttributeValue("lang")) != null) {
                titles.put(lang, e.getTextNormalize());
            }
        });
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)("Extracted title '" + titles + "' for schema '" + schema + "'"));
        }
        md.detach();
        return titles;
    }

    @Override
    public LinkedHashMap<String, String> extractTitles(@Nonnull String id) throws Exception {
        AbstractMetadata metadata = this.findOne(id);
        if (metadata != null && (metadata.getDataInfo().getType() == MetadataType.METADATA || metadata.getDataInfo().getType() == MetadataType.TEMPLATE)) {
            Element md = Xml.loadString((String)metadata.getData(), (boolean)false);
            return this.extractTitles(metadata.getDataInfo().getSchemaId(), md);
        }
        return null;
    }

    @Override
    public String getPermalink(String uuid, String language) {
        UriComponentsBuilder uriComponentsBuilder;
        Boolean doiIsFirst = this.settingManager.getValueAsBool("metadata/url/sitemapDoiFirst", false);
        if (Boolean.TRUE.equals(doiIsFirst)) {
            String doi = null;
            try {
                doi = this.getDoi(uuid);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isNotEmpty((String)doi)) {
                return doi;
            }
        }
        String sitemapLinkUrl = this.settingManager.getValue("metadata/url/sitemapLinkUrl");
        String defaultLink = this.settingManager.getNodeURL() + "api/records/" + uuid + "?language=all";
        String permalink = this.buildUrl(uuid, language, sitemapLinkUrl);
        if (StringUtils.isNotEmpty((String)permalink) && !defaultLink.equals(permalink)) {
            uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)permalink);
        } else {
            uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)defaultLink);
            String recordLinkFormatter = XslUtil.getUiConfigurationJsonProperty(null, "mods.search.formatter.recordLinkFormatter");
            if (StringUtils.isNotBlank((String)recordLinkFormatter)) {
                uriComponentsBuilder.queryParam("recordViewFormatter", new Object[]{recordLinkFormatter});
            }
        }
        return uriComponentsBuilder.build().toString();
    }

    @Override
    public String getDefaultUrl(String uuid, String language) {
        String dynamicAppLinkUrl = this.settingManager.getValue("metadata/url/dynamicAppLinkUrl");
        if ("all".equals(language)) {
            language = this.defaultLanguage.getLanguage();
        }
        String defaultLink = this.settingManager.getNodeURL() + language + "/catalog.search#/metadata/" + uuid;
        String url = this.buildUrl(uuid, language, dynamicAppLinkUrl);
        return StringUtils.isNotEmpty((String)url) ? url : defaultLink;
    }

    private String buildUrl(String uuid, String language, String url) {
        if (StringUtils.isNotEmpty((String)url)) {
            String upperCaseUrl = url.toUpperCase();
            HashMap<String, String> substitutions = new HashMap<String, String>();
            substitutions.put("{{UUID}}", uuid);
            substitutions.put("{{LANG}}", StringUtils.isEmpty((String)language) ? "" : language);
            if (upperCaseUrl.contains("{{RESOURCEID}}")) {
                try {
                    String resourceId = this.getResourceIdentifier(uuid);
                    substitutions.put("{{RESOURCEID}}", StringUtils.isEmpty((String)resourceId) ? "" : resourceId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (Map.Entry s : substitutions.entrySet()) {
                if (!upperCaseUrl.contains((CharSequence)s.getKey())) continue;
                url = url.replaceAll("(?i)" + Pattern.quote((String)s.getKey()), (String)s.getValue());
            }
        }
        return url;
    }

    @Override
    public String getDoi(String uuid) throws ResourceNotFoundException, IOException, JDOMException {
        AbstractMetadata metadata = this.findOneByUuid(uuid);
        MetadataSchema schema = this.metadataSchemaUtils.getSchema(metadata.getDataInfo().getSchemaId());
        Element xml = metadata.getXmlData(false);
        return schema.queryString("doi-get", xml);
    }

    @Override
    public String getResourceIdentifier(String uuid) throws ResourceNotFoundException, JDOMException, IOException {
        AbstractMetadata metadata = this.findOneByUuid(uuid);
        MetadataSchema schema = this.metadataSchemaUtils.getSchema(metadata.getDataInfo().getSchemaId());
        Element xml = metadata.getXmlData(false);
        return schema.queryString("resourceid-get", xml);
    }

    @Override
    public String extractDateModified(String schema, Element md) throws Exception {
        Path styleSheet = this.metadataSchemaUtils.getSchemaDir(schema).resolve("extract-date-modified.xsl");
        String dateMod = Xml.transform((Element)md, (Path)styleSheet).getText().trim();
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)("Extracted Date Modified '" + dateMod + "' for schema '" + schema + "'"));
        }
        md.detach();
        return dateMod;
    }

    @Override
    public Element setUUID(String schema, String uuid, Element md) throws Exception {
        Element env = new Element("env");
        env.addContent((Content)new Element("uuid").setText(uuid));
        Element root = new Element("root");
        root.addContent(md.detach());
        root.addContent(env.detach());
        Path styleSheet = this.metadataSchemaUtils.getSchemaDir(schema).resolve("set-uuid.xsl");
        return Xml.transform((Element)root, (Path)styleSheet);
    }

    @Override
    public Element extractSummary(Element md) throws Exception {
        Path styleSheet = this.stylePath.resolve("metadata-brief.xsl");
        Element summary = Xml.transform((Element)md, (Path)styleSheet);
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)("Extracted summary '\n" + Xml.getString((Element)summary)));
        }
        md.detach();
        return summary;
    }

    @Override
    @Nullable
    public String getMetadataId(@Nonnull String uuid) throws Exception {
        List<Integer> idList = this.findAllIdsBy((Specification<? extends AbstractMetadata>)MetadataSpecs.hasMetadataUuid((String)uuid));
        if (idList.isEmpty()) {
            return null;
        }
        return String.valueOf(idList.get(0));
    }

    @Override
    public List<Integer> findAllIdsBy(Specification<? extends AbstractMetadata> specs) {
        try {
            return this.metadataRepository.findIdsBy(specs);
        }
        catch (ClassCastException classCastException) {
            return Collections.emptyList();
        }
    }

    @Override
    public String getVersion(String id) {
        return this.metadataManager.getEditLib().getVersion(id);
    }

    @Override
    public String getNewVersion(String id) {
        return this.metadataManager.getEditLib().getNewVersion(id);
    }

    @Override
    public void setTemplate(int id, MetadataType type, String title) throws Exception {
        this.setTemplateExt(id, type);
        this.metadataIndexer.indexMetadata(Integer.toString(id), true, IndexingMode.full);
    }

    @Override
    public void setTemplateExt(int id, MetadataType metadataType) throws Exception {
        this.metadataRepository.update((Serializable)Integer.valueOf(id), metadata -> {
            MetadataDataInfo dataInfo = metadata.getDataInfo();
            dataInfo.setType(metadataType);
        });
    }

    @Override
    public void setHarvested(int id, String harvestUuid) throws Exception {
        this.setHarvestedExt(id, harvestUuid);
        this.metadataIndexer.indexMetadata(Integer.toString(id), true, IndexingMode.full);
    }

    @Override
    public void setSubtemplateTypeAndTitleExt(int id, String title) throws Exception {
        this.metadataRepository.update((Serializable)Integer.valueOf(id), metadata -> {
            MetadataDataInfo dataInfo = metadata.getDataInfo();
            dataInfo.setType(MetadataType.SUB_TEMPLATE);
            if (title != null) {
                dataInfo.setTitle(title);
            }
        });
    }

    @Override
    public void setHarvestedExt(int id, String harvestUuid) throws Exception {
        this.setHarvestedExt(id, harvestUuid, (com.google.common.base.Optional<String>)com.google.common.base.Optional.absent());
    }

    @Override
    public void setHarvestedExt(int id, String harvestUuid, com.google.common.base.Optional<String> harvestUri) throws Exception {
        this.metadataRepository.update((Serializable)Integer.valueOf(id), metadata -> {
            MetadataHarvestInfo harvestInfo = metadata.getHarvestInfo();
            harvestInfo.setUuid(harvestUuid);
            harvestInfo.setHarvested(harvestUuid != null);
            harvestInfo.setUri((String)harvestUri.orNull());
        });
    }

    @Override
    public void updateDisplayOrder(String id, String displayOrder) throws Exception {
        this.metadataRepository.update((Serializable)Integer.valueOf(id), entity -> entity.getDataInfo().setDisplayOrder(Integer.valueOf(Integer.parseInt(displayOrder))));
    }

    @Override
    public void increasePopularity(ServiceContext srvContext, String id) throws Exception {
        if (!srvContext.getBean(NodeInfo.class).isReadOnly()) {
            int iId = Integer.parseInt(id);
            this.metadataRepository.update((Serializable)Integer.valueOf(iId), entity -> entity.getDataInfo().setPopularity(entity.getDataInfo().getPopularity() + 1));
            Optional metadata = this.metadataRepository.findById((Object)iId);
            if (metadata.isPresent()) {
                this.searchManager.updateFieldAsynch(((Metadata)metadata.get()).getUuid(), "_popularity", ((Metadata)metadata.get()).getDataInfo().getPopularity());
            }
        } else if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)"GeoNetwork is operating in read-only mode. IncreasePopularity is skipped.");
        }
    }

    @Override
    public int rateMetadata(int metadataId, String ipAddress, int rating) throws Exception {
        MetadataRatingByIp ratingEntity = new MetadataRatingByIp();
        ratingEntity.setRating(rating);
        ratingEntity.setId(new MetadataRatingByIpId(metadataId, ipAddress));
        this.ratingByIpRepository.save((Object)ratingEntity);
        int newRating = this.ratingByIpRepository.averageRating(metadataId);
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)("Setting rating for id:" + metadataId + " --> rating is:" + newRating));
        }
        this.metadataRepository.update((Serializable)Integer.valueOf(metadataId), entity -> entity.getDataInfo().setRating(newRating));
        this.indexingList.add(metadataId);
        return rating;
    }

    @Override
    public Element getMetadataNoInfo(ServiceContext srvContext, String id) throws Exception {
        Element md = this.metadataManager.getMetadata(srvContext, id, false, true, false, false);
        return this.removeMetadataInfo(md);
    }

    @Override
    public Element removeMetadataInfo(Element md) throws Exception {
        md.removeChild("info", Edit.NAMESPACE);
        ArrayList additionalNamespaces = new ArrayList(md.getAdditionalNamespaces());
        for (Namespace n : additionalNamespaces) {
            if (!Edit.NAMESPACE.getURI().equals(n.getURI())) continue;
            md.removeNamespaceDeclaration(Edit.NAMESPACE);
        }
        return md;
    }

    @Override
    public Element getElementByRef(Element md, String ref) {
        return this.metadataManager.getEditLib().findElement(md, ref);
    }

    @Override
    public boolean existsMetadata(int id) throws Exception {
        return this.exists(id);
    }

    @Override
    public boolean existsMetadataUuid(String uuid) throws Exception {
        return !this.findAllIdsBy((Specification<? extends AbstractMetadata>)MetadataSpecs.hasMetadataUuid((String)uuid)).isEmpty();
    }

    @Override
    public boolean isMetadataPublished(int metadataId) throws Exception {
        Specification isMdPublished = OperationAllowedSpecs.isPublic((ReservedOperation)ReservedOperation.view);
        Specification hasMdId = OperationAllowedSpecs.hasMetadataId((int)metadataId);
        Optional one = ((OperationAllowedRepository)ApplicationContextHolder.get().getBean(OperationAllowedRepository.class)).findOne(Specification.where((Specification)hasMdId).and(isMdPublished));
        return one.isPresent();
    }

    @Override
    public boolean isMetadataApproved(int metadataId) throws Exception {
        boolean isApproved = false;
        MetadataStatus metadataStatus = ((IMetadataStatus)ApplicationContextHolder.get().getBean(IMetadataStatus.class)).getStatus(metadataId);
        if (metadataStatus != null) {
            String statusId = "" + metadataStatus.getStatusValue().getId();
            isApproved = statusId.equals("2");
        }
        return isApproved;
    }

    @Override
    public boolean isMetadataDraft(int metadataId) throws Exception {
        return !this.isMetadataApproved(metadataId) && !this.isMetadataPublished(metadataId);
    }

    @Override
    public Element getKeywords() throws Exception {
        Element el = new Element("keywords");
        return el;
    }

    private void transformMd(ServiceContext context, String metadataId, Element md, Element env, String schema, String styleSheet, boolean indexAfterChange) throws Exception {
        if (env.getChild("host") == null) {
            String host = this.getSettingManager().getValue("system/server/host");
            String port = this.getSettingManager().getValue("system/server/port");
            env.addContent((Content)new Element("host").setText(host));
            env.addContent((Content)new Element("port").setText(port));
        }
        Element root = new Element("root");
        root.addContent((Content)md);
        root.addContent((Content)env);
        Path styleSheetPath = this.metadataSchemaUtils.getSchemaDir(schema).resolve(styleSheet);
        md = Xml.transform((Element)root, (Path)styleSheetPath);
        String changeDate = null;
        String uuid = null;
        if (this.schemaManager.getSchema(schema).isReadwriteUUID()) {
            uuid = this.extractUUID(schema, md);
        }
        this.getXmlSerializer().update(metadataId, md, changeDate, true, uuid, context);
        if (indexAfterChange) {
            this.metadataIndexer.indexMetadata(metadataId, true, IndexingMode.full);
        }
    }

    @Override
    public void setDataCommons(ServiceContext context, String id, String licenseurl, String imageurl, String jurisdiction, String licensename, String type) throws Exception {
        Element env = this.prepareCommonsEnv(licenseurl, imageurl, jurisdiction, licensename, type);
        this.manageCommons(context, id, env, "set-datacommons.xsl");
    }

    private Element prepareCommonsEnv(String licenseurl, String imageurl, String jurisdiction, String licensename, String type) {
        Element env = new Element("env");
        env.addContent((Content)new Element("imageurl").setText(imageurl));
        env.addContent((Content)new Element("licenseurl").setText(licenseurl));
        env.addContent((Content)new Element("jurisdiction").setText(jurisdiction));
        env.addContent((Content)new Element("licensename").setText(licensename));
        env.addContent((Content)new Element("type").setText(type));
        return env;
    }

    @Override
    public void setCreativeCommons(ServiceContext context, String id, String licenseurl, String imageurl, String jurisdiction, String licensename, String type) throws Exception {
        Element env = this.prepareCommonsEnv(licenseurl, imageurl, jurisdiction, licensename, type);
        this.manageCommons(context, id, env, "set-creativecommons.xsl");
    }

    @Override
    public String getMetadataTitle(String id) throws Exception {
        AbstractMetadata md = this.findOne(id);
        if (md == null) {
            throw new IllegalArgumentException("Metadata not found for id : " + id);
        }
        return md.getDataInfo().getTitle();
    }

    private void manageCommons(ServiceContext context, String id, Element env, String styleSheet) throws Exception {
        Lib.resource.checkEditPrivilege(context, id);
        Element md = this.getXmlSerializer().select(context, id);
        if (md == null) {
            return;
        }
        md.detach();
        String schema = this.metadataSchemaUtils.getMetadataSchema(id);
        this.transformMd(context, id, md, env, schema, styleSheet, true);
    }

    private XmlSerializer getXmlSerializer() {
        return this.xmlSerializer;
    }

    private SettingManager getSettingManager() {
        return this.settingManager;
    }

    @Override
    public long count(Specification<? extends AbstractMetadata> specs) {
        try {
            return this.metadataRepository.count(specs);
        }
        catch (Throwable throwable) {
            throw new NotImplementedException("Unknown IMetadata subtype: " + specs.getClass().getName());
        }
    }

    @Override
    public long count() {
        return this.metadataRepository.count();
    }

    @Override
    public AbstractMetadata findOne(int id) {
        Optional metadata = this.metadataRepository.findById((Object)id);
        return metadata.isPresent() ? (AbstractMetadata)metadata.get() : null;
    }

    @Override
    public AbstractMetadata findOneByUuid(String uuid) {
        Metadata metadata = null;
        try {
            metadata = this.metadataRepository.findOneByUuid(uuid);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            Log.warning((String)"geonetwork", (Object)String.format("More than one record found with UUID '%s'. Error is '%s'.", uuid, e.getMessage()));
        }
        return metadata;
    }

    @Override
    public List<? extends AbstractMetadata> findAllByUuid(String uuid) {
        return this.metadataRepository.findAllByUuid(uuid);
    }

    @Override
    public AbstractMetadata findOne(Specification<? extends AbstractMetadata> spec) {
        try {
            Optional metadata = this.metadataRepository.findOne(spec);
            return metadata.isPresent() ? (AbstractMetadata)metadata.get() : null;
        }
        catch (ClassCastException t) {
            throw new ClassCastException("Unknown AbstractMetadata subtype: " + spec.getClass().getName());
        }
    }

    @Override
    public AbstractMetadata findOne(String id) {
        Optional metadata = this.metadataRepository.findById((Object)Integer.parseInt(id));
        return metadata.isPresent() ? (AbstractMetadata)metadata.get() : null;
    }

    @Override
    public List<? extends AbstractMetadata> findAllByHarvestInfo_Uuid(String uuid) {
        return this.metadataRepository.findAllByHarvestInfo_Uuid(uuid);
    }

    @Override
    public Iterable<? extends AbstractMetadata> findAll(Set<Integer> keySet) {
        return this.metadataRepository.findAllById(keySet);
    }

    @Override
    public List<? extends AbstractMetadata> findAll(Specification<? extends AbstractMetadata> spec, Sort order) {
        return this.metadataRepository.findAll(spec, order);
    }

    @Override
    public List<? extends AbstractMetadata> findAll(Specification<? extends AbstractMetadata> specs) {
        try {
            return this.metadataRepository.findAll(specs);
        }
        catch (Throwable throwable) {
            throw new NotImplementedException("Unknown AbstractMetadata subtype: " + specs.getClass().getName());
        }
    }

    @Override
    public List<SimpleMetadata> findAllSimple(String harvestUuid) {
        return this.metadataRepository.findSimple(harvestUuid);
    }

    @Override
    public boolean exists(Integer iId) {
        return this.metadataRepository.existsById((Object)iId);
    }

    @Override
    public Element findAllAsXml(Specification<? extends AbstractMetadata> specs, Sort sortByChangeDateDesc) {
        try {
            return this.metadataRepository.findAllAsXml(specs, sortByChangeDateDesc);
        }
        catch (Throwable throwable) {
            throw new NotImplementedException("Unknown AbstractMetadata subtype: " + specs.getClass().getName());
        }
    }

    @Override
    public MetadataReportsQueries getMetadataReports() {
        return this.metadataRepository.getMetadataReports();
    }

    @Override
    public Element findAllAsXml(@Nullable Specification<? extends AbstractMetadata> specs, @Nullable Pageable pageable) {
        try {
            return this.metadataRepository.findAllAsXml(specs, pageable);
        }
        catch (Throwable throwable) {
            throw new NotImplementedException("Unknown AbstractMetadata subtype: " + specs.getClass().getName());
        }
    }

    protected MetadataRepository getMetadataRepository() {
        return this.metadataRepository;
    }

    protected SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    @Override
    public boolean checkMetadataWithSameUuidExist(String uuid, int id) {
        Metadata recordWithThatUuid = this.getMetadataRepository().findOneByUuid(uuid);
        if (recordWithThatUuid != null && recordWithThatUuid.getId() != id) {
            throw new IllegalArgumentException(String.format("Another record exist with UUID '%s'. This record as internal id '%d'. The record you're trying to update with id '%d' can not be saved.", uuid, recordWithThatUuid.getId(), id));
        }
        return false;
    }

    @Override
    public Page<Pair<Integer, ISODate>> findAllIdsAndChangeDates(Pageable pageable) {
        return this.metadataRepository.findIdsAndChangeDates(pageable);
    }

    @Override
    public Map<Integer, MetadataSourceInfo> findAllSourceInfo(Specification<? extends AbstractMetadata> spec) {
        try {
            return this.metadataRepository.findSourceInfo(spec);
        }
        catch (Throwable throwable) {
            throw new NotImplementedException("Unknown AbstractMetadata subtype: " + spec.getClass().getName());
        }
    }

    @Override
    public void cloneFiles(AbstractMetadata original, AbstractMetadata dest) {
    }

    @Override
    public void replaceFiles(AbstractMetadata original, AbstractMetadata dest) {
    }

    @Override
    public String selectOneWithSearchAndReplace(String uuid, String search, String replace) {
        return this.metadataRepository.selectOneWithSearchAndReplace(uuid, search, replace);
    }

    @Override
    public String selectOneWithRegexSearchAndReplaceWithFlags(String uuid, String search, String replace, String flags) {
        return this.metadataRepository.selectOneWithRegexSearchAndReplaceWithFlags(uuid, search, replace, flags);
    }

    @Override
    public String selectOneWithRegexSearchAndReplace(String uuid, String search, String replace) {
        return this.metadataRepository.selectOneWithRegexSearchAndReplace(uuid, search, replace);
    }
}

