/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.processor.impl.css.CssUrlRewritingProcessor;
import ro.isdc.wro.model.resource.support.MutableResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.ResourceAuthorizationManager;

public class CssUrlAuthorizationProcessor
extends CssUrlRewritingProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssUrlAuthorizationProcessor.class);
    public static final String ALIAS = "cssClasspathUrlAuthorization";
    @Inject
    private ResourceAuthorizationManager authorizationManager;

    @Override
    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    @Override
    protected String replaceImageUrl(String cssUri, String imageUrl) {
        return imageUrl;
    }

    @Override
    protected void onUrlReplaced(String replacedUrl) {
        String allowedUrl = StringUtils.removeStart((String)replacedUrl, (String)this.getUrlPrefix());
        if (this.authorizationManager instanceof MutableResourceAuthorizationManager) {
            if (!this.authorizationManager.isAuthorized(allowedUrl)) {
                LOG.debug("Authorizing url: '{}'", (Object)allowedUrl);
                ((MutableResourceAuthorizationManager)this.authorizationManager).add(allowedUrl);
            }
        } else {
            throw new WroRuntimeException("This processor (" + this.getClass().getSimpleName() + ") requires an instance of MutableResourceAuthorizationManager!");
        }
    }
}

