/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;

public class ParsersSemanticPredicates {
    private static final String KEYFRAMES = "keyframes";
    private static final String DOCUMENT = "document";
    private static final String VIEWPORT = "viewport";
    private static final String SUPPORTS = "supports";
    private static final String CHARSET = "charset";
    private static final Set<String> PAGE_MARGIN_BOXES = new HashSet<String>(Arrays.asList("@top-left-corner", "@top-left", "@top-center", "@top-right", "@top-right-corner", "@bottom-left-corner", "@bottom-left", "@bottom-center", "@bottom-right", "@bottom-right-corner", "@left-top", "@left-middle", "@left-bottom", "@right-top", "@right-middle", "@right-bottom"));
    private static Set<String> NTH_PSEUDOCLASSES = new HashSet<String>();
    private static String EXTEND_PSEUDOCLASS;
    private static String NOT_PSEUDOCLASS;

    public boolean matchingAllRparent(TokenStream input) {
        Token all = input.LT(1);
        Token rparent = input.LT(2);
        if (all.getType() != 76 || all.getText() == null) {
            return false;
        }
        if (rparent.getType() != 77) {
            return false;
        }
        return "all".equals(all.getText().toLowerCase());
    }

    public boolean insideNth(TokenStream input) {
        return this.isNthPseudoClass(input.LT(-1));
    }

    private boolean isNthPseudoClass(Token a) {
        if (a == null) {
            return false;
        }
        String text = a.getText();
        if (text == null) {
            return false;
        }
        return NTH_PSEUDOCLASSES.contains(text.toLowerCase());
    }

    public boolean insideExtend(TokenStream input) {
        return this.isExtendPseudoClass(input.LT(-1));
    }

    private boolean isExtendPseudoClass(Token a) {
        if (a == null) {
            return false;
        }
        String text = a.getText();
        if (text == null) {
            return false;
        }
        return EXTEND_PSEUDOCLASS.equals(text.toLowerCase());
    }

    public boolean insideNot(TokenStream input) {
        return this.insideNot(input.LT(-1));
    }

    private boolean insideNot(Token a) {
        if (a == null) {
            return false;
        }
        String text = a.getText();
        if (text == null) {
            return false;
        }
        return NOT_PSEUDOCLASS.equals(text.toLowerCase());
    }

    public boolean onFunctionStart(TokenStream input) {
        return this.isFunctionStart(input, 1);
    }

    private boolean isFunctionStart(TokenStream input, int indx) {
        Token first = input.LT(indx);
        if (first == null) {
            return false;
        }
        int ft = first.getType();
        if (ft != 76 && ft != 127) {
            return false;
        }
        Token previous = first;
        Token next = input.LT(++indx);
        while (next != null && this.directlyFollows(previous, next)) {
            int nt = next.getType();
            if (nt == 75) {
                return true;
            }
            if (nt != 76 && nt != 127 && nt != 79 && nt != 102) {
                return false;
            }
            previous = next;
            next = input.LT(++indx);
        }
        return false;
    }

    public boolean onEmptySeparator(TokenStream input) {
        return this.isEmptySeparator(input.LT(-1), input.LT(1), input.LT(2));
    }

    private boolean isEmptySeparator(Token previousT, Token firstT, Token secondT) {
        if (previousT == null) {
            return false;
        }
        if (!(previousT instanceof CommonToken && firstT instanceof CommonToken && secondT instanceof CommonToken)) {
            return false;
        }
        CommonToken previous = (CommonToken)previousT;
        CommonToken first = (CommonToken)firstT;
        CommonToken second = (CommonToken)secondT;
        if (this.isArithmeticOperator(previous)) {
            return false;
        }
        if (this.directlyFollows(previous, first) && this.isOperator(first)) {
            return false;
        }
        if (this.isArithmeticOperator(first) && this.isArithmeticOperator(second)) {
            return false;
        }
        return !this.isArithmeticOperator(first) || this.isArithmeticOperator(second) || this.directlyFollows(first, second);
    }

    private boolean isOperator(CommonToken previous) {
        return this.isArithmeticOperator(previous) || previous.getType() == 74;
    }

    private boolean isArithmeticOperator(CommonToken previous) {
        return previous.getType() == 90 || previous.getType() == 85 || previous.getType() == 91 || previous.getType() == 89;
    }

    public boolean directlyFollows(TokenStream input) {
        return this.directlyFollows(input.LT(-1), input.LT(1));
    }

    public boolean notSemi(TokenStream input) {
        return this.notSemi(input.LT(1));
    }

    public boolean notSemi(Token token) {
        return !this.isSemi(token);
    }

    private boolean isSemi(Token token) {
        return token != null && token instanceof CommonToken && token.getType() == 70;
    }

    public boolean directlyFollows(Token first, Token second) {
        if (!(first instanceof CommonToken) || !(second instanceof CommonToken)) {
            return false;
        }
        CommonToken firstT = (CommonToken)first;
        CommonToken secondT = (CommonToken)second;
        return this.directlyFollows(firstT, secondT);
    }

    private boolean directlyFollows(CommonToken firstT, CommonToken secondT) {
        if (firstT.getStopIndex() + 1 != secondT.getStartIndex()) {
            return false;
        }
        String text = firstT.getText();
        if (text == null || text.isEmpty()) {
            return true;
        }
        String substring = text.substring(text.length() - 1);
        return substring.equals(substring.trim());
    }

    public boolean isWhenKeyword(Token token) {
        if (token == null || !(token instanceof CommonToken) || token.getType() != 76) {
            return false;
        }
        String word = token.getText().trim().toLowerCase();
        return "when".equals(word);
    }

    public boolean onEmptyCombinator(TokenStream input) {
        return this.isEmptyCombinator(input.LT(-1), input.LT(1));
    }

    private boolean isEmptyCombinator(Token first, Token second) {
        return !this.directlyFollows(first, second);
    }

    public boolean isCharset(Token token) {
        return this.isVendorPrefixedAtName(token, CHARSET);
    }

    public boolean isKeyframes(Token token) {
        return this.isVendorPrefixedAtName(token, KEYFRAMES);
    }

    public boolean isDocument(Token token) {
        return this.isVendorPrefixedAtName(token, DOCUMENT);
    }

    public boolean isViewport(Token token) {
        return this.isVendorPrefixedAtName(token, VIEWPORT);
    }

    public boolean isSupports(Token token) {
        return this.isVendorPrefixedAtName(token, SUPPORTS);
    }

    public boolean isPageMarginBox(Token token) {
        return this.isAmongAtNames(token, PAGE_MARGIN_BOXES);
    }

    private boolean isAmongAtNames(Token token, Set<String> atNames) {
        if (token.getType() != 68 || token.getText() == null) {
            return false;
        }
        String text = token.getText().toLowerCase();
        return atNames.contains(text);
    }

    private boolean isVendorPrefixedAtName(Token token, String atName) {
        if (token.getType() != 68 || token.getText() == null) {
            return false;
        }
        String text = token.getText().toLowerCase();
        return text.startsWith("@") && text.endsWith(atName);
    }

    public boolean truthy() {
        return true;
    }

    static {
        NTH_PSEUDOCLASSES.add("nth-child");
        NTH_PSEUDOCLASSES.add("nth-last-child");
        NTH_PSEUDOCLASSES.add("nth-of-type");
        NTH_PSEUDOCLASSES.add("nth-last-of-type");
        EXTEND_PSEUDOCLASS = "extend";
        NOT_PSEUDOCLASS = "not";
    }
}

