/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.webdav;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.google.common.net.UrlEscapers;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.harvest.harvester.webdav.RemoteFile;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;

class WebDavRemoteFile
implements RemoteFile {
    private final Sardine sardine;
    private String path;
    private ISODate changeDate;

    public WebDavRemoteFile(Sardine sardine, String baseURL, DavResource davResource) {
        this.sardine = sardine;
        this.path = baseURL + UrlEscapers.urlFragmentEscaper().escape(davResource.getPath());
        Date modifiedDate = davResource.getModified();
        if (modifiedDate == null) {
            modifiedDate = Calendar.getInstance().getTime();
        }
        this.changeDate = new ISODate(modifiedDate.getTime(), false);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public ISODate getChangeDate() {
        return this.changeDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getMetadata(SchemaManager schemaMan) throws Exception {
        Element element;
        InputStream in = null;
        try {
            in = this.sardine.get(this.path);
            element = Xml.loadStream((InputStream)in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return element;
    }

    @Override
    public boolean isMoreRecentThan(String localChangeDate) {
        ISODate remoteDate = this.changeDate;
        ISODate localDate = new ISODate(localChangeDate);
        return remoteDate.timeDifferenceInSeconds(localDate) > 0L;
    }
}

