/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.thredds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLHandshakeException;
import jeeves.server.context.ServiceContext;
import jeeves.xlink.Processor;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Constants;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.exceptions.BadServerCertificateEx;
import org.fao.geonet.exceptions.BadXmlResponseEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataOperations;
import org.fao.geonet.kernel.datamanager.IMetadataSchemaUtils;
import org.fao.geonet.kernel.harvest.BaseAligner;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.GroupMapper;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.IHarvester;
import org.fao.geonet.kernel.harvest.harvester.RecordInfo;
import org.fao.geonet.kernel.harvest.harvester.UriMapper;
import org.fao.geonet.kernel.harvest.harvester.thredds.ThreddsParams;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.util.Sha1Encoder;
import org.fao.geonet.utils.AbstractHttpRequest;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.StringUtil2;

class Harvester
extends BaseAligner<ThreddsParams>
implements IHarvester<HarvestResult> {
    private static final Namespace invCatalog = Namespace.getNamespace((String)"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0");
    private static final Namespace wms = Namespace.getNamespace((String)"http://www.opengis.net/wms");
    private static final Namespace gmd = Namespace.getNamespace((String)"gmd", (String)"http://www.isotc211.org/2005/gmd");
    private static final Namespace srv = Namespace.getNamespace((String)"srv", (String)"http://www.isotc211.org/2005/srv");
    private static final Namespace xlink = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
    private static final Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private static final Namespace gco = Namespace.getNamespace((String)"gco", (String)"http://www.isotc211.org/2005/gco");
    private static final Namespace gmi = Namespace.getNamespace((String)"gmi", (String)"http://www.isotc211.org/2005/gmi");
    private static final Namespace gmx = Namespace.getNamespace((String)"gmx", (String)"http://www.isotc211.org/2005/gmx");
    private static final Namespace gsr = Namespace.getNamespace((String)"gsr", (String)"http://www.isotc211.org/2005/gsr");
    private static final Namespace gss = Namespace.getNamespace((String)"gss", (String)"http://www.isotc211.org/2005/gss");
    private static final Namespace gts = Namespace.getNamespace((String)"gts", (String)"http://www.isotc211.org/2005/gts");
    private static final Namespace gml32 = Namespace.getNamespace((String)"gml", (String)"http://www.opengis.net/gml/3.2");
    private static final Namespace xs = Namespace.getNamespace((String)"xs", (String)"http://www.w3.org/2001/XMLSchema");
    private Logger log;
    private ServiceContext context;
    private SchemaManager schemaMan;
    private CategoryMapper localCateg;
    private GroupMapper localGroups;
    private UriMapper localUris;
    private HarvestResult result;
    private String hostUrl;
    private HashSet<String> harvestUris = new HashSet();
    private Map<String, ThreddsService> services = new HashMap<String, ThreddsService>();
    private InvCatalogImpl catalog;
    private List<HarvestError> errors;
    private LatLonRect globalLatLonBox = null;
    private DateRange globalDateRange = null;
    private Element wmsResponse = null;
    private Element isoResponse = null;
    private Map<String, ThreddsMetadata.Variable> gridVariables = new HashMap<String, ThreddsMetadata.Variable>();
    private boolean metadataObtained = false;
    private boolean datasetMetadataObtained = false;
    private String metadataGetService;
    private List<Namespace> iso191152NamespaceList = new ArrayList<Namespace>();
    private List<InvDocumentation> docs = null;
    private IMetadataManager mdManager;
    private IMetadataSchemaUtils mdSchemaUtils;
    private IMetadataOperations mdOperations;
    private IMetadataIndexer mdIndexer;
    private DataManager dataMan;
    private GeonetworkDataDirectory dataDirectory;

    public Harvester(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, ThreddsParams params, List<HarvestError> errors) {
        super(cancelMonitor);
        this.log = log;
        this.context = context;
        this.params = params;
        this.errors = errors;
        this.result = new HarvestResult();
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        this.schemaMan = (SchemaManager)gc.getBean(SchemaManager.class);
        this.metadataGetService = "local://" + context.getNodeId() + "/api/records/";
        this.iso191152NamespaceList = this.buildISO191152NamespaceList();
        this.mdManager = (IMetadataManager)gc.getBean(IMetadataManager.class);
        this.mdSchemaUtils = (IMetadataSchemaUtils)gc.getBean(IMetadataSchemaUtils.class);
        this.mdOperations = (IMetadataOperations)gc.getBean(IMetadataOperations.class);
        this.mdIndexer = (IMetadataIndexer)gc.getBean(IMetadataIndexer.class);
        this.dataMan = (DataManager)gc.getBean(DataManager.class);
        this.dataDirectory = (GeonetworkDataDirectory)gc.getBean(GeonetworkDataDirectory.class);
    }

    @Override
    public HarvestResult harvest(Logger log) throws Exception {
        this.log = log;
        Element xml = null;
        log.info("Retrieving remote metadata information for : " + ((ThreddsParams)this.params).getName());
        this.localUris = new UriMapper(this.context, ((ThreddsParams)this.params).getUuid());
        String url = ((ThreddsParams)this.params).url;
        try {
            XmlRequest req = ((GeonetHttpRequestFactory)this.context.getBean(GeonetHttpRequestFactory.class)).createXmlRequest();
            req.setUrl(new URL(url));
            req.setMethod(AbstractHttpRequest.Method.GET);
            Lib.net.setupProxy(this.context, req);
            xml = req.execute();
        }
        catch (SSLHandshakeException e) {
            throw new BadServerCertificateEx("Most likely cause: The thredds catalog " + url + " does not have a valid certificate. If you feel this is because the server may be using a test certificate rather than a certificate from a well known certification authority, then you can add this certificate to the GeoNetwork keystore using bin/installCert");
        }
        this.harvestCatalog(xml);
        for (String localUri : this.localUris.getUris()) {
            if (this.cancelMonitor.get()) {
                return this.result;
            }
            if (this.harvestUris.contains(localUri)) continue;
            for (RecordInfo record : this.localUris.getRecords(localUri)) {
                if (this.cancelMonitor.get()) {
                    return this.result;
                }
                if (log.isDebugEnabled()) {
                    log.debug("  - Removing deleted metadata with id: " + record.id);
                }
                this.mdManager.deleteMetadata(this.context, record.id);
                if (record.isTemplate.equals("s")) {
                    Processor.uncacheXLinkUri((String)(this.metadataGetService + record.uuid));
                    ++this.result.subtemplatesRemoved;
                    continue;
                }
                ++this.result.locallyRemoved;
            }
        }
        this.mdManager.flush();
        this.result.totalMetadata = this.result.serviceRecords + this.result.collectionDatasetRecords;
        return this.result;
    }

    private void harvestCatalog(Element cata) throws Exception {
        if (cata == null) {
            return;
        }
        this.localCateg = new CategoryMapper(this.context);
        this.localGroups = new GroupMapper(this.context);
        Lib.net.setupProxy(this.context);
        InvCatalogFactory factory = new InvCatalogFactory("default", true);
        this.catalog = factory.readXML(((ThreddsParams)this.params).url);
        StringBuilder buff = new StringBuilder();
        if (!this.catalog.check(buff, true)) {
            throw new BadXmlResponseEx("Invalid catalog " + ((ThreddsParams)this.params).url + "\n" + buff.toString());
        }
        this.log.info("Catalog read from " + ((ThreddsParams)this.params).url + " is \n" + factory.writeXML(this.catalog));
        Path schemaDir = this.schemaMan.getSchemaDir(((ThreddsParams)this.params).outputSchema);
        Path serviceStyleSheet = this.dataDirectory.getXsltConversion("schema:" + ((ThreddsParams)this.params).outputSchema + ":convert/ThreddsCatalogto19119ThreddsCatalog-to-19119");
        Path datasetStyleSheet = this.dataDirectory.getXsltConversion("schema:" + ((ThreddsParams)this.params).outputSchema + ":convert/ThreddsCatalogto19119ThreddsCatalog-to-19139");
        Path dataParamsNCSSStylesheet = null;
        if (schemaDir.toString().contains("iso19139.mcp")) {
            dataParamsNCSSStylesheet = schemaDir.resolve("convert/ThreddsCatalogto19119").resolve("NetcdfSubsetDataset-to-ISO19139MCPDataParameters.xsl");
        } else if (schemaDir.toString().contains("iso19115-2")) {
            dataParamsNCSSStylesheet = schemaDir.resolve("convert/ThreddsCatalogto19119").resolve("NetcdfSubsetDataset-to-ISO191152contentInfo.xsl");
        }
        URL url = new URL(((ThreddsParams)this.params).url);
        this.hostUrl = url.getProtocol() + "://" + url.getHost();
        if (url.getPort() != -1) {
            this.hostUrl = this.hostUrl + ":" + url.getPort();
        }
        this.log.info("Crawling the datasets in the catalog....");
        List dsets = this.catalog.getDatasets();
        for (InvDataset ds : dsets) {
            if (this.cancelMonitor.get()) {
                return;
            }
            this.crawlDatasets(ds);
        }
        if (((ThreddsParams)this.params).createServiceMd) {
            this.processServices(cata, serviceStyleSheet);
        }
        this.log.info("Adding dataset metadata...");
        this.createDatasetMetadata(cata, datasetStyleSheet, dataParamsNCSSStylesheet);
        int totalDs = this.result.collectionDatasetRecords;
        this.log.info("Processed " + totalDs + " datasets.");
    }

    private void crawlDatasets(InvDataset catalogDs) throws Exception {
        this.log.info("Crawling through " + catalogDs.getName());
        InvDataset realDs = catalogDs;
        if (catalogDs instanceof InvCatalogRef) {
            InvDatasetImpl proxyDataset = ((InvCatalogRef)catalogDs).getProxyDataset();
            Object object = realDs = proxyDataset.getName().equals(catalogDs.getName()) ? proxyDataset : catalogDs;
        }
        if (realDs.hasNestedDatasets() && !realDs.getName().contains("latest")) {
            if (this.hasThreddsMetadata(realDs)) {
                this.extractThreddsMetadata(realDs);
            }
            List dsets = realDs.getDatasets();
            for (InvDataset ds : dsets) {
                this.crawlDatasets(ds);
            }
        } else {
            this.log.info("Processing dataset: " + realDs.getName() + " with URL: " + this.getUri(realDs));
            this.examineThreddsDataset(realDs);
        }
        if (catalogDs instanceof InvCatalogRef) {
            ((InvCatalogRef)catalogDs).release();
        }
    }

    private void extractThreddsMetadata(InvDataset ds) {
        List variablesList;
        DateRange dr;
        this.log.info("Trying to find ThreddsMetadata for dataset " + ds.getName());
        ThreddsMetadata.GeospatialCoverage gsC = ds.getGeospatialCoverage();
        if (gsC != null) {
            this.log.info("Found ThreddsMetadata geospatialcoverage");
            this.addLatLonBox(gsC.getBoundingBox());
        }
        if ((dr = ds.getTimeCoverage()) != null) {
            this.log.info("Found ThreddsMetadata daterange");
            this.addTimeSpan(dr);
        }
        if ((variablesList = ds.getVariables()) != null && variablesList.size() > 0) {
            this.log.info("Found ThreddsMetadata variables");
            for (ThreddsMetadata.Variables variables : variablesList) {
                List variableList = variables.getVariableList();
                for (ThreddsMetadata.Variable variable : variableList) {
                    this.gridVariables.put(variable.getName(), variable);
                }
            }
        }
        if (gsC != null && dr != null && this.gridVariables.size() > 0) {
            this.metadataObtained = true;
        }
        this.docs = ds.getDocumentation();
        if (this.docs != null && this.docs.size() > 0) {
            this.log.info("Found ThreddsMetadata documentation");
        }
    }

    private boolean hasThreddsMetadata(InvDataset ds) {
        ThreddsMetadata.GeospatialCoverage gsC = ds.getGeospatialCoverage();
        DateRange dr = ds.getTimeCoverage();
        List vars = ds.getVariables();
        List docs = ds.getDocumentation();
        this.log.debug("ThreddsMetadata: " + gsC + " : " + dr + " : " + vars.size() + " : " + docs);
        return gsC != null || dr != null || vars.size() > 0 || docs != null;
    }

    private void saveMetadata(Element md, String uuid, String uri, boolean isService) throws Exception {
        md.removeNamespaceDeclaration(invCatalog);
        String schema = this.mdSchemaUtils.autodetectSchema(md, null);
        if (schema == null) {
            this.log.warning("Skipping metadata with unknown schema.");
            ++this.result.unknownSchema;
        }
        this.log.info("  - Adding metadata with " + uuid + " schema is set to " + schema + "\n XML is " + Xml.getString((Element)md));
        this.deleteExistingMetadata(uri);
        Metadata metadata = new Metadata();
        metadata.setUuid(uuid);
        metadata.getDataInfo().setSchemaId(schema).setRoot(md.getQualifiedName()).setType(MetadataType.METADATA);
        metadata.getSourceInfo().setSourceId(((ThreddsParams)this.params).getUuid()).setOwner(Integer.valueOf(this.getOwner())).setGroupOwner(Integer.valueOf(((ThreddsParams)this.params).getOwnerIdGroup()));
        metadata.getHarvestInfo().setHarvested(true).setUuid(((ThreddsParams)this.params).getUuid()).setUri(uri);
        if (!isService) {
            if (((ThreddsParams)this.params).datasetCategory != null && !((ThreddsParams)this.params).datasetCategory.equals("")) {
                MetadataCategory metadataCategory = (MetadataCategory)((MetadataCategoryRepository)this.context.getBean(MetadataCategoryRepository.class)).findById((Object)Integer.parseInt(((ThreddsParams)this.params).datasetCategory)).get();
                if (metadataCategory == null) {
                    throw new IllegalArgumentException("No category found with name: " + ((ThreddsParams)this.params).datasetCategory);
                }
                metadata.getMetadataCategories().add(metadataCategory);
            }
        } else {
            this.addCategories((AbstractMetadata)metadata, ((ThreddsParams)this.params).getCategories(), this.localCateg, this.context, null, false);
        }
        metadata = (Metadata)this.mdManager.insertMetadata(this.context, (AbstractMetadata)metadata, md, IndexingMode.none, false, UpdateDatestamp.NO, false, false);
        String id = String.valueOf(metadata.getId());
        this.addPrivileges(id, ((ThreddsParams)this.params).getPrivileges(), this.localGroups, this.context);
        this.mdIndexer.indexMetadata(id, true, IndexingMode.full);
        this.mdManager.flush();
    }

    private void examineThreddsDataset(InvDataset ds) throws Exception {
        this.getMetadata(ds);
        this.harvestUris.add(this.getUri(ds));
        List accesses = ds.getAccess();
        for (InvAccess access : accesses) {
            this.processService(access.getService(), this.getUuid(ds), ds);
        }
    }

    private void processService(InvService serv, String uuid, InvDataset ds) {
        ArrayList<InvService> servs = new ArrayList<InvService>();
        if (serv.getServiceType() == ServiceType.COMPOUND) {
            servs.addAll(serv.getServices());
        } else {
            servs.add(serv);
        }
        for (InvService s : servs) {
            InvAccess access;
            if (s.getServiceType().equals((Object)ServiceType.RESOLVER)) continue;
            Object sUrl = "";
            sUrl = !s.isRelativeBase() ? s.getBase() : this.hostUrl + s.getBase();
            this.log.info("Processing service: " + (String)sUrl + " for " + ds.getName());
            ThreddsService ts = this.services.get(sUrl);
            if (ts == null) {
                ts = new ThreddsService();
                ts.service = s;
                ts.version = this.getVersion(serv, ds);
                ts.ops = this.getServerOperations(serv, ds);
                this.services.put((String)sUrl, ts);
            }
            if ((access = ds.getAccess(s.getServiceType())) == null) continue;
            String url = access.getStandardUrlName();
            ts.datasetUrls.add(url);
        }
    }

    private String getVersion(InvService serv, InvDataset ds) {
        String result = "unknown";
        if (serv.getServiceType() == ServiceType.OPENDAP) {
            String href;
            String readResult;
            InvAccess access = ds.getAccess(ServiceType.OPENDAP);
            if (access != null && (readResult = this.getResultFromHttpUrl(href = access.getStandardUrlName() + ".ver")) != null) {
                result = readResult;
            }
        } else if (serv.getServiceType() == ServiceType.HTTPServer) {
            result = "HTTP/1.1";
        } else if (serv.getServiceType() == ServiceType.WMS) {
            result = "1.3.0";
        }
        return result;
    }

    private String getServerOperations(InvService serv, InvDataset ds) {
        String href;
        String readResult;
        InvAccess access;
        String result = "none";
        if (serv.getServiceType() == ServiceType.OPENDAP && (access = ds.getAccess(ServiceType.OPENDAP)) != null && (readResult = this.getResultFromHttpUrl(href = access.getStandardUrlName() + ".help")) != null) {
            result = readResult;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResultFromHttpUrl(String href) {
        String result = null;
        try {
            InputStream is;
            InputStreamReader isr;
            BufferedReader dis;
            block7: {
                URL url = new URL(href);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                Object o = conn.getContent();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Opened " + href + " and got class " + o.getClass().getName());
                }
                StringBuffer version = new StringBuffer();
                dis = null;
                isr = null;
                is = null;
                try {
                    String inputLine;
                    is = conn.getInputStream();
                    isr = new InputStreamReader(is, Constants.ENCODING);
                    dis = new BufferedReader(isr);
                    while ((inputLine = dis.readLine()) != null) {
                        version.append(inputLine + "\n");
                    }
                    result = version.toString();
                    if (!this.log.isDebugEnabled()) break block7;
                    this.log.debug("Read from URL:\n" + result);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)is);
                    IOUtils.closeQuietly(isr);
                    IOUtils.closeQuietly(dis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((Reader)isr);
            IOUtils.closeQuietly((Reader)dis);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Caught exception " + e + " whilst attempting to query URL " + href);
            }
            e.printStackTrace();
        }
        return result;
    }

    private String getUri(InvDataset ds) {
        if (ds.getID() == null) {
            return ds.getParentCatalog().getUriString() + "#" + ds.getName();
        }
        return this.getSubsetUrl(ds);
    }

    private String getSubsetUrl(InvDataset ds) {
        try {
            return ds.getParentCatalog().getUriString() + "?dataset=" + URLEncoder.encode(ds.getID(), Constants.ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("Thrown Exception " + e + " during dataset processing");
            e.printStackTrace();
            return null;
        }
    }

    private void deleteExistingMetadata(String uri) throws Exception {
        List<RecordInfo> localRecords = this.localUris.getRecords(uri);
        if (localRecords == null) {
            return;
        }
        for (RecordInfo record : localRecords) {
            this.mdManager.deleteMetadata(this.context, record.id);
            if (!record.isTemplate.equals("s")) continue;
            Processor.uncacheXLinkUri((String)(this.metadataGetService + record.uuid));
        }
    }

    private String getUuid(InvDataset ds) {
        String uuid = ds.getUniqueID();
        uuid = uuid == null ? Sha1Encoder.encodeString((String)ds.getCatalogUrl()) : StringUtil2.allow((String)uuid, (String)"_-.", (char)'-');
        return uuid;
    }

    private Element getXMLResponse(String url) throws MalformedURLException, IOException {
        XmlRequest req = ((GeonetHttpRequestFactory)this.context.getBean(GeonetHttpRequestFactory.class)).createXmlRequest();
        req.setUrl(new URL(url));
        req.setMethod(AbstractHttpRequest.Method.GET);
        Lib.net.setupProxy(this.context, req);
        return req.execute();
    }

    private void getMetadata(InvDataset ds) {
        try {
            if (!this.metadataObtained) {
                this.datasetMetadataObtained = false;
                if (this.hasWMSService(ds)) {
                    this.extractMetadataFromWMS(ds);
                }
                if (!this.datasetMetadataObtained && this.hasNetcdfSubsetService(ds)) {
                    this.extractMetadataFromNetcdfSubsetService(ds);
                }
                if (!this.datasetMetadataObtained && this.hasISOService(ds)) {
                    this.extractMetadataFromISO(ds);
                }
                if (!this.datasetMetadataObtained) {
                    this.extractMetadataFromOpendapDDX(ds);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Thrown Exception " + e + " during dataset processing");
            e.printStackTrace();
        }
    }

    private boolean hasNetcdfSubsetService(InvDataset ds) {
        return ds.getAccess(ServiceType.NetcdfSubset) != null;
    }

    private boolean hasWMSService(InvDataset ds) {
        return ds.getAccess(ServiceType.WMS) != null;
    }

    private boolean hasISOService(InvDataset ds) {
        return ds.getAccess(ServiceType.ISO) != null;
    }

    private void extractMetadataFromISO(InvDataset ds) {
        try {
            String url = "";
            InvAccess access = null;
            access = ds.getAccess(ServiceType.ISO);
            if (access != null) {
                url = access.getStandardUrlName();
                this.log.debug("ISO url is " + url);
                this.isoResponse = this.getXMLResponse(url);
                this.log.debug("Name of root element in response is " + this.isoResponse.getName());
                if (this.isoResponse.getName().equals("MI_Metadata")) {
                    Element latLonBox = Xml.selectElement((Element)this.isoResponse, (String)"*//gmd:MD_DataIdentification//gmd:EX_GeographicBoundingBox", this.iso191152NamespaceList);
                    if (latLonBox == null) {
                        this.log.error("Cannot find ISO19115-2 EX_GeographicBoundingBox element!");
                        return;
                    }
                    Element timeSpan = Xml.selectElement((Element)this.isoResponse, (String)"*//gmd:MD_DataIdentification//gml:TimePeriod", this.iso191152NamespaceList);
                    if (timeSpan == null) {
                        this.log.error("Cannot find ISO19115-2 TimePeriod element!");
                        return;
                    }
                    List contentInfo = Xml.selectNodes((Element)this.isoResponse, (String)"gmd:contentInfo/gmi:MI_CoverageDescription/gmd:dimension/gmd:MD_Band", this.iso191152NamespaceList);
                    if (contentInfo == null) {
                        this.log.error("Cannot find ISO19115-2 contentInfo element!");
                        return;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Bounding box is:\n" + Xml.getString((Element)latLonBox) + "\n Time span is:\n" + Xml.getString((Element)timeSpan) + "\nContent Info has " + contentInfo.size() + " bands");
                    }
                    this.datasetMetadataObtained = this.addISOLatLonBox(latLonBox) && this.addISOTimeSpan(timeSpan) && this.extractISOVariables(contentInfo);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Thrown Exception " + e + " during dataset processing");
            e.printStackTrace();
        }
    }

    private boolean addISOLatLonBox(Element bbox) {
        boolean result = false;
        try {
            Element westE = bbox.getChild("westBoundLongitude", gmd);
            Element eastE = bbox.getChild("eastBoundLongitude", gmd);
            Element southE = bbox.getChild("southBoundLatitude", gmd);
            Element northE = bbox.getChild("northBoundLatitude", gmd);
            if (westE != null && eastE != null && northE != null && southE != null) {
                double west = Double.parseDouble(westE.getChildText("Decimal", gco));
                double east = Double.parseDouble(eastE.getChildText("Decimal", gco));
                double south = Double.parseDouble(southE.getChildText("Decimal", gco));
                double north = Double.parseDouble(northE.getChildText("Decimal", gco));
                LatLonRect thisBox = new LatLonRect((LatLonPoint)new LatLonPointImpl(south, west), (LatLonPoint)new LatLonPointImpl(north, east));
                this.addLatLonBox(thisBox);
                result = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private boolean addISOTimeSpan(Element dimension) {
        boolean result = false;
        String startTime = dimension.getChildText("beginPosition", gml32);
        String endTime = dimension.getChildText("endPosition", gml32);
        if (startTime != null && endTime != null && startTime.length() > 0 && endTime.length() > 0) {
            ISODate st = new ISODate(startTime);
            ISODate et = new ISODate(endTime);
            DateRange thisDateRange = new DateRange(st.toDate(), et.toDate());
            this.addTimeSpan(thisDateRange);
            result = true;
        }
        return result;
    }

    private boolean extractISOVariables(List<?> bands) {
        boolean result = false;
        try {
            for (Object o : bands) {
                String layerDesc;
                String layerName;
                Element band;
                Element layer;
                if (!(o instanceof Element) || (layer = Xml.selectElement((Element)(band = (Element)o), (String)"*//gco:aName/gco:CharacterString", this.iso191152NamespaceList)) == null || (layerName = layer.getText()).length() <= 0) continue;
                ThreddsMetadata.Variable var = new ThreddsMetadata.Variable();
                var.setName(layerName);
                Element desc = Xml.selectElement((Element)band, (String)"*//gmd:descriptor/gco:CharacterString", this.iso191152NamespaceList);
                if (desc != null && (layerDesc = desc.getText()).length() > 0) {
                    var.setDescription(layerDesc);
                }
                this.gridVariables.put(layerName, var);
                result = true;
            }
        }
        catch (JDOMException je) {
            je.printStackTrace();
        }
        return result;
    }

    private List<Namespace> buildISO191152NamespaceList() {
        ArrayList<Namespace> nsList = new ArrayList<Namespace>();
        nsList.add(xsi);
        nsList.add(gco);
        nsList.add(gmd);
        nsList.add(gmi);
        nsList.add(srv);
        nsList.add(gmx);
        nsList.add(gsr);
        nsList.add(gss);
        nsList.add(gts);
        nsList.add(gml32);
        nsList.add(xlink);
        nsList.add(xs);
        return nsList;
    }

    private void extractMetadataFromWMS(InvDataset ds) {
        try {
            Object url = "";
            InvAccess access = null;
            access = ds.getAccess(ServiceType.WMS);
            if (access != null) {
                url = access.getStandardUrlName();
                this.log.debug("WMS url is " + (String)url);
                url = (String)url + "?request=GetCapabilities&version=1.3.0&service=WMS";
                this.wmsResponse = this.getXMLResponse((String)url);
                if (this.wmsResponse.getName().equals("WMS_Capabilities")) {
                    List<Element> layers = this.findLayers(this.wmsResponse);
                    this.log.debug("Found " + layers.size() + " layers in WMS_Capabilities");
                    if (layers.size() > 0) {
                        Element bbox = layers.get(0).getChild("BoundingBox", wms);
                        if (bbox == null) {
                            this.log.error("Cannot find OGC WMS BoundingBox element!");
                            return;
                        }
                        Element dimension = layers.get(0).getChild("Dimension", wms);
                        if (dimension == null || !dimension.getAttributeValue("name").equals("time")) {
                            this.log.error("Cannot find OGC WMS Dimension element!");
                            return;
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Bounding box is:\n" + Xml.getString((Element)bbox) + "\n Time span is:\n" + Xml.getString((Element)dimension));
                        }
                        this.datasetMetadataObtained = this.addWMSLatLonBox(bbox) && this.addWMSTimeSpan(dimension) && this.extractWMSVariables(layers);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error("Thrown Exception " + e + " during dataset processing");
            e.printStackTrace();
        }
    }

    private List<Element> findLayers(Element datasetXml) {
        ArrayList<Element> layers = new ArrayList<Element>();
        Iterator iter = datasetXml.getDescendants();
        while (iter.hasNext()) {
            Element layer;
            Object o = iter.next();
            if (!(o instanceof Element) || !(layer = (Element)o).getName().equals("Layer") || !layer.getAttributeValue("queryable", "0").equals("1") || layer.getChild("BoundingBox", wms) == null || layer.getChild("Dimension", wms) == null) continue;
            layers.add(layer);
        }
        return layers;
    }

    private boolean addWMSLatLonBox(Element bbox) {
        boolean result = false;
        try {
            double west = Double.parseDouble(bbox.getAttributeValue("minx"));
            double east = Double.parseDouble(bbox.getAttributeValue("maxx"));
            double south = Double.parseDouble(bbox.getAttributeValue("miny"));
            double north = Double.parseDouble(bbox.getAttributeValue("maxy"));
            LatLonRect thisBox = new LatLonRect((LatLonPoint)new LatLonPointImpl(south, west), (LatLonPoint)new LatLonPointImpl(north, east));
            this.addLatLonBox(thisBox);
            result = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private boolean addWMSTimeSpan(Element dimension) {
        boolean result = false;
        String[] times = dimension.getText().split(",");
        String startTime = times[0].trim();
        String endTime = times[times.length - 1].trim();
        if (startTime != null && endTime != null && startTime.length() > 0 && endTime.length() > 0) {
            ISODate st = new ISODate(startTime);
            ISODate et = new ISODate(endTime);
            DateRange thisDateRange = new DateRange(st.toDate(), et.toDate());
            this.addTimeSpan(thisDateRange);
            result = true;
        }
        return result;
    }

    private boolean extractWMSVariables(List<Element> layers) {
        boolean result = false;
        for (Element layer : layers) {
            String layerName = layer.getChildText("Name", wms);
            String layerDesc = layer.getChildText("Abstract", wms);
            if (layerName == null) continue;
            ThreddsMetadata.Variable var = new ThreddsMetadata.Variable();
            var.setName(layerName);
            if (layerDesc != null) {
                var.setDescription(layerDesc);
            }
            this.gridVariables.put(layerName, var);
            result = true;
        }
        return result;
    }

    private void extractMetadataFromNetcdfSubsetService(InvDataset ds) {
        try {
            InvAccess access = ds.getAccess(ServiceType.NetcdfSubset);
            Object url = access.getStandardUrlName();
            this.log.info("NCSS url is " + (String)url);
            url = (String)url + "/dataset.xml";
            Element xml = this.getXMLResponse((String)url);
            Element latLonBox = xml.getChild("LatLonBox");
            if (latLonBox == null) {
                this.log.error("Cannot find LatLonBox element!, skipping dataset");
                return;
            }
            Element timeSpan = xml.getChild("TimeSpan");
            if (timeSpan == null) {
                this.log.error("Cannot find TimeSpan element!, skipping dataset");
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Bounding box is:\n" + Xml.getString((Element)latLonBox) + "\n Time span is:\n" + Xml.getString((Element)timeSpan));
            }
            this.datasetMetadataObtained = this.addNCSSLatLonBox(latLonBox) && this.addNCSSTimeSpan(timeSpan) && this.extractNCSSVariables(xml);
        }
        catch (Exception e) {
            this.log.error("Thrown Exception " + e + " during dataset processing");
            e.printStackTrace();
        }
    }

    private boolean addNCSSLatLonBox(Element latLonBox) {
        boolean result = false;
        try {
            double west = Double.parseDouble(latLonBox.getChildText("west"));
            double east = Double.parseDouble(latLonBox.getChildText("east"));
            double south = Double.parseDouble(latLonBox.getChildText("south"));
            double north = Double.parseDouble(latLonBox.getChildText("north"));
            LatLonRect thisBox = new LatLonRect((LatLonPoint)new LatLonPointImpl(south, west), (LatLonPoint)new LatLonPointImpl(north, east));
            this.addLatLonBox(thisBox);
            result = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private boolean addNCSSTimeSpan(Element timeSpan) {
        boolean result = false;
        String bt = timeSpan.getChildText("begin");
        String et = timeSpan.getChildText("end");
        if (bt != null && et != null && bt.length() > 0 && et.length() > 0) {
            ISODate beginDate = new ISODate(bt);
            ISODate endDate = new ISODate(et);
            DateRange thisDateRange = new DateRange(beginDate.toDate(), endDate.toDate());
            this.addTimeSpan(thisDateRange);
            result = true;
        }
        return result;
    }

    private boolean extractNCSSVariables(Element xml) {
        boolean result = false;
        try {
            List grids = Xml.selectNodes((Element)xml, (String)"gridSet/grid");
            for (Object o : grids) {
                Element grid;
                String name;
                if (!(o instanceof Element) || (name = (grid = (Element)o).getAttributeValue("name")) == null) continue;
                ThreddsMetadata.Variable var = new ThreddsMetadata.Variable();
                var.setName(name);
                List attrs = grid.getChildren("attribute");
                for (Object oa : attrs) {
                    if (!(oa instanceof Element)) continue;
                    Element attr = (Element)oa;
                    String attrName = attr.getAttributeValue("name");
                    if (attrName.equals("long_name")) {
                        var.setDescription(attr.getAttributeValue("value"));
                        continue;
                    }
                    if (!attrName.equals("units")) continue;
                    var.setUnits(attr.getAttributeValue("value"));
                }
                this.gridVariables.put(name, var);
                result = true;
            }
        }
        catch (JDOMException je) {
            je.printStackTrace();
        }
        return result;
    }

    private void extractMetadataFromOpendapDDX(InvDataset ds) {
        try {
            InvAccess access = ds.getAccess(ServiceType.OPENDAP);
            Object url = access.getStandardUrlName();
            this.log.info("Opendap url is " + (String)url);
            url = (String)url + ".ddx";
            Element xml = this.getXMLResponse((String)url);
            if (this.extractDDXVariables(xml)) {
                this.datasetMetadataObtained = true;
            }
        }
        catch (Exception e) {
            this.log.error("Thrown Exception " + e + " during dataset processing");
            e.printStackTrace();
        }
    }

    private boolean extractDDXVariables(Element xml) {
        boolean result = false;
        Iterator iter = xml.getDescendants();
        while (iter.hasNext()) {
            Element array;
            String name;
            Object o = iter.next();
            if (!(o instanceof Element) || (name = (array = (Element)o).getAttributeValue("name")) == null) continue;
            ThreddsMetadata.Variable var = new ThreddsMetadata.Variable();
            var.setName(name);
            List attributes = array.getChildren("Attribute");
            for (Object oa : attributes) {
                if (!(oa instanceof Element)) continue;
                Element attr = (Element)oa;
                String attrName = attr.getAttributeValue("name");
                if (attrName.equals("long_name")) {
                    var.setDescription(attr.getChildText("value"));
                    continue;
                }
                if (!attrName.equals("units")) continue;
                var.setUnits(attr.getChildText("value"));
            }
            this.gridVariables.put(name, var);
            result = true;
        }
        return result;
    }

    private void addLatLonBox(LatLonRect thisBox) {
        if (this.globalLatLonBox == null) {
            this.globalLatLonBox = thisBox;
        } else {
            this.globalLatLonBox.extend(thisBox);
        }
    }

    private void addTimeSpan(DateRange thisDateRange) {
        if (this.globalDateRange == null) {
            this.globalDateRange = thisDateRange;
        } else {
            this.globalDateRange.extend(thisDateRange);
        }
    }

    private void processServices(Element cata, Path styleSheet) throws Exception {
        for (String sUrl : this.services.keySet()) {
            ThreddsService ts = this.services.get(sUrl);
            InvService serv = ts.service;
            String type = serv.getServiceType().toString();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Processing Thredds service: " + serv.toString());
            }
            String sUuid = Sha1Encoder.encodeString((String)sUrl);
            String urls = StringUtils.join(ts.datasetUrls, (String)"^^^");
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - XSLT transformation using " + styleSheet);
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("lang", ((ThreddsParams)this.params).lang);
            param.put("topic", ((ThreddsParams)this.params).topic);
            param.put("uuid", sUuid);
            param.put("url", urls);
            param.put("name", "Thredds Service " + serv.getName() + " at " + sUrl);
            param.put("type", serv.getServiceType().toString().toUpperCase());
            param.put("version", ts.version);
            param.put("desc", serv.toString());
            param.put("props", serv.getProperties().toString());
            param.put("serverops", ts.ops);
            param.put("bbox", this.globalLatLonBox.getLatMin() + "^^^" + this.globalLatLonBox.getLatMax() + "^^^" + this.globalLatLonBox.getLonMin() + "^^^" + this.globalLatLonBox.getLonMax());
            param.put("textent", this.globalDateRange.getStart().toDateTimeStringISO() + "^^^" + this.globalDateRange.getEnd().toDateTimeStringISO());
            Element md = Xml.transform((Element)cata, (Path)styleSheet, param);
            String schema = this.mdSchemaUtils.autodetectSchema(md, null);
            if (schema == null) {
                this.log.warning("Skipping metadata with unknown schema.");
                ++this.result.unknownSchema;
                continue;
            }
            boolean isService = true;
            this.saveMetadata(md, sUuid, sUrl, isService);
            this.harvestUris.add(sUrl);
            ++this.result.serviceRecords;
        }
    }

    private void createDatasetMetadata(Element cata, Path styleSheet, Path dataParamsNCSSStylesheet) throws Exception {
        Element md;
        String schema;
        String abst;
        Object title;
        String sUuid = Sha1Encoder.encodeString((String)((ThreddsParams)this.params).url);
        if (this.log.isDebugEnabled()) {
            this.log.debug("  - XSLT transformation using " + styleSheet);
        }
        if (((String)(title = ((ThreddsParams)this.params).datasetTitle)).equals("")) {
            title = "Thredds Dataset at " + ((ThreddsParams)this.params).url;
        }
        if ((abst = ((ThreddsParams)this.params).datasetAbstract).equals("")) {
            abst = "Thredds Dataset";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("lang", ((ThreddsParams)this.params).lang);
        param.put("topic", ((ThreddsParams)this.params).topic);
        param.put("uuid", sUuid);
        param.put("url", ((ThreddsParams)this.params).url);
        param.put("name", title);
        param.put("desc", abst);
        if (this.globalLatLonBox != null) {
            param.put("bbox", this.globalLatLonBox.getLatMin() + "^^^" + this.globalLatLonBox.getLatMax() + "^^^" + this.globalLatLonBox.getLonMin() + "^^^" + this.globalLatLonBox.getLonMax());
        }
        if (this.globalDateRange != null) {
            param.put("textent", this.globalDateRange.getStart().toDateTimeStringISO() + "^^^" + this.globalDateRange.getEnd().toDateTimeStringISO());
        }
        if ((schema = this.mdSchemaUtils.autodetectSchema(md = Xml.transform((Element)this.wmsResponse, (Path)styleSheet, param), null)) == null) {
            this.log.warning("Skipping metadata with unknown schema.");
            ++this.result.unknownSchema;
        } else {
            if (schema.contains("iso19139.mcp") && this.gridVariables != null) {
                Element dps = null;
                if (dataParamsNCSSStylesheet != null) {
                    Element gridVariablesXml = this.turnThreddsMetadataVariablesIntoXml();
                    dps = Xml.transform((Element)gridVariablesXml, (Path)dataParamsNCSSStylesheet);
                }
                if (dps != null) {
                    this.addDataParameters(md, dps);
                }
            }
            boolean isService = false;
            this.log.debug("Will save metadata " + Xml.getString((Element)md));
            this.saveMetadata(md, sUuid, ((ThreddsParams)this.params).url, isService);
            this.harvestUris.add(((ThreddsParams)this.params).url);
            ++this.result.collectionDatasetRecords;
        }
    }

    private Element turnThreddsMetadataVariablesIntoXml() {
        Element result = new Element("gridDataset");
        Element gridSet = new Element("gridSet");
        for (ThreddsMetadata.Variable var : this.gridVariables.values()) {
            Element grid = new Element("grid");
            grid.setAttribute("name", var.getName());
            Element attr = new Element("attribute");
            attr.setAttribute("name", "long_name");
            attr.setAttribute("value", var.getDescription());
            grid.addContent((Content)attr);
            attr = new Element("attribute");
            attr.setAttribute("name", "units");
            attr.setAttribute("value", var.getUnits());
            grid.addContent((Content)attr);
            gridSet.addContent((Content)grid);
        }
        result.addContent((Content)gridSet);
        this.log.debug("Thredds variables have been turned into: " + Xml.getString((Element)result));
        return result;
    }

    private Element addDataParameters(Element md, Element dataParameters) throws Exception {
        Element root = (Element)md.getChild("identificationInfo", gmd).getChildren().get(0);
        root.addContent((Content)dataParameters);
        return md;
    }

    private static class ThreddsService {
        public List<String> datasetUrls = new ArrayList<String>();
        public InvService service;
        public String version;
        public String ops;

        private ThreddsService() {
        }
    }
}

