/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet.v21_3;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Logger;
import org.fao.geonet.kernel.harvest.harvester.geonet.BaseGeoNetworkAligner;
import org.fao.geonet.kernel.harvest.harvester.geonet.v21_3.GeonetParams;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Element;

public class Aligner
extends BaseGeoNetworkAligner<GeonetParams> {
    private XmlRequest request;

    public Aligner(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, XmlRequest req, GeonetParams params, Element remoteInfo) {
        super(cancelMonitor, log, context, params);
        this.request = req;
        Element groups = remoteInfo.getChild("groups");
        if (groups == null) {
            groups = remoteInfo.getChild("group");
        }
        if (groups != null) {
            List list = groups.getChildren("group");
            this.setupLocEntity(list, this.hmRemoteGroups);
        }
    }

    private void setupLocEntity(List<Element> list, Map<String, Map<String, String>> hmEntity) {
        for (Element entity : list) {
            String name = entity.getChildText("name");
            HashMap<String, String> hm = new HashMap<String, String>();
            hmEntity.put(name, hm);
            List labels = entity.getChild("label").getChildren();
            for (Element el : labels) {
                hm.put(el.getName(), el.getText());
            }
        }
    }

    @Override
    protected Path retrieveMEF(String uuid) throws URISyntaxException, IOException {
        this.request.clearParams();
        this.request.addParam("uuid", (Object)uuid);
        this.request.addParam("format", (Object)(((GeonetParams)this.params).mefFormatFull ? "full" : "partial"));
        this.request.addParam("version", (Object)"2");
        this.request.addParam("relation", (Object)"false");
        this.request.setAddress(((GeonetParams)this.params).getServletPath() + "/" + ((GeonetParams)this.params).getNode() + "/eng/mef.export");
        Path tempFile = Files.createTempFile("temp-", ".dat", new FileAttribute[0]);
        this.request.executeLarge(tempFile);
        return tempFile;
    }
}

