/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.csw;

import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.Transactional;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.csw.common.CswOperation;
import org.fao.geonet.csw.common.CswServer;
import org.fao.geonet.csw.common.ElementSetName;
import org.fao.geonet.csw.common.requests.GetRecordByIdRequest;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.kernel.AddElemValue;
import org.fao.geonet.kernel.BatchEditParameter;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.EditLib;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.harvest.BaseAligner;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.GroupMapper;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.HarvesterUtil;
import org.fao.geonet.kernel.harvest.harvester.RecordInfo;
import org.fao.geonet.kernel.harvest.harvester.UUIDMapper;
import org.fao.geonet.kernel.harvest.harvester.csw.CswParams;
import org.fao.geonet.kernel.harvest.harvester.csw.Harvester;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.AbstractHttpRequest;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

public class Aligner
extends BaseAligner<CswParams> {
    private ServiceContext context;
    private DataManager dataMan;
    private CategoryMapper localCateg;
    private GroupMapper localGroups;
    private UUIDMapper localUuids;
    private IMetadataUtils metadataUtils;
    private IMetadataManager metadataManager;
    private IMetadataIndexer metadataIndexer;
    private HarvestResult result;
    private GetRecordByIdRequest request;
    private String processName;
    private Map<String, Object> processParams = new HashMap<String, Object>();
    private Logger log;
    private EsSearchManager searchManager;

    public Aligner(AtomicBoolean cancelMonitor, ServiceContext sc, CswServer server, CswParams params, Logger log) throws OperationAbortedEx {
        super(cancelMonitor);
        this.context = sc;
        this.params = params;
        this.log = log;
        GeonetContext gc = (GeonetContext)this.context.getHandlerContext("contextName");
        this.dataMan = (DataManager)gc.getBean(DataManager.class);
        this.metadataUtils = (IMetadataUtils)gc.getBean(IMetadataUtils.class);
        this.metadataManager = (IMetadataManager)gc.getBean(IMetadataManager.class);
        this.metadataIndexer = (IMetadataIndexer)gc.getBean(IMetadataIndexer.class);
        this.searchManager = (EsSearchManager)gc.getBean(EsSearchManager.class);
        this.result = new HarvestResult();
        this.result.unretrievable = 0;
        this.result.uuidSkipped = 0;
        this.result.couldNotInsert = 0;
        this.result.xpathFilterExcluded = 0;
        this.request = new GetRecordByIdRequest(sc);
        this.request.setElementSetName(ElementSetName.FULL);
        CswOperation oper = server.getOperation("GetRecordById");
        if (oper.getGetUrl() != null && Harvester.PREFERRED_HTTP_METHOD.equals("GET")) {
            this.request.setUrl(this.context, oper.getGetUrl());
            this.request.setMethod(AbstractHttpRequest.Method.GET);
        } else if (oper.getPostUrl() != null && Harvester.PREFERRED_HTTP_METHOD.equals("POST")) {
            this.request.setUrl(this.context, oper.getPostUrl());
            this.request.setMethod(AbstractHttpRequest.Method.POST);
        } else if (oper.getGetUrl() != null) {
            this.request.setUrl(this.context, oper.getGetUrl());
            this.request.setMethod(AbstractHttpRequest.Method.GET);
        } else if (oper.getPostUrl() != null) {
            this.request.setUrl(this.context, oper.getPostUrl());
            this.request.setMethod(AbstractHttpRequest.Method.POST);
        } else {
            throw new OperationAbortedEx("No GET or POST DCP available in this service.");
        }
        if (((CswParams)this.params).outputSchema != null && !((CswParams)this.params).outputSchema.isEmpty()) {
            this.request.setOutputSchema(((CswParams)this.params).outputSchema);
        } else if (oper.getPreferredOutputSchema() != null) {
            this.request.setOutputSchema(oper.getPreferredOutputSchema());
        }
        if (oper.getPreferredServerVersion() != null) {
            this.request.setServerVersion(oper.getPreferredServerVersion());
        }
        if (params.isUseAccount()) {
            this.request.setCredentials(params.getUsername(), params.getPassword());
        }
    }

    public HarvestResult align(Collection<RecordInfo> records, Collection<HarvestError> errors) throws Exception {
        if (this.cancelMonitor.get()) {
            return this.result;
        }
        this.log.debug("Start of alignment for : " + ((CswParams)this.params).getName());
        this.localCateg = new CategoryMapper(this.context);
        this.localGroups = new GroupMapper(this.context);
        this.localUuids = new UUIDMapper((IMetadataUtils)this.context.getBean(IMetadataUtils.class), ((CswParams)this.params).getUuid());
        Pair<String, Map<String, Object>> filter = HarvesterUtil.parseXSLFilter(((CswParams)this.params).xslfilter);
        this.processName = (String)filter.one();
        this.processParams = (Map)filter.two();
        this.insertOrUpdate(records, errors);
        this.log.debug("End of alignment for : " + ((CswParams)this.params).getName());
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertOrUpdate(Collection<RecordInfo> records, Collection<HarvestError> errors) {
        for (RecordInfo ri : records) {
            if (this.cancelMonitor.get()) {
                return;
            }
            try {
                block15: {
                    String id;
                    block16: {
                        block14: {
                            id = this.metadataUtils.getMetadataId(ri.uuid);
                            if (id != null) break block14;
                            this.log.debug("Adding record with uuid " + ri.uuid);
                            this.addMetadata(ri, ri.uuid);
                            break block15;
                        }
                        if (this.localUuids.getID(ri.uuid) != null) break block16;
                        ++this.result.datasetUuidExist;
                        switch (((CswParams)this.params).getOverrideUuid()) {
                            case OVERRIDE: {
                                this.updateMetadata(ri, Integer.toString(this.metadataUtils.findOneByUuid(ri.uuid).getId()), true);
                                this.log.debug("Overriding record with uuid " + ri.uuid);
                                if (((CswParams)this.params).isIfRecordExistAppendPrivileges()) {
                                    this.addPrivileges(id, ((CswParams)this.params).getPrivileges(), this.localGroups, this.context);
                                    ++this.result.privilegesAppendedOnExistingRecord;
                                    break;
                                }
                                break block15;
                            }
                            case RANDOM: {
                                this.log.debug("Generating random uuid for remote record with uuid " + ri.uuid);
                                this.addMetadata(ri, UUID.randomUUID().toString());
                                break;
                            }
                            case SKIP: {
                                this.log.debug("Skipping record with uuid " + ri.uuid);
                                ++this.result.uuidSkipped;
                                break;
                            }
                        }
                        break block15;
                    }
                    this.updateMetadata(ri, id, false);
                    if (((CswParams)this.params).isIfRecordExistAppendPrivileges()) {
                        this.addPrivileges(id, ((CswParams)this.params).getPrivileges(), this.localGroups, this.context);
                        ++this.result.privilegesAppendedOnExistingRecord;
                    }
                }
                ++this.result.totalMetadata;
            }
            catch (Exception t) {
                errors.add(new HarvestError(this.context, t));
                this.log.error("Unable to process record from csw (" + ((CswParams)this.params).getName() + ")");
                this.log.error("   Record failed: " + ri.uuid + ". Error is: " + t.getMessage());
                this.log.error((Throwable)t);
            }
            finally {
                ++this.result.originalMetadata;
            }
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public HarvestResult cleanupRemovedRecords(Set<String> records) throws Exception {
        if (this.cancelMonitor.get()) {
            return this.result;
        }
        for (String uuid : this.localUuids.getUUIDs()) {
            if (records.contains(uuid)) continue;
            String id = this.localUuids.getID(uuid);
            this.log.debug("  - Removing old metadata with local id:" + id);
            this.metadataManager.deleteMetadata(this.context, id);
            ++this.result.locallyRemoved;
        }
        this.dataMan.forceIndexChanges();
        return this.result;
    }

    private void addMetadata(RecordInfo ri, String uuidToAssign) throws Exception {
        boolean newMdUuidFromXslt;
        if (this.cancelMonitor.get()) {
            return;
        }
        Element md = this.retrieveMetadata(ri.uuid);
        if (md == null) {
            return;
        }
        String schema = this.dataMan.autodetectSchema(md, null);
        if (schema == null) {
            this.log.debug("  - Metadata skipped due to unknown schema. uuid:" + ri.uuid);
            ++this.result.unknownSchema;
            return;
        }
        if (StringUtils.isNotEmpty((String)((CswParams)this.params).xpathFilter)) {
            boolean match;
            Object xpathResult = Xml.selectSingle((Element)md, (String)((CswParams)this.params).xpathFilter, new ArrayList(this.dataMan.getSchema(schema).getNamespaces()));
            boolean bl = match = xpathResult instanceof Boolean && (Boolean)xpathResult != false;
            if (!match) {
                ++this.result.xpathFilterExcluded;
                return;
            }
        }
        this.log.debug("  - Adding metadata with remote uuid:" + ri.uuid + " schema:" + schema);
        String newMdUuid = null;
        if (!((CswParams)this.params).xslfilter.equals("")) {
            md = this.applyXSLTProcessToMetadata(this.context, md, this.processName, this.processParams, this.log);
            schema = this.dataMan.autodetectSchema(md);
            newMdUuid = this.metadataUtils.extractUUID(schema, md);
        }
        boolean bl = newMdUuidFromXslt = !StringUtils.isBlank(newMdUuid);
        if (!newMdUuidFromXslt) {
            Aligner.applyBatchEdits(ri.uuid, md, schema, ((CswParams)this.params).getBatchEdits(), this.context, this.log);
        } else {
            Aligner.applyBatchEdits(newMdUuid, md, schema, ((CswParams)this.params).getBatchEdits(), this.context, this.log);
        }
        if (((CswParams)this.params).isTranslateContent()) {
            md = this.translateMetadataContent(this.context, md, schema);
        }
        Metadata metadata = new Metadata();
        if (newMdUuidFromXslt) {
            metadata.setUuid(newMdUuid);
        } else {
            metadata.setUuid(uuidToAssign);
            if (!uuidToAssign.equals(ri.uuid)) {
                md = this.metadataUtils.setUUID(schema, uuidToAssign, md);
            }
        }
        Integer ownerId = this.getOwner();
        metadata.getDataInfo().setSchemaId(schema).setRoot(md.getQualifiedName()).setType(MetadataType.METADATA).setChangeDate(new ISODate(ri.changeDate)).setCreateDate(new ISODate(ri.changeDate));
        metadata.getSourceInfo().setSourceId(((CswParams)this.params).getUuid()).setOwner(ownerId).setGroupOwner(Integer.valueOf(this.getGroupOwner()));
        metadata.getHarvestInfo().setHarvested(true).setUuid(((CswParams)this.params).getUuid());
        metadata.getSourceInfo().setGroupOwner(Integer.valueOf(this.getGroupOwner()));
        this.addCategories((AbstractMetadata)metadata, ((CswParams)this.params).getCategories(), this.localCateg, this.context, null, false);
        metadata = this.metadataManager.insertMetadata(this.context, (AbstractMetadata)metadata, md, IndexingMode.none, false, UpdateDatestamp.NO, false, false);
        String id = String.valueOf(metadata.getId());
        this.addPrivileges(id, ((CswParams)this.params).getPrivileges(), this.localGroups, this.context);
        this.metadataIndexer.indexMetadata(id, true, IndexingMode.full);
        ++this.result.addedMetadata;
    }

    public static void applyBatchEdits(String uuid, Element md, String schema, String batchEdits, ServiceContext context, Logger log) throws JDOMException, IOException {
        ObjectMapper mapper;
        BatchEditParameter[] listOfUpdates;
        if (StringUtils.isNotEmpty((String)batchEdits) && (listOfUpdates = (BatchEditParameter[])(mapper = new ObjectMapper()).readValue(batchEdits, BatchEditParameter[].class)).length > 0) {
            SchemaManager schemaManager = (SchemaManager)context.getBean(SchemaManager.class);
            EditLib editLib = new EditLib(schemaManager);
            boolean metadataChanged = false;
            boolean createXpathNodeIfNotExists = ((SettingManager)context.getBean(SettingManager.class)).getValueAsBool("system/csw/transactionUpdateCreateXPath");
            MetadataSchema metadataSchema = schemaManager.getSchema(schema);
            for (BatchEditParameter batchEditParameter : Arrays.asList(listOfUpdates)) {
                AddElemValue propertyValue = new AddElemValue(batchEditParameter.getValue());
                boolean applyEdit = true;
                if (StringUtils.isNotEmpty((String)batchEditParameter.getCondition())) {
                    applyEdit = false;
                    Object node = Xml.selectSingle((Element)md, (String)batchEditParameter.getCondition(), (List)metadataSchema.getNamespaces());
                    if (node instanceof Boolean && Boolean.TRUE.equals(node)) {
                        applyEdit = true;
                    }
                }
                if (!applyEdit) continue;
                metadataChanged = editLib.addElementOrFragmentFromXpath(md, metadataSchema, batchEditParameter.getXpath(), propertyValue, createXpathNodeIfNotExists) || metadataChanged;
            }
            if (metadataChanged && log != null) {
                log.debug("  - Record updated by batch edit configuration:" + uuid);
            }
        }
    }

    private void updateMetadata(RecordInfo ri, String id, boolean force) throws Exception {
        String date = this.localUuids.getChangeDate(ri.uuid);
        if (date == null && !force) {
            this.log.debug("  - Skipped metadata managed by another harvesting node. uuid:" + ri.uuid + ", name:" + ((CswParams)this.params).getName());
        } else if (!force && !ri.isMoreRecentThan(date)) {
            this.log.debug("  - Metadata XML not changed for uuid:" + ri.uuid);
            ++this.result.unchangedMetadata;
        } else {
            this.log.debug("  - Updating local metadata for uuid:" + ri.uuid);
            if (this.updatingLocalMetadata(ri, id, force)) {
                this.metadataIndexer.indexMetadata(id, true, IndexingMode.full);
                ++this.result.updatedMetadata;
            }
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    boolean updatingLocalMetadata(RecordInfo ri, String id, boolean force) throws Exception {
        Element md = this.retrieveMetadata(ri.uuid);
        if (md == null) {
            return false;
        }
        String schema = this.dataMan.autodetectSchema(md, null);
        if (StringUtils.isNotEmpty((String)((CswParams)this.params).xpathFilter)) {
            boolean match;
            Object xpathResult = Xml.selectSingle((Element)md, (String)((CswParams)this.params).xpathFilter, new ArrayList(this.dataMan.getSchema(schema).getNamespaces()));
            boolean bl = match = xpathResult instanceof Boolean && (Boolean)xpathResult != false;
            if (!match) {
                ++this.result.xpathFilterExcluded;
                return false;
            }
        }
        boolean updateSchema = false;
        if (!((CswParams)this.params).xslfilter.equals("")) {
            String newSchema = this.dataMan.autodetectSchema(md = this.applyXSLTProcessToMetadata(this.context, md, this.processName, this.processParams, this.log));
            updateSchema = !newSchema.equals(schema);
            schema = newSchema;
        }
        Aligner.applyBatchEdits(ri.uuid, md, schema, ((CswParams)this.params).getBatchEdits(), this.context, this.log);
        if (((CswParams)this.params).isTranslateContent()) {
            md = this.translateMetadataContent(this.context, md, schema);
        }
        boolean validate = false;
        boolean ufo = false;
        String language = this.context.getLanguage();
        AbstractMetadata metadata = this.metadataManager.updateMetadata(this.context, id, md, validate, ufo, language, ri.changeDate, true, IndexingMode.none);
        if (force || updateSchema) {
            if (force) {
                metadata.getHarvestInfo().setUuid(((CswParams)this.params).getUuid());
                metadata.getSourceInfo().setSourceId(((CswParams)this.params).getUuid());
            }
            if (updateSchema) {
                metadata.getDataInfo().setSchemaId(schema);
            }
            this.metadataManager.save(metadata);
        }
        this.addPrivileges(id, ((CswParams)this.params).getPrivileges(), this.localGroups, this.context);
        metadata.getCategories().clear();
        this.addCategories(metadata, ((CswParams)this.params).getCategories(), this.localCateg, this.context, null, true);
        return true;
    }

    private Element retrieveMetadata(String uuid) {
        this.request.clearIds();
        this.request.addId(uuid);
        try {
            List list;
            this.log.debug("Getting record from : " + this.request.getHost() + " (uuid:" + uuid + ")");
            Element response = this.request.execute();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Record got: " + Xml.getString((Element)response) + "\n");
            }
            if ((list = response.getChildren()).isEmpty()) {
                ++this.result.unretrievable;
                return null;
            }
            response = (Element)list.get(0);
            response = (Element)response.detach();
            try {
                Integer groupIdVal = null;
                if (StringUtils.isNotEmpty((String)((CswParams)this.params).getOwnerIdGroup())) {
                    groupIdVal = this.getGroupOwner();
                }
                ((CswParams)this.params).getValidate().validate(this.dataMan, this.context, response, groupIdVal);
            }
            catch (Exception e) {
                this.log.info("Ignoring invalid metadata with uuid " + uuid);
                ++this.result.doesNotValidate;
                return null;
            }
            if (((CswParams)this.params).rejectDuplicateResource && this.foundDuplicateForResource(uuid, response)) {
                ++this.result.unchangedMetadata;
                return null;
            }
            return response;
        }
        catch (Exception e) {
            this.log.error("Raised exception while getting record : " + e);
            this.log.error((Throwable)e);
            ++this.result.unretrievable;
            return null;
        }
    }

    private boolean foundDuplicateForResource(String uuid, Element response) {
        String schema = this.dataMan.autodetectSchema(response);
        if (schema != null && schema.startsWith("iso19139")) {
            String resourceIdentifierXPath = "gmd:identificationInfo/*/gmd:citation/gmd:CI_Citation/gmd:identifier/*/gmd:code/gco:CharacterString";
            try {
                XPath xp = XPath.newInstance((String)resourceIdentifierXPath);
                xp.addNamespace("gmd", "http://www.isotc211.org/2005/gmd");
                xp.addNamespace("gco", "http://www.isotc211.org/2005/gco");
                List resourceIdentifiers = xp.selectNodes((Object)response);
                if (!resourceIdentifiers.isEmpty()) {
                    this.log.debug("  - Resource identifiers found : " + resourceIdentifiers.size());
                    for (Element identifierNode : resourceIdentifiers) {
                        String identifier = identifierNode.getTextTrim();
                        this.log.debug("    - Searching for duplicates for resource identifier: " + identifier);
                        Set<String> values = this.retrieveMetadataUuidsFromIdentifier(this.searchManager, identifier, uuid);
                        this.log.debug("    - Number of resources with same identifier: " + values.size());
                        if (values.isEmpty()) continue;
                        this.log.warning("      - Duplicates found. Skipping record with UUID " + uuid + " and resource identifier " + identifier);
                        this.log.warning("      - Duplicates found. Metadata uuid resources with same resource identifier: " + String.join((CharSequence)",", values));
                        ++this.result.duplicatedResource;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                this.log.warning("      - Error when searching for resource duplicate " + uuid + ". Error is: " + e.getMessage());
            }
        }
        return false;
    }

    private Set<String> retrieveMetadataUuidsFromIdentifier(EsSearchManager searchMan, String datasetIdCode, String metadataUuid) {
        HashSet<String> metadataUuids = new HashSet<String>();
        String jsonQuery = " {       \"query_string\": {       \"query\": \"+resourceIdentifier.code:\\\"%s\\\" -uuid:\\\"%s\\\"\"       }}";
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode esJsonQuery = objectMapper.readTree(String.format(jsonQuery, datasetIdCode, metadataUuid));
            SearchResponse queryResult = searchMan.query(esJsonQuery, EsSearchManager.FIELDLIST_UUID, 0, 1000);
            for (Hit hit : queryResult.hits().hits()) {
                String uuid = ((Map)objectMapper.convertValue(hit.source(), Map.class)).get("uuid").toString();
                metadataUuids.add(uuid);
            }
        }
        catch (Exception ex) {
            this.log.error("     retrieve metadata uuids from identifier  " + datasetIdCode + ".");
        }
        return metadataUuids;
    }
}

