/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.Profile;

import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.search.util.Profile.QueryVerifyResult;
import org.jzkit.search.util.Profile.RuleNodeDBO;
import org.jzkit.search.util.QueryModel.Internal.AttrPlusTermNode;
import org.jzkit.search.util.QueryModel.Internal.AttrValue;

@Entity
@DiscriminatorValue(value="5")
public class RegexpDBO
extends RuleNodeDBO {
    public static Log log = LogFactory.getLog(RegexpDBO.class);
    private Pattern pattern = null;
    private String pattern_string;
    private String type;
    private String namespace;

    public RegexpDBO() {
    }

    public RegexpDBO(String type, String namespace, String pattern) {
        this.type = type;
        this.namespace = namespace;
        this.setPattern(pattern);
    }

    public boolean isValid(String default_namespace, AttrPlusTermNode aptn, QueryVerifyResult qvr) {
        boolean result = false;
        Object a = aptn.getAttr(this.type);
        if (a != null) {
            if (a instanceof AttrValue) {
                AttrValue av = (AttrValue)a;
                String val = av.getWithDefaultNamespace(default_namespace);
                result = this.pattern.matcher(val).matches();
                if (!result) {
                    qvr.setFailingAttr(this.type);
                    qvr.setIsValid(false);
                }
            } else {
                log.debug((Object)"checking simple string");
                result = this.pattern.matcher(a.toString()).matches();
            }
        } else {
            log.debug((Object)("No mapping for attribute type " + this.type + " from aptn " + aptn));
        }
        return result;
    }

    @Column(name="MATCH_ATTR_TYPE", length=32)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Column(name="REGEXP_NAMESPACE", length=32)
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Column(name="REGEXP_PATTERN", length=256)
    public String getPattern() {
        return this.pattern_string;
    }

    public void setPattern(String pattern) {
        this.pattern_string = pattern;
        try {
            this.pattern = Pattern.compile(pattern);
        }
        catch (IllegalArgumentException iae) {
            log.warn((Object)("Problem compiling exception " + iae));
            throw new RuntimeException(iae);
        }
    }

    @Transient
    public String getDesc() {
        return this.pattern_string;
    }

    @Transient
    public String getNodeType() {
        return "Regular Expression Rule";
    }

    public String toString() {
        return "Regular Expression for " + this.type + " : " + this.pattern_string;
    }
}

