/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.metadata;

import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.MetadataNotFoundEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.services.Utils;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.xpath.XPath;

public class PrepareFileDownload
implements Service {
    private Path appPath;

    public void init(Path appPath, ServiceConfig params) throws Exception {
        this.appPath = appPath;
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        Element response = new Element("response");
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dataManager = (DataManager)gc.getBean(DataManager.class);
        boolean addEdit = false;
        String id = Utils.getIdentifierFromParameters((Element)params, (ServiceContext)context);
        if (id == null) {
            throw new MetadataNotFoundEx("No record has this UUID");
        }
        Lib.resource.checkPrivilege(context, id, ReservedOperation.download);
        boolean withValidationErrors = false;
        boolean keepXlinkAttributes = false;
        Element elMd = dataManager.getMetadata(context, id, addEdit, withValidationErrors, keepXlinkAttributes);
        if (elMd == null) {
            throw new MetadataNotFoundEx("Metadata not found - deleted?");
        }
        response.addContent((Content)new Element("id").setText(id));
        Path briefXslt = this.appPath.resolve("xsl/metadata-brief.xsl");
        Element elBrief = Xml.transform((Element)elMd, (Path)briefXslt);
        XPath xp = XPath.newInstance((String)"link[starts-with(@protocol,'WWW:DOWNLOAD') and @name!='']");
        List downloadLinks = xp.selectNodes((Object)elBrief);
        String siteURL = ((SettingManager)context.getBean(SettingManager.class)).getSiteURL(context);
        response = this.processDownloadLinks(context, id, siteURL, downloadLinks, response);
        xp = XPath.newInstance((String)"link[starts-with(@protocol,'WWW:LINK')]");
        List webLinks = xp.selectNodes((Object)elBrief);
        response = this.processWebLinks(webLinks, response);
        return response;
    }

    private Element processDownloadLinks(ServiceContext context, String id, String siteURL, List<Element> elems, Element response) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Store store = (Store)context.getBean("resourceStore", Store.class);
        IMetadataUtils metadataUtils = (IMetadataUtils)context.getBean(IMetadataUtils.class);
        String uuid = metadataUtils.getMetadataUuid(id);
        for (Element elem : elems) {
            elem = (Element)elem.clone();
            String fname = elem.getAttributeValue("name");
            String href = elem.getAttributeValue("href");
            if (href != null) {
                boolean local = href.startsWith(siteURL);
                boolean found = false;
                long size = 0L;
                String dateModified = "";
                String[] linkPieces = href.split("\\&");
                if (linkPieces.length > 0 && local) {
                    String access = "private";
                    for (int i = 0; i < linkPieces.length; ++i) {
                        String lp = linkPieces[i];
                        if (!lp.startsWith("access=")) continue;
                        access = lp.substring(lp.indexOf(61) + 1);
                    }
                    MetadataResource description = store.getResourceDescription(context, uuid, MetadataResourceVisibility.parse((String)access), id, Boolean.valueOf(true));
                    if (description != null) {
                        size = description.getSize();
                        Date date = description.getLastModification();
                        dateModified = sdf.format(date);
                        found = true;
                    }
                }
                elem.setAttribute("size", "" + size);
                elem.setAttribute("datemodified", dateModified);
                elem.setAttribute("found", "" + found);
                elem.setAttribute("local", "" + local);
                elem.setAttribute("download", "true");
                response.addContent((Content)elem);
                continue;
            }
            context.info("Unknown download link: " + Xml.getString((Element)elem));
        }
        return response;
    }

    private Element processWebLinks(List<Element> elems, Element response) {
        for (Element elem : elems) {
            elem = (Element)elem.clone();
            elem.setAttribute("weblink", "true");
            response.addContent((Content)elem);
        }
        return response;
    }
}

