/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.main;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.JeevesEngine;
import jeeves.server.UserSession;
import jeeves.server.dispatchers.ServiceManager;
import jeeves.server.sources.ServiceRequest;
import jeeves.server.sources.ServiceRequestFactory;
import org.apache.commons.io.FileUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.FileUploadTooBigEx;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;

@Controller
public class GenericController {
    public static final String USER_SESSION_ATTRIBUTE_KEY = "session";
    @Autowired
    NodeInfo node;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/{portal}/{lang:[a-z]{3}}/{service:.+}"})
    @ResponseBody
    public void dispatch(@PathVariable String portal, @PathVariable String lang, @PathVariable String service, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBuffer sb;
        HttpSession httpSession = request.getSession(false);
        String ip = ServiceManager.getRequestIpAddress((HttpServletRequest)request);
        Log.info((String)"jeeves.request", (Object)"==========================================================");
        Log.info((String)"jeeves.request", (Object)("HTML Request (from " + ip + ") : " + request.getRequestURI()));
        if (Log.isDebugEnabled((String)"jeeves.request")) {
            Log.debug((String)"jeeves.request", (Object)("Method       : " + request.getMethod()));
            Log.debug((String)"jeeves.request", (Object)("Content type : " + request.getContentType()));
            Log.debug((String)"jeeves.request", (Object)("Accept       : " + request.getHeader("Accept")));
        }
        if (Log.isDebugEnabled((String)"jeeves.request")) {
            if (httpSession != null) {
                Log.debug((String)"jeeves.request", (Object)("Session id is " + httpSession.getId()));
            } else {
                Log.debug((String)"jeeves.request", (Object)"No session created");
            }
        }
        UserSession session = null;
        if (httpSession != null && (session = (UserSession)httpSession.getAttribute(USER_SESSION_ATTRIBUTE_KEY)) == null) {
            session = new UserSession();
            httpSession.setAttribute(USER_SESSION_ATTRIBUTE_KEY, (Object)session);
            session.setsHttpSession(httpSession);
            if (Log.isDebugEnabled((String)"jeeves.request")) {
                Log.debug((String)"jeeves.request", (Object)("Session created for client : " + ip));
            }
        }
        ServiceRequest srvReq = null;
        ConfigurableApplicationContext jeevesApplicationContext = ApplicationContextHolder.get();
        JeevesEngine jeeves = (JeevesEngine)jeevesApplicationContext.getBean(JeevesEngine.class);
        try {
            Path uploadDir = jeeves.getUploadDir();
            srvReq = ServiceRequestFactory.create((HttpServletRequest)request, (HttpServletResponse)response, (String)portal, (String)lang, (String)service, (Path)uploadDir, (long)jeeves.getMaxUploadSize());
        }
        catch (FileUploadTooBigEx e) {
            sb = new StringBuffer();
            sb.append("File upload too big - exceeds ").append(jeeves.getMaxUploadSize()).append(" Mb\n");
            sb.append("Error : ").append(((Object)((Object)e)).getClass().getName()).append("\n");
            response.sendError(400, sb.toString());
            sb.append("Stack :\n");
            sb.append(Util.getStackTrace((Throwable)e));
            Log.error((String)"jeeves.request", (Object)sb.toString());
        }
        catch (Exception e) {
            sb = new StringBuffer();
            sb.append("Cannot build ServiceRequest\n");
            sb.append("Cause : ").append(e.getMessage()).append("\n");
            sb.append("Error : ").append(e.getClass().getName()).append("\n");
            response.sendError(400, sb.toString());
            sb.append("Stack :\n");
            sb.append(Util.getStackTrace((Throwable)e));
            Log.error((String)"jeeves.request", (Object)sb.toString());
        }
        try {
            jeeves.dispatch(srvReq, session);
        }
        finally {
            if (request instanceof MultipartRequest) {
                Map files = ((MultipartRequest)request).getFileMap();
                for (Map.Entry file : files.entrySet()) {
                    Path uploadedFile = jeeves.getUploadDir().resolve(((MultipartFile)file.getValue()).getOriginalFilename());
                    FileUtils.deleteQuietly((File)uploadedFile.toFile());
                }
            }
        }
    }
}

