/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.users.validation;

import java.util.List;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.users.model.UserDto;
import org.fao.geonet.api.users.validation.PasswordValidationUtils;
import org.fao.geonet.repository.UserRepository;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class UserDtoValidator
implements Validator {
    public boolean supports(Class<?> clazz) {
        return UserDto.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        UserRepository userRepository;
        List existingUsers;
        UserDto user = (UserDto)target;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"username", (String)"field.required", (String)"username is a required parameter for newuser operation");
        if (StringUtils.hasLength((String)user.getUsername()) && user.getUsername().length() > 255) {
            errors.rejectValue("username", "field.length", new Object[]{255}, "username size should be less or equals than 255 characters");
        }
        if (!(existingUsers = (userRepository = (UserRepository)ApplicationContextHolder.get().getBean(UserRepository.class)).findByUsernameIgnoreCase(user.getUsername())).isEmpty()) {
            errors.rejectValue("username", "duplicated", new Object[]{user.getUsername()}, "Users with username " + user.getUsername() + " ignore case already exists");
        }
        if (user.getPassword() != null) {
            PasswordValidationUtils.rejectIfInvalid(errors, user.getPassword());
        }
    }
}

