/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.status;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.StatusValueRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/status"})
@Tag(name="status", description="Workflow status operations")
@Controller(value="status")
public class StatusApi {
    @Autowired
    StatusValueRepository statusValueRepository;
    @Autowired
    MetadataStatusRepository metadataStatusRepository;

    @Operation(summary="Get status", description="")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<StatusValue> getStatusList() throws Exception {
        return this.statusValueRepository.findAll();
    }

    @Operation(summary="Get status by type", description="")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET}, path={"/{type}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<StatusValue> getStatusByType(@Parameter(description="Type", required=true) @PathVariable StatusValueType type) throws Exception {
        return this.statusValueRepository.findAllByType(type);
    }

    @Operation(summary="Delete all record history and status", description="")
    @RequestMapping(method={RequestMethod.DELETE})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Status removed.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAllHistoryAndStatus(HttpServletRequest request) throws Exception {
        this.metadataStatusRepository.deleteAll();
    }
}

