/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.selections;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.kernel.SelectionManager;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/selections"})
@Tag(name="selections", description="Selection related operations")
@Controller(value="selections")
public class SelectionsApi {
    @Operation(summary="Get current selections")
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, Integer> getSelectionsAndSize(@Parameter(hidden=true) HttpSession httpSession) throws Exception {
        SelectionManager selectionManager = SelectionManager.getManager((UserSession)ApiUtils.getUserSession(httpSession));
        return selectionManager.getSelectionsAndSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Get current selection")
    @RequestMapping(method={RequestMethod.GET}, value={"/{bucket}"}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> get(@Parameter(description="Bucket name", required=true, example="metadata") @PathVariable String bucket, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        SelectionManager selectionManager = SelectionManager.getManager((UserSession)ApiUtils.getUserSession(httpSession));
        Set set = selectionManager.getSelection(bucket);
        synchronized (set) {
            return selectionManager.getSelection(bucket);
        }
    }

    @Operation(summary="Select one or more items")
    @RequestMapping(method={RequestMethod.PUT}, value={"/{bucket}"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Integer> add(@Parameter(description="Bucket name", required=true, example="metadata") @PathVariable String bucket, @Parameter(description="One or more record UUIDs. If null, select all in current search if bucket name is 'metadata' (TODO: remove this limitation?).", required=false) @RequestParam(required=false) String[] uuid, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        int nbSelected = SelectionManager.updateSelection((String)bucket, (UserSession)session, (String)(uuid != null ? "add" : "add-all"), uuid != null ? Arrays.asList(uuid) : null, (ServiceContext)ApiUtils.createServiceContext(request));
        return new ResponseEntity((Object)nbSelected, HttpStatus.CREATED);
    }

    @Operation(summary="Clear selection or remove items")
    @RequestMapping(method={RequestMethod.DELETE}, value={"/{bucket}"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Integer> clear(@Parameter(description="Selection bucket name", required=true, example="metadata") @PathVariable String bucket, @Parameter(description="One or more record UUIDs", required=false) @RequestParam(required=false) String[] uuid, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        int nbSelected = SelectionManager.updateSelection((String)bucket, (UserSession)ApiUtils.getUserSession(httpSession), (String)(uuid != null ? "remove" : "remove-all"), uuid != null ? Arrays.asList(uuid) : null, (ServiceContext)ApiUtils.createServiceContext(request));
        return new ResponseEntity((Object)nbSelected, HttpStatus.OK);
    }
}

