/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import com.lowagie.text.DocumentException;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Constants;
import org.fao.geonet.api.records.extent.MapRenderer;
import org.fao.geonet.api.records.formatters.FormatType;
import org.fao.geonet.api.records.formatters.ImageReplacedElementFactory;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.Log;
import org.springframework.stereotype.Component;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.pdf.ITextRenderer;

@Component
class PdfOrHtmlResponseWriter {
    PdfOrHtmlResponseWriter() {
    }

    void writeOutResponse(ServiceContext context, String metadataUuid, String lang, HttpServletResponse response, FormatType formatType, byte[] formattedMetadata) throws Exception {
        response.setContentType(formatType.contentType);
        String filename = "metadata-" + metadataUuid + "." + formatType;
        response.addHeader("Content-Disposition", "inline; filename=\"" + filename + "\"");
        response.setStatus(200);
        if (formatType == FormatType.pdf) {
            this.writerAsPDF(context, response, formattedMetadata, lang);
        } else {
            response.setCharacterEncoding(Constants.ENCODING);
            response.setContentType(formatType.contentType);
            response.setContentLength(formattedMetadata.length);
            response.setHeader("Cache-Control", "no-cache");
            response.getOutputStream().write(formattedMetadata);
        }
    }

    private void writerAsPDF(ServiceContext context, HttpServletResponse response, byte[] bytes, String lang) throws IOException, DocumentException {
        String htmlContent = new String(bytes, Constants.CHARSET);
        try {
            XslUtil.setNoScript();
            ITextRenderer renderer = new ITextRenderer();
            String siteUrl = ((SettingManager)context.getBean(SettingManager.class)).getSiteURL(lang);
            MapRenderer mapRenderer = new MapRenderer(context);
            renderer.getSharedContext().setReplacedElementFactory((ReplacedElementFactory)new ImageReplacedElementFactory(siteUrl.replace("/" + lang + "/", "/eng/"), renderer.getSharedContext().getReplacedElementFactory(), mapRenderer));
            renderer.getSharedContext().setDotsPerPixel(13);
            renderer.setDocumentFromString(htmlContent, siteUrl);
            renderer.layout();
            renderer.createPDF((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.formatter", (String)("Error converting formatter output to a file: " + htmlContent), (Throwable)e);
            throw e;
        }
    }
}

