/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.lowagie.text.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.api.records.extent.MapRenderer;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.utils.Log;
import org.w3c.dom.Element;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.EmptyReplacedElement;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.pdf.ITextImageElement;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.FormSubmissionListener;

public class ImageReplacedElementFactory
implements ReplacedElementFactory {
    private static Set<String> imgFormatExts = null;
    private final ReplacedElementFactory superFactory;
    private final MapRenderer mapRenderer;
    private final String baseURL;
    private static final Pattern ONE_EXTENT_API_REGEX = Pattern.compile(".*/(.*)/extents/(\\d+)\\.png.*");
    private static final Pattern ALL_EXTENT_API_REGEX = Pattern.compile(".*/(.*)/extents\\.png.*");
    private static final String EXTENT_XPATH = ".//*[local-name() ='extent']/*/*[local-name() = 'geographicElement']/*";
    private static final String DEFAULT_SRS = "EPSG:4326";

    public ImageReplacedElementFactory(String baseURL, ReplacedElementFactory superFactory) {
        this.superFactory = superFactory;
        this.baseURL = baseURL;
        this.mapRenderer = null;
    }

    public ImageReplacedElementFactory(String baseURL, ReplacedElementFactory superFactory, MapRenderer mapRenderer) {
        this.superFactory = superFactory;
        this.baseURL = baseURL;
        this.mapRenderer = mapRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Set<String> getSupportedExts() {
        if (imgFormatExts != null) return imgFormatExts;
        Class<ImageReplacedElementFactory> clazz = ImageReplacedElementFactory.class;
        synchronized (ImageReplacedElementFactory.class) {
            if (imgFormatExts != null) return imgFormatExts;
            HashSet tmpImgFormatExts = Sets.newHashSet();
            for (String ext : ImageIO.getReaderFileSuffixes()) {
                tmpImgFormatExts.add(ext.toLowerCase());
            }
            imgFormatExts = tmpImgFormatExts;
            // ** MonitorExit[var0] (shouldn't be in output)
            return imgFormatExts;
        }
    }

    public ReplacedElement createReplacedElement(LayoutContext layoutContext, BlockBox box, UserAgentCallback userAgentCallback, int cssWidth, int cssHeight) {
        String baseUrlNoLang;
        boolean useExtentApi;
        Element element = box.getElement();
        if (element == null) {
            return null;
        }
        String nodeName = element.getNodeName();
        if (!"img".equals(nodeName)) {
            try {
                return this.superFactory.createReplacedElement(layoutContext, box, userAgentCallback, cssWidth, cssHeight);
            }
            catch (Exception e) {
                return new EmptyReplacedElement(cssWidth, cssHeight);
            }
        }
        String src = element.getAttribute("src");
        boolean bl = useExtentApi = src.startsWith(baseUrlNoLang = this.baseURL.substring(0, this.baseURL.length() - 4)) && this.mapRenderer != null && (ALL_EXTENT_API_REGEX.matcher(src).matches() || ONE_EXTENT_API_REGEX.matcher(src).matches());
        if (useExtentApi) {
            BufferedImage image = null;
            try {
                String regionId;
                Matcher allMatcher = ALL_EXTENT_API_REGEX.matcher(src);
                Matcher oneMatcher = ONE_EXTENT_API_REGEX.matcher(src);
                if (allMatcher.matches()) {
                    regionId = String.format("metadata:@id%s", ApiUtils.getInternalId(allMatcher.group(1), true));
                } else {
                    oneMatcher.matches();
                    regionId = String.format("metadata:@id%s:@xpath(%s)[%s]", ApiUtils.getInternalId(oneMatcher.group(1), true), EXTENT_XPATH, oneMatcher.group(2));
                }
                Map<String, String> parameters = this.getParams(src);
                String srs = parameters.get("mapsrs") != null ? parameters.get("mapsrs") : DEFAULT_SRS;
                Integer width = parameters.get("width") != null ? Integer.valueOf(Integer.parseInt(parameters.get("width"))) : null;
                Integer height = parameters.get("height") != null ? Integer.valueOf(Integer.parseInt(parameters.get("height"))) : null;
                String background = parameters.get("background");
                image = this.mapRenderer.render(regionId, srs, width, height, background, null, null, null, null, null);
            }
            catch (Exception e) {
                Log.warning((String)"geonetwork", (Object)"Error writing extent to PDF", (Throwable)e);
            }
            float factor = layoutContext.getDotsPerPixel();
            return this.loadImage(layoutContext, box, userAgentCallback, cssWidth, cssHeight, new BufferedImageLoader(image), factor);
        }
        if (src.startsWith(this.baseURL + "region.getmap.png") || src.endsWith("/geom.png") && this.mapRenderer != null) {
            BufferedImage image = null;
            try {
                String geomSrs;
                Map<String, String> parameters = this.getParams(src);
                String id = parameters.get("id");
                String srs = parameters.get("mapsrs") != null ? parameters.get("mapsrs") : DEFAULT_SRS;
                Integer width = parameters.get("width") != null ? Integer.valueOf(Integer.parseInt(parameters.get("width"))) : null;
                Integer height = parameters.get("height") != null ? Integer.valueOf(Integer.parseInt(parameters.get("height"))) : null;
                String background = parameters.get("background");
                String geomParam = parameters.get("geom");
                String geomType = parameters.get("geomtype") != null ? parameters.get("geomtype") : "WKT";
                String string = geomSrs = parameters.get("geomsrs") != null ? parameters.get("geomsrs") : DEFAULT_SRS;
                if (width == null && height == null) {
                    width = 300;
                }
                image = this.mapRenderer.render(id, srs, width, height, background, geomParam, geomType, geomSrs, null, null);
            }
            catch (Exception e) {
                Log.warning((String)"geonetwork", (Object)"Error writing metadata to PDF", (Throwable)e);
            }
            float factor = layoutContext.getDotsPerPixel();
            return this.loadImage(layoutContext, box, userAgentCallback, cssWidth, cssHeight, new BufferedImageLoader(image), factor);
        }
        if (src.startsWith(this.baseURL + "region.getmap.png") || src.endsWith("/extents.png") || src.endsWith("/geom.png")) {
            StringBuilder builder = new StringBuilder(this.baseURL);
            try {
                if (StringUtils.startsWith((String)src, (String)"http")) {
                    builder = new StringBuilder();
                }
                String[] parts = src.split("\\?|&");
                builder.append(parts[0]);
                builder.append('?');
                for (int i = 1; i < parts.length; ++i) {
                    if (i > 1) {
                        builder.append('&');
                    }
                    String[] param = parts[i].split("=");
                    builder.append(param[0]);
                    builder.append('=');
                    builder.append(URLEncoder.encode(param[1], "UTF-8"));
                }
            }
            catch (Exception e) {
                Log.warning((String)"geonetwork", (Object)"Error writing metadata to PDF", (Throwable)e);
            }
            float factor = layoutContext.getDotsPerPixel();
            return this.loadImage(layoutContext, box, userAgentCallback, cssWidth, cssHeight, new UrlImageLoader(builder.toString()), factor);
        }
        if (src.startsWith(baseUrlNoLang) && src.contains("/attachments/")) {
            Matcher m = Pattern.compile(baseUrlNoLang + "api/records/(.*)/attachments/(.*)$").matcher(src);
            if (m.find()) {
                String uuid = m.group(1);
                String file = m.group(2);
                float factor = layoutContext.getDotsPerPixel();
                return this.loadImage(layoutContext, box, userAgentCallback, cssWidth, cssHeight, new DataDirectoryImageLoader(uuid, file), factor);
            }
            if (this.isSupportedImageFormat(src)) {
                float factor = layoutContext.getDotsPerPixel();
                return this.loadImage(layoutContext, box, userAgentCallback, cssWidth, cssHeight, new UrlImageLoader(src), factor);
            }
        } else if (this.isSupportedImageFormat(src)) {
            float factor = layoutContext.getDotsPerPixel();
            return this.loadImage(layoutContext, box, userAgentCallback, cssWidth, cssHeight, new UrlImageLoader(src), factor);
        }
        try {
            return this.superFactory.createReplacedElement(layoutContext, box, userAgentCallback, cssWidth, cssHeight);
        }
        catch (Exception e) {
            return new EmptyReplacedElement(cssWidth, cssHeight);
        }
    }

    private Map<String, String> getParams(String src) throws MalformedURLException {
        URL url = new URL(src);
        String query = url.getQuery();
        String[] keyValuePairs = query.split("&");
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String keyValuePair : keyValuePairs) {
            String[] pair = keyValuePair.split("=");
            String key = pair[0];
            String value = pair.length > 1 ? pair[1] : null;
            parameters.put(key, value);
        }
        return parameters;
    }

    private boolean isSupportedImageFormat(String imgUrl) {
        String trimmedExt = Files.getFileExtension((String)imgUrl.replaceAll("\\?.*", "")).trim();
        return trimmedExt.isEmpty() || ImageReplacedElementFactory.getSupportedExts().contains(trimmedExt);
    }

    private ReplacedElement loadImage(LayoutContext layoutContext, BlockBox box, UserAgentCallback userAgentCallback, int cssWidth, int cssHeight, ImageLoader imageLoader, float scaleFactor) {
        try {
            Image image = imageLoader.loadImage();
            image.scaleAbsolute(image.getPlainWidth() * scaleFactor, image.getPlainHeight() * scaleFactor);
            ITextFSImage fsImage = new ITextFSImage(image);
            if (cssHeight > -1 && cssWidth > -1) {
                fsImage.scale(cssWidth, cssHeight);
            }
            int maxWidth = (int)(900.0f * scaleFactor);
            if (fsImage.getWidth() > maxWidth) {
                int ratio = fsImage.getWidth() / maxWidth;
                fsImage.scale(maxWidth, fsImage.getHeight() / ratio);
            }
            return new ITextImageElement((FSImage)fsImage);
        }
        catch (Exception e) {
            Log.warning((String)"geonetwork", (Object)String.format("Error loading image %s for PDF", imageLoader instanceof UrlImageLoader ? ((UrlImageLoader)imageLoader).url : ""), (Throwable)e);
            try {
                return this.superFactory.createReplacedElement(layoutContext, box, userAgentCallback, cssWidth, cssHeight);
            }
            catch (Exception e2) {
                return new EmptyReplacedElement(cssWidth, cssHeight);
            }
        }
    }

    public void reset() {
        this.superFactory.reset();
    }

    public void remove(Element e) {
        this.superFactory.remove(e);
    }

    public void setFormSubmissionListener(FormSubmissionListener listener) {
        this.superFactory.setFormSubmissionListener(listener);
    }

    private class BufferedImageLoader
    implements ImageLoader {
        private final BufferedImage bufferedImage;

        public BufferedImageLoader(BufferedImage bufferedImage) {
            this.bufferedImage = bufferedImage;
        }

        @Override
        public Image loadImage() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.bufferedImage, "png", baos);
            return Image.getInstance((byte[])baos.toByteArray());
        }
    }

    private class DataDirectoryImageLoader
    implements ImageLoader {
        private final String uuid;
        private final String file;

        public DataDirectoryImageLoader(String uuid, String file) {
            this.uuid = uuid;
            this.file = file;
        }

        @Override
        public Image loadImage() throws Exception {
            Store store = (Store)ApplicationContextHolder.get().getBean("filesystemStore", Store.class);
            try (Store.ResourceHolder resourceHolder = store.getResourceInternal(this.uuid, MetadataResourceVisibility.PUBLIC, this.file, Boolean.valueOf(true));){
                Image image;
                block12: {
                    InputStream is = resourceHolder.getResource().getInputStream();
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        BufferedImage bufferedImage = ImageIO.read(is);
                        ImageIO.write((RenderedImage)bufferedImage, "png", baos);
                        image = Image.getInstance((byte[])baos.toByteArray());
                        if (is == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return image;
            }
        }
    }

    private class UrlImageLoader
    implements ImageLoader {
        private final String url;

        public UrlImageLoader(String url) {
            this.url = url;
        }

        @Override
        public Image loadImage() throws Exception {
            URI normalizedUrl = new URI(this.url).normalize();
            Log.debug((String)"geonetwork", (Object)String.format("URL -> %s, normalized URL -> %s", this.url, normalizedUrl.toString()));
            try (InputStream input = normalizedUrl.toURL().openStream();){
                byte[] bytes = IOUtils.toByteArray((InputStream)input);
                Image image = Image.getInstance((byte[])bytes);
                return image;
            }
        }
    }

    private static interface ImageLoader {
        public Image loadImage() throws Exception;
    }
}

