/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NoResultsFoundException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.schema.SavedQuery;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Service
@RequestMapping(value={"/{portal}/api/records/{metadataUuid}"})
@Tag(name="records", description="Metadata record operations")
public class MetadataSavedQueryApi {
    private static final String LOG_MODULE = "MetadataApi";
    @Autowired
    private SchemaManager schemaManager;

    @Operation(summary="List saved queries for this metadata")
    @RequestMapping(value={"/query"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Saved query available."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    public List<SavedQuery> getSavedQueries(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, request);
        String schemaIdentifier = metadata.getDataInfo().getSchemaId();
        SchemaPlugin schemaPlugin = this.schemaManager.getSchema(schemaIdentifier).getSchemaPlugin();
        if (schemaPlugin == null) {
            return new ArrayList<SavedQuery>();
        }
        try {
            MetadataSchema schema = this.schemaManager.getSchema(schemaIdentifier);
            return schema.getSchemaPlugin().getSavedQueries();
        }
        catch (IllegalArgumentException e) {
            return new ArrayList<SavedQuery>();
        }
    }

    @Operation(summary="Apply a saved query for this metadata", description="All parameters will be substituted to the XPath query. eg. {{protocol}} in the XPath expression will be replaced by the protocol parameter provided in the request body.")
    @RequestMapping(value={"/query/{savedQuery}"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of matching elements. If element are nodes, then they are returned as string."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    public Map<String, String> applyQuery(@Parameter(description="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @Parameter(description="The saved query to apply", required=true, example="wfs-indexing-config") @PathVariable String savedQuery, HttpServletRequest request, @Parameter(description="The query parameters") @RequestBody(required=false) HashMap<String, String> parameters) throws Exception {
        AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, request);
        return this.query(metadata, savedQuery, parameters);
    }

    public Map<String, String> query(AbstractMetadata metadata, String savedQuery, Map<String, String> parameters) throws ResourceNotFoundException, IOException, NoResultsFoundException {
        String metadataUuid = metadata.getUuid();
        String schemaIdentifier = metadata.getDataInfo().getSchemaId();
        SchemaPlugin schemaPlugin = this.schemaManager.getSchema(schemaIdentifier).getSchemaPlugin();
        if (schemaPlugin == null) {
            throw new ResourceNotFoundException(String.format("Saved query '%s' for schema '%s' not found.", savedQuery, schemaIdentifier));
        }
        SavedQuery query = schemaPlugin.getSavedQuery(savedQuery);
        if (query == null) {
            throw new ResourceNotFoundException(String.format("Saved query '%s' for schema '%s' not found. Available queries are '%s'.", savedQuery, schemaIdentifier, schemaPlugin.getSavedQueries().stream().map(SavedQuery::getId).collect(Collectors.joining(", "))));
        }
        String xpath = query.getXpath();
        if (Log.isDebugEnabled((String)LOG_MODULE)) {
            Log.debug((String)LOG_MODULE, (Object)String.format("Saved query XPath: %s", xpath));
        }
        if (parameters != null) {
            for (String parameter : parameters.keySet()) {
                xpath = xpath.replaceAll("\\{\\{" + parameter + "\\}\\}", parameters.get(parameter));
            }
        }
        if (Log.isDebugEnabled((String)LOG_MODULE)) {
            Log.debug((String)LOG_MODULE, (Object)String.format("Saved query XPath after URL parameters substitution %s", xpath));
        }
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            ArrayList nss = new ArrayList(schemaPlugin.getNamespaces());
            List matchingElement = Xml.selectNodes((Element)metadata.getXmlData(false), (String)xpath, nss);
            int counter = 0;
            String queryCleanValues = query.getCleanValues();
            if (matchingElement != null) {
                for (Object o : matchingElement) {
                    String key = String.valueOf(counter);
                    String value = null;
                    if (o instanceof Element) {
                        List valuesToClean;
                        String label;
                        Element e = (Element)o;
                        if (query.getLabel() != null && (label = Xml.selectString((Element)e, (String)query.getLabel(), nss)) != null) {
                            key = label;
                        }
                        if (queryCleanValues != null && (valuesToClean = Xml.selectNodes((Element)e, (String)queryCleanValues, nss)) != null) {
                            for (Object v : valuesToClean) {
                                if (v instanceof Element) {
                                    ((Element)v).setText("");
                                    continue;
                                }
                                if (v instanceof Attribute) {
                                    ((Attribute)v).setValue("");
                                    continue;
                                }
                                if (!(v instanceof Text)) continue;
                                ((Text)v).setText("");
                            }
                        }
                        value = Xml.getString((Element)e);
                    } else if (o instanceof Attribute) {
                        value = ((Attribute)o).getValue();
                    } else if (o instanceof Text) {
                        value = ((Text)o).getText();
                    } else if (o instanceof String && StringUtils.isNotEmpty((String)((String)o))) {
                        value = (String)o;
                    }
                    response.put(key, value);
                    ++counter;
                }
            }
            if (response.size() > 0) {
                return response;
            }
            throw new NoResultsFoundException(String.format("No results found in metadata '%s' for query '%s'.", metadataUuid, xpath));
        }
        catch (JDOMException e) {
            throw new IllegalArgumentException(String.format("Error in query: %s. Saved query parameters are '%s'.", e.getMessage(), query.getParameters()));
        }
    }
}

