/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import com.google.common.collect.Sets;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.services.ReadWriteController;
import jeeves.xlink.Processor;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.index.BatchOpsMetadataReindexer;
import org.fao.geonet.kernel.setting.SettingManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="recordIndexing")
@ReadWriteController
public class MetadataIndexApi {
    @Autowired
    DataManager dataManager;
    @Autowired
    SettingManager settingManager;
    @Autowired
    IMetadataUtils metadataUtils;

    @Operation(summary="Index a set of records", description="Index a set of records provided either by a bucket or a list of uuids")
    @RequestMapping(value={"/index"}, method={RequestMethod.GET}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Record indexed."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public IndexResponse index(@Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
        HashSet ids = Sets.newHashSet();
        for (String uuid : records) {
            ApiUtils.canEditRecord(uuid, request);
            try {
                this.metadataUtils.findAllByUuid(uuid).forEach(m -> ids.add(m.getId()));
            }
            catch (Exception e) {
                try {
                    ids.add(Integer.valueOf(uuid));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        int index = ids.size();
        if (index > 0) {
            Processor.clearCache();
            new BatchOpsMetadataReindexer(this.dataManager, (Set)ids).process(this.settingManager.getSiteId(), false);
        }
        IndexResponse indexResponse = new IndexResponse();
        indexResponse.setSuccess(true);
        indexResponse.setCount(index);
        return indexResponse;
    }

    private static class IndexResponse {
        private boolean success;
        private int count;

        private IndexResponse() {
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

