/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.links;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import jeeves.transaction.TransactionManager;
import jeeves.transaction.TransactionTask;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Link;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.kernel.url.UrlAnalyzer;
import org.fao.geonet.repository.LinkRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.springframework.context.ApplicationContext;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.naming.SelfNaming;

@ManagedResource
public class MAnalyseProcess
implements SelfNaming {
    private static final String LOGGER = "geonetwork.metadatalinks";
    private final LinkRepository linkRepository;
    private final MetadataRepository metadataRepository;
    private final UrlAnalyzer urlAnalyser;
    private final ApplicationContext appContext;
    private ObjectName probeName;
    private final AtomicInteger metadataToAnalyseCount = new AtomicInteger(-1);
    private final AtomicInteger metadataAnalysed = new AtomicInteger(0);
    private final AtomicInteger metadataNotAnalysedInError = new AtomicInteger(0);
    private final AtomicInteger urlToCheckCount = new AtomicInteger(-1);
    private final AtomicInteger urlChecked = new AtomicInteger(0);
    private final AtomicLong deleteAllDate = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong analyseMdDate = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong testLinkDate = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong finishDate = new AtomicLong(Long.MAX_VALUE);
    private final AtomicBoolean processFinished = new AtomicBoolean(Boolean.FALSE);

    @ManagedAttribute
    public int getMetadataToAnalyseCount() {
        return this.metadataToAnalyseCount.get();
    }

    @ManagedAttribute
    public int getUrlToCheckCount() {
        return this.urlToCheckCount.get();
    }

    @ManagedAttribute
    public int getMetadataAnalysed() {
        return this.metadataAnalysed.get();
    }

    @ManagedAttribute
    public int getUrlChecked() {
        return this.urlChecked.get();
    }

    @ManagedAttribute
    public int getMetadataNotAnalysedInError() {
        return this.metadataNotAnalysedInError.get();
    }

    @ManagedAttribute
    public long getDeleteAllDate() {
        return this.deleteAllDate.get();
    }

    @ManagedAttribute
    public long getAnalyseMdDate() {
        return this.analyseMdDate.get();
    }

    @ManagedAttribute
    public long getTestLinkDate() {
        return this.testLinkDate.get();
    }

    @ManagedAttribute
    public ObjectName getObjectName() {
        return this.probeName;
    }

    @ManagedAttribute
    public long getFinishDate() {
        return this.finishDate.get();
    }

    @ManagedAttribute
    public boolean isProcessFinished() {
        return this.processFinished.get();
    }

    public MAnalyseProcess(String catalogueId, LinkRepository linkRepository, MetadataRepository metadataRepository, UrlAnalyzer urlAnalyser, ApplicationContext appContext) {
        this.urlAnalyser = urlAnalyser;
        this.linkRepository = linkRepository;
        this.metadataRepository = metadataRepository;
        this.appContext = appContext;
        try {
            this.probeName = new ObjectName(String.format("geonetwork-%s:name=url-check,idx=%s", catalogueId, this.hashCode()));
        }
        catch (MalformedObjectNameException e) {
            Log.error((String)LOGGER, (String)"Error creating MAnalyseProcess for processing links", (Throwable)e);
        }
    }

    public void deleteAll() {
        this.runInNewTransaction("manalyseprocess-deleteall", (TransactionTask<Object>)((TransactionTask)transaction -> {
            this.deleteAllDate.set(System.currentTimeMillis());
            this.urlAnalyser.deleteAll();
            return null;
        }));
    }

    public void processMetadataAndTestLink(boolean testLink, Set<Integer> ids) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new LinksCheckCallable(testLink, ids));
        executorService.shutdown();
    }

    public void testLink(List<String> links) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new LinksCheckUrlCallable(links));
        executorService.shutdown();
    }

    private void runInNewTransaction(String name, TransactionTask<Object> transactionTask) {
        TransactionManager.runInTransaction((String)name, (ApplicationContext)this.appContext, (TransactionManager.TransactionRequirement)TransactionManager.TransactionRequirement.CREATE_NEW, (TransactionManager.CommitBehavior)TransactionManager.CommitBehavior.ALWAYS_COMMIT, (boolean)false, transactionTask);
    }

    private final class LinksCheckCallable
    implements Runnable {
        private final boolean testLink;
        private final Set<Integer> ids;

        LinksCheckCallable(boolean testLink, Set<Integer> ids) {
            this.testLink = testLink;
            this.ids = ids;
        }

        @Override
        public void run() {
            try {
                this.processMetadataAndTestLink(this.testLink, this.ids);
                MAnalyseProcess.this.finishDate.set(System.currentTimeMillis());
                MAnalyseProcess.this.processFinished.set(Boolean.TRUE);
            }
            catch (Exception ex) {
                Log.error((String)MAnalyseProcess.LOGGER, (String)String.format("Error processing metadata links in process '%s'", MAnalyseProcess.this.probeName), (Throwable)ex);
            }
        }

        private void processMetadataAndTestLink(boolean testLink, Set<Integer> ids) {
            MAnalyseProcess.this.metadataToAnalyseCount.set(ids.size());
            MAnalyseProcess.this.analyseMdDate.set(System.currentTimeMillis());
            for (int i : ids) {
                try {
                    Optional metadataOpt = MAnalyseProcess.this.metadataRepository.findById((Object)i);
                    if (metadataOpt.isPresent()) {
                        Metadata metadata = (Metadata)metadataOpt.get();
                        Element xmlData = metadata.getXmlData(false);
                        MAnalyseProcess.this.runInNewTransaction("manalyseprocess-process-metadata", (TransactionTask<Object>)((TransactionTask)transaction -> {
                            try {
                                MAnalyseProcess.this.urlAnalyser.processMetadata(xmlData, (AbstractMetadata)metadata);
                                MAnalyseProcess.this.metadataAnalysed.incrementAndGet();
                            }
                            catch (Exception e) {
                                MAnalyseProcess.this.metadataNotAnalysedInError.incrementAndGet();
                                Log.error((String)MAnalyseProcess.LOGGER, (String)String.format("Error processing metadata links for metadata '%s' in process '%s'", metadata.getUuid(), MAnalyseProcess.this.probeName), (Throwable)e);
                            }
                            return null;
                        }));
                        continue;
                    }
                    MAnalyseProcess.this.metadataNotAnalysedInError.incrementAndGet();
                    Log.warning((String)MAnalyseProcess.LOGGER, (Object)String.format("Processing metadata links in process '%s': metadata with id '%d' not found", MAnalyseProcess.this.probeName, i));
                }
                catch (Exception e) {
                    MAnalyseProcess.this.metadataNotAnalysedInError.incrementAndGet();
                    Log.error((String)MAnalyseProcess.LOGGER, (String)String.format("Error processing metadata links in process '%s'", MAnalyseProcess.this.probeName), (Throwable)e);
                }
            }
            if (testLink) {
                this.testLink(null);
            }
        }

        private void testLink(List<String> links) {
            List linkList = links == null ? MAnalyseProcess.this.linkRepository.findAll() : MAnalyseProcess.this.linkRepository.findAllByUrlIn(links);
            MAnalyseProcess.this.urlToCheckCount.set(linkList.size());
            for (int i = 0; i < MAnalyseProcess.this.urlToCheckCount.get(); ++i) {
                Link link = (Link)linkList.get(i);
                MAnalyseProcess.this.runInNewTransaction("manalyseprocess-testlink", (TransactionTask<Object>)((TransactionTask)transaction -> {
                    MAnalyseProcess.this.testLinkDate.set(System.currentTimeMillis());
                    MAnalyseProcess.this.urlAnalyser.testLink(link);
                    MAnalyseProcess.this.urlChecked.getAndIncrement();
                    return null;
                }));
            }
        }
    }

    private final class LinksCheckUrlCallable
    implements Runnable {
        private final List<String> links;

        LinksCheckUrlCallable(List<String> links) {
            this.links = links;
        }

        @Override
        public void run() {
            try {
                this.testLink(this.links);
                MAnalyseProcess.this.finishDate.set(System.currentTimeMillis());
                MAnalyseProcess.this.processFinished.set(Boolean.TRUE);
            }
            catch (Exception ex) {
                Log.error((String)MAnalyseProcess.LOGGER, (String)String.format("Error processing metadata links in process '%s'", MAnalyseProcess.this.probeName), (Throwable)ex);
            }
        }

        private void testLink(List<String> links) {
            List linkList = links == null ? MAnalyseProcess.this.linkRepository.findAll() : MAnalyseProcess.this.linkRepository.findAllByUrlIn(links);
            MAnalyseProcess.this.urlToCheckCount.set(linkList.size());
            for (int i = 0; i < MAnalyseProcess.this.urlToCheckCount.get(); ++i) {
                Link link = (Link)linkList.get(i);
                MAnalyseProcess.this.runInNewTransaction("manalyseprocess-testlink", (TransactionTask<Object>)((TransactionTask)transaction -> {
                    MAnalyseProcess.this.testLinkDate.set(System.currentTimeMillis());
                    MAnalyseProcess.this.urlAnalyser.testLink(link);
                    MAnalyseProcess.this.urlChecked.getAndIncrement();
                    return null;
                }));
            }
        }
    }
}

