/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.groups;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.persistence.metamodel.SingularAttribute;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.records.attachments.AttachmentsApi;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.api.tools.i18n.TranslationPackBuilder;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Group_;
import org.fao.geonet.domain.Language;
import org.fao.geonet.domain.OperationAllowedId_;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroupId_;
import org.fao.geonet.domain.page.Page;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.LanguageRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.page.PageRepository;
import org.fao.geonet.repository.specification.GroupSpecs;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.WebRequest;

@RequestMapping(value={"/{portal}/api/groups"})
@Tag(name="groups", description="Groups operations")
@Controller(value="groups")
public class GroupsApi {
    public static final String LOGGER = "geonetwork.api.groups";
    public static final String API_PARAM_GROUP_DETAILS = "Group details";
    public static final String API_PARAM_GROUP_IDENTIFIER = "Group identifier";
    public static final String MSG_GROUP_WITH_IDENTIFIER_NOT_FOUND = "Group with identifier '%d' not found";
    private static final Pattern GROUPNAME_PATTERN_REGEX = Pattern.compile("^[a-zA-Z0-9]+([_\\-]{1}[a-zA-Z0-9]+)*$");
    public static final int GROUPNAME_MAX_LENGHT = 32;
    private static final String API_GET_LOGO_NOTE = "If last-modified header is present it is used to check if the logo has been modified since the header date. If it hasn't been modified returns an empty 304 Not Modified response. If modified returns the image. If the group has no logo then returns a transparent 1x1 px PNG image.";
    private static final int SIX_HOURS = 21600;
    private static final String TRANSPARENT_1_X_1_PNG_BASE64 = "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mP8/5+hHgAHggJ/PchI7wAAAABJRU5ErkJggg==";
    private static final byte[] TRANSPARENT_1_X_1_PNG = Base64.decodeBase64((String)"iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mP8/5+hHgAHggJ/PchI7wAAAABJRU5ErkJggg==");
    @Autowired
    @Qualifier(value="apiMessages")
    private ResourceBundleMessageSource messages;
    @Autowired
    private LanguageUtils languageUtils;
    @Autowired
    private LanguageRepository langRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private OperationAllowedRepository operationAllowedRepo;
    @Autowired
    private UserGroupRepository userGroupRepository;
    @Autowired
    private DataManager dm;
    @Autowired
    private TranslationPackBuilder translationPackBuilder;
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    private PageRepository pageRepository;

    private static Resources.ResourceHolder getImage(Resources resources, ServiceContext serviceContext, Group group) throws IOException {
        Path logosDir = resources.locateLogosDir(serviceContext);
        Path harvesterLogosDir = resources.locateHarvesterLogosDir(serviceContext);
        String logoUUID = group.getLogo();
        Resources.ResourceHolder image = null;
        if (StringUtils.isNotBlank((String)logoUUID) && !logoUUID.startsWith("http://") && !logoUUID.startsWith("https//") && (image = resources.getImage(serviceContext, logoUUID, logosDir)) == null) {
            image = resources.getImage(serviceContext, logoUUID, harvesterLogosDir);
        }
        return image;
    }

    @Operation(summary="Get the group logo image.", description="If last-modified header is present it is used to check if the logo has been modified since the header date. If it hasn't been modified returns an empty 304 Not Modified response. If modified returns the image. If the group has no logo then returns a transparent 1x1 px PNG image.")
    @RequestMapping(value={"/{groupId}/logo"}, method={RequestMethod.GET})
    public void getGroupLogo(@Parameter(description="Group identifier", required=true) @PathVariable(value="groupId") Integer groupId, @Parameter(hidden=true) WebRequest webRequest, HttpServletRequest request, HttpServletResponse response) throws ResourceNotFoundException {
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        ConfigurableApplicationContext context = ApplicationContextHolder.get();
        ServiceContext serviceContext = ApiUtils.createServiceContext(request, locale.getISO3Country());
        if (context == null) {
            throw new RuntimeException("ServiceContext not available");
        }
        Optional group = this.groupRepository.findById((Object)groupId);
        if (!group.isPresent()) {
            throw new ResourceNotFoundException(this.messages.getMessage("api.groups.group_not_found", new Object[]{groupId}, locale));
        }
        try {
            FileTime lastModifiedTime;
            Resources resources = (Resources)context.getBean(Resources.class);
            String logoUUID = ((Group)group.get()).getLogo();
            if (StringUtils.isNotBlank((String)logoUUID) && !logoUUID.startsWith("http://") && !logoUUID.startsWith("https//")) {
                try (Resources.ResourceHolder image = GroupsApi.getImage(resources, serviceContext, (Group)group.get());){
                    if (image != null) {
                        FileTime lastModifiedTime2 = image.getLastModifiedTime();
                        response.setDateHeader("Expires", System.currentTimeMillis() + 21600000L);
                        if (webRequest.checkNotModified(lastModifiedTime2.toMillis())) {
                            return;
                        }
                        response.setContentType(AttachmentsApi.getFileContentType(image.getPath().getFileName().toString()));
                        response.setContentLength((int)Files.size(image.getPath()));
                        response.addHeader("Cache-Control", "max-age=21600, public");
                        FileUtils.copyFile((File)image.getPath().toFile(), (OutputStream)response.getOutputStream());
                        return;
                    }
                }
            }
            if (webRequest.checkNotModified((lastModifiedTime = FileTime.fromMillis(0L)).toMillis())) {
                return;
            }
            response.setContentType("image/png");
            response.setContentLength(TRANSPARENT_1_X_1_PNG.length);
            response.addHeader("Cache-Control", "max-age=21600, public");
            response.getOutputStream().write(TRANSPARENT_1_X_1_PNG);
        }
        catch (IOException e) {
            Log.error((String)LOGGER, (Object)String.format("There was an error accessing the logo of the group with id '%d'", groupId));
            throw new RuntimeException(e);
        }
    }

    @Operation(summary="Get groups", description="The catalog contains one or more groups. By default, there is 3 reserved groups (Internet, Intranet, Guest) and a sample group.<br/>This service returns all catalog groups when not authenticated or when current is user is an administrator. The list can contains or not reserved groups depending on the parameters.<br/>When authenticated, return user groups optionally filtered on a specific user profile.")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<Group> getGroups(@Parameter(description="Including Internet, Intranet, Guest groups or not") @RequestParam(required=false, defaultValue="false") boolean withReservedGroup, @Parameter(description="For a specific profile") @RequestParam(required=false) String profile, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        if (!session.isAuthenticated() || profile == null) {
            return this.getGroups(session, null, withReservedGroup, !withReservedGroup);
        }
        return this.getGroups(session, Profile.findProfileIgnoreCase((String)profile), false, false);
    }

    @Operation(summary="Add a group", description="Return the identifier of the group created.")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Group created."), @ApiResponse(responseCode="400", description="Group with that id or name already exist."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public ResponseEntity<Integer> addGroup(@Parameter(description="Group details") @RequestBody Group group) throws Exception {
        if (this.groupRepository.findById((Object)group.getId()).isPresent()) {
            throw new IllegalArgumentException(String.format("A group with id '%d' already exist.", group.getId()));
        }
        Group existingName = this.groupRepository.findByName(group.getName());
        if (existingName != null) {
            throw new IllegalArgumentException(String.format("A group with name '%s' already exist.", group.getName()));
        }
        if (group.getName().length() > 32) {
            throw new IllegalArgumentException(String.format("Group name cannot be longer than %d characters.", 32));
        }
        if (!GROUPNAME_PATTERN_REGEX.matcher(group.getName()).matches()) {
            throw new IllegalArgumentException("Group name may only contain alphanumeric characters or single hyphens. Cannot begin or end with a hyphen.");
        }
        List allLanguages = this.langRepository.findAll();
        Map labelTranslations = group.getLabelTranslations();
        for (Language l : allLanguages) {
            String label = (String)labelTranslations.get(l.getId());
            group.getLabelTranslations().put(l.getId(), label == null ? group.getName() : label);
        }
        try {
            group = (Group)this.groupRepository.saveAndFlush((Object)group);
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.api", (Object)ExceptionUtils.getStackTrace((Throwable)ex));
            throw new RuntimeException(ex.getMessage());
        }
        this.translationPackBuilder.clearCache();
        return new ResponseEntity((Object)group.getId(), HttpStatus.CREATED);
    }

    @Operation(summary="Get group", description="Return the requested group details.")
    @RequestMapping(value={"/{groupIdentifier}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Group information for the group id supplied."), @ApiResponse(responseCode="404", description="Resource not found.")})
    @ResponseBody
    public Group getGroup(@Parameter(description="Group identifier") @PathVariable Integer groupIdentifier) throws Exception {
        Optional group = this.groupRepository.findById((Object)groupIdentifier);
        if (!group.isPresent()) {
            throw new ResourceNotFoundException(String.format(MSG_GROUP_WITH_IDENTIFIER_NOT_FOUND, groupIdentifier));
        }
        return (Group)group.get();
    }

    @Operation(summary="Get group users", description="")
    @RequestMapping(value={"/{groupIdentifier}/users"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of users in that group."), @ApiResponse(responseCode="404", description="Resource not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public List<User> getGroupUsers(@Parameter(description="Group identifier") @PathVariable Integer groupIdentifier) throws Exception {
        Optional group = this.groupRepository.findById((Object)groupIdentifier);
        if (!group.isPresent()) {
            throw new ResourceNotFoundException(String.format(MSG_GROUP_WITH_IDENTIFIER_NOT_FOUND, groupIdentifier));
        }
        return this.userRepository.findAllUsersInUserGroups(UserGroupSpecs.hasGroupId((Integer)groupIdentifier));
    }

    @Operation(summary="Update a group", description="")
    @RequestMapping(value={"/{groupIdentifier}"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Group updated.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Resource not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public void updateGroup(@Parameter(description="Group identifier") @PathVariable Integer groupIdentifier, @Parameter(description="Group details") @RequestBody Group group) throws Exception {
        Optional existing = this.groupRepository.findById((Object)groupIdentifier);
        if (!existing.isPresent()) {
            throw new ResourceNotFoundException(String.format(MSG_GROUP_WITH_IDENTIFIER_NOT_FOUND, groupIdentifier));
        }
        if (group.getName().length() > 32) {
            throw new IllegalArgumentException(String.format("Group name cannot be longer than %d characters.", 32));
        }
        if (!GROUPNAME_PATTERN_REGEX.matcher(group.getName()).matches()) {
            throw new IllegalArgumentException("Group name may only contain alphanumeric characters or single hyphens. Cannot begin or end with a hyphen.");
        }
        boolean clearTranslationPackCache = !((Group)existing.get()).getLabelTranslations().equals(group.getLabelTranslations());
        try {
            this.groupRepository.saveAndFlush((Object)group);
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.api", (Object)ExceptionUtils.getStackTrace((Throwable)ex));
            throw new RuntimeException(ex.getMessage());
        }
        if (clearTranslationPackCache) {
            this.translationPackBuilder.clearCache();
        }
    }

    @Operation(summary="Remove a group", description="Remove a group by first removing sharing settings, link to users and finally reindex all affected records.")
    @RequestMapping(value={"/{groupIdentifier}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Group removed.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Resource not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public void deleteGroup(@Parameter(description="Group identifier.") @PathVariable Integer groupIdentifier, @Parameter(description="Force removal even if records are assigned to that group.") @RequestParam(defaultValue="false") boolean force, @Parameter(hidden=true) ServletRequest request) throws Exception {
        Optional group = this.groupRepository.findById((Object)groupIdentifier);
        if (group.isPresent()) {
            long metadataCount = this.metadataRepository.count(Specification.where((Specification)MetadataSpecs.isOwnedByOneOfFollowingGroups(Arrays.asList(((Group)group.get()).getId()))));
            if (metadataCount > 0L) {
                throw new NotAllowedException(String.format("Group %s owns metadata. To remove the group you should transfer first the metadata to another group.", ((Group)group.get()).getName()));
            }
            List reindex = this.operationAllowedRepo.findAllIds(OperationAllowedSpecs.hasGroupId((int)groupIdentifier), OperationAllowedId_.metadataId);
            if (reindex.size() > 0 && force) {
                this.operationAllowedRepo.deleteAllByGroupId(groupIdentifier.intValue());
                this.dm.indexMetadata(Lists.transform((List)reindex, (Function)Functions.toStringFunction()));
            } else if (reindex.size() > 0 && !force) {
                throw new NotAllowedException(String.format("Group %s has privileges associated with %d record(s). Add 'force' parameter to remove it or remove privileges associated with that group first.", ((Group)group.get()).getName(), reindex.size()));
            }
            List users = this.userGroupRepository.findUserIds(Specification.where((Specification)UserGroupSpecs.hasGroupId((Integer)((Group)group.get()).getId())));
            if (users.size() > 0 && force) {
                this.userGroupRepository.deleteAllByIdAttribute(UserGroupId_.groupId, Arrays.asList(groupIdentifier));
            } else if (users.size() > 0 && !force) {
                throw new NotAllowedException(String.format("Group %s is associated with %d user(s). Add 'force' parameter to remove it or remove users associated with that group first.", ((Group)group.get()).getName(), users.size()));
            }
            List staticPages = this.pageRepository.findPageByStatus(Page.PageStatus.GROUPS);
            List staticPagesAssignedToGroup = staticPages.stream().filter(p -> !p.getGroups().stream().filter(g -> g.getId() == groupIdentifier.intValue()).collect(Collectors.toList()).isEmpty()).collect(Collectors.toList());
            if (!staticPagesAssignedToGroup.isEmpty()) {
                throw new NotAllowedException(String.format("Group %s is associated with '%s' static page(s). Please remove the static page(s) associated with that group first.", ((Group)group.get()).getName(), staticPagesAssignedToGroup.stream().map(p -> p.getLabel()).collect(Collectors.joining())));
            }
        } else {
            throw new ResourceNotFoundException(String.format(MSG_GROUP_WITH_IDENTIFIER_NOT_FOUND, groupIdentifier));
        }
        this.groupRepository.deleteById((Object)groupIdentifier);
        this.translationPackBuilder.clearCache();
    }

    private List<Group> getGroups(UserSession session, Profile profile, boolean includingSystemGroups, boolean all) throws SQLException {
        Sort sort = SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{Group_.id});
        if (all || !session.isAuthenticated() || Profile.Administrator == session.getProfile()) {
            if (includingSystemGroups) {
                return this.groupRepository.findAll(sort);
            }
            return this.groupRepository.findAll(Specification.not((Specification)GroupSpecs.isReserved()), sort);
        }
        Specification spec = Specification.where((Specification)UserGroupSpecs.hasUserId((int)session.getUserIdAsInt()));
        if (profile != null) {
            spec = spec.and(UserGroupSpecs.hasProfile((Profile)profile));
        }
        HashSet<Integer> ids = new HashSet<Integer>(this.userGroupRepository.findGroupIds(spec));
        if (includingSystemGroups) {
            for (ReservedGroup reservedGroup : ReservedGroup.values()) {
                ids.add(reservedGroup.getId());
            }
        }
        List groups = this.groupRepository.findAll(sort);
        groups.removeIf(g -> !ids.contains(g.getId()));
        return groups;
    }
}

