/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.PathUtils;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.models.OpenAPI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.AbstractRequestService;
import org.springdoc.core.GenericResponseService;
import org.springdoc.core.OpenAPIService;
import org.springdoc.core.OperationService;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SpringDocProviders;
import org.springdoc.core.customizers.SpringDocCustomizers;
import org.springdoc.core.providers.ActuatorProvider;
import org.springdoc.core.providers.SecurityOAuth2Provider;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

@RestController
public class OpenApiController
extends AbstractOpenApiResource {
    private final RequestMappingInfoHandlerMapping requestMappingHandlerMapping;
    private final Optional<ActuatorProvider> servletContextProvider;
    private final Optional<SecurityOAuth2Provider> springSecurityOAuth2Provider;

    @Autowired
    public OpenApiController(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, RequestMappingInfoHandlerMapping requestMappingHandlerMapping, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders, SpringDocCustomizers springDocCustomizers, Optional<ActuatorProvider> servletContextProvider, Optional<SecurityOAuth2Provider> springSecurityOAuth2Provider) {
        super("springdocDefault", openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, springDocConfigProperties, springDocProviders, springDocCustomizers);
        springDocConfigProperties.setPathsToExclude(List.of("/0.1/**"));
        springDocConfigProperties.setPackagesToScan(Arrays.asList("org.fao.geonet.api", "org.fao.geonet.services.inspireatom", "org.fao.geonet.monitor.service"));
        springDocConfigProperties.setWriterWithOrderByKeys(true);
        springDocConfigProperties.setWriterWithDefaultPrettyPrinter(true);
        springDocConfigProperties.setOverrideWithGenericResponse(false);
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
        this.servletContextProvider = servletContextProvider;
        this.springSecurityOAuth2Provider = springSecurityOAuth2Provider;
        Json.mapper().configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, false);
        Yaml.mapper().configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, false);
    }

    @Operation(hidden=true)
    @GetMapping(value={"/{portal}/api/doc"}, produces={"application/json"})
    public String openapiJson(HttpServletRequest request, Locale locale) throws JsonProcessingException {
        this.calculateServerUrl(request, locale);
        OpenAPI openAPI = this.getOpenApi(locale);
        return new String(this.writeJsonValue(openAPI), StandardCharsets.UTF_8);
    }

    @Operation(hidden=true)
    @GetMapping(value={"/{portal}/api/doc.yml"}, produces={"application/vnd.oai.openapi"})
    public String openapiYaml(HttpServletRequest request, Locale locale) throws JsonProcessingException {
        this.calculateServerUrl(request, locale);
        OpenAPI openAPI = this.getOpenApi(locale);
        return new String(this.writeYamlValue(openAPI), StandardCharsets.UTF_8);
    }

    protected void getPaths(Map<String, Object> restControllers, Locale locale, OpenAPI openAPI) {
        Map map = this.requestMappingHandlerMapping.getHandlerMethods();
        this.calculatePath(restControllers, map, locale, openAPI);
        if (this.servletContextProvider.isPresent()) {
            map = this.servletContextProvider.get().getMethods();
            this.calculatePath(restControllers, map, locale, openAPI);
        }
        if (this.springSecurityOAuth2Provider.isPresent()) {
            SecurityOAuth2Provider securityOAuth2Provider = this.springSecurityOAuth2Provider.get();
            Map mapOauth = securityOAuth2Provider.getHandlerMethods();
            Map requestMappingMapSec = securityOAuth2Provider.getFrameworkEndpoints();
            Class[] additionalRestClasses = (Class[])requestMappingMapSec.values().stream().map(Object::getClass).toArray(Class[]::new);
            AbstractOpenApiResource.addRestControllers((Class[])additionalRestClasses);
            this.calculatePath(requestMappingMapSec, mapOauth, locale, openAPI);
        }
    }

    protected void calculatePath(Map<String, Object> restControllers, Map<RequestMappingInfo, HandlerMethod> map, Locale locale, OpenAPI openAPI) {
        TreeMap<RequestMappingInfo, HandlerMethod> methodTreeMap = new TreeMap<RequestMappingInfo, HandlerMethod>(this.byReversedRequestMappingInfos());
        methodTreeMap.putAll(map);
        Optional springWebProviderOptional = this.springDocProviders.getSpringWebProvider();
        springWebProviderOptional.ifPresent(springWebProvider -> {
            for (Map.Entry entry : map.entrySet()) {
                RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
                HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
                Set patterns = springWebProvider.getActivePatterns((Object)requestMappingInfo);
                if (CollectionUtils.isEmpty((Collection)patterns)) continue;
                LinkedHashMap regexMap = new LinkedHashMap();
                for (String pattern : patterns) {
                    String operationPath = PathUtils.parsePath((String)pattern, regexMap).replace("/{portal}/api", "");
                    String[] produces = (String[])requestMappingInfo.getProducesCondition().getProducibleMediaTypes().stream().map(MimeType::toString).toArray(String[]::new);
                    String[] consumes = (String[])requestMappingInfo.getConsumesCondition().getConsumableMediaTypes().stream().map(MimeType::toString).toArray(String[]::new);
                    String[] headers = (String[])requestMappingInfo.getHeadersCondition().getExpressions().stream().map(Object::toString).toArray(String[]::new);
                    String[] params = (String[])requestMappingInfo.getParamsCondition().getExpressions().stream().map(Object::toString).toArray(String[]::new);
                    if (!this.isRestController(restControllers, handlerMethod, operationPath) && !this.isActuatorRestController(operationPath, handlerMethod) || !this.isFilterCondition(handlerMethod, operationPath, produces, consumes, headers)) continue;
                    Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
                    if (requestMethods.isEmpty()) {
                        requestMethods = this.getDefaultAllowedHttpMethods();
                    }
                    this.calculatePath(handlerMethod, operationPath, requestMethods, consumes, produces, headers, params, locale, openAPI);
                }
            }
        });
    }

    private Comparator<RequestMappingInfo> byReversedRequestMappingInfos() {
        return (o2, o1) -> o1.toString().compareTo(o2.toString());
    }

    protected boolean isRestController(Map<String, Object> restControllers, HandlerMethod handlerMethod, String operationPath) {
        return !(!restControllers.containsKey(handlerMethod.getBean().toString()) && !this.isAdditionalRestController(handlerMethod.getBeanType()) || !operationPath.startsWith("/") || !this.springDocConfigProperties.isModelAndViewAllowed() && ModelAndView.class.isAssignableFrom(handlerMethod.getMethod().getReturnType()));
    }

    protected void calculateServerUrl(HttpServletRequest request, Locale locale) {
        super.initOpenAPIBuilder(locale);
        String calculatedUrl = this.getServerUrl(request);
        this.openAPIService.setServerBaseUrl(calculatedUrl);
    }

    private String getServerUrl(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        StringBuffer requestURL = request.getRequestURL();
        String serverBaseUrl = requestURL.substring(0, requestURL.indexOf(contextPath) + contextPath.length());
        return serverBaseUrl;
    }
}

