/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.data.wfs.internal.ComplexGetFeatureResponse;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.GetParser;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.WFSResponse;
import org.geotools.data.wfs.internal.parsers.AbstractGetFeatureResponseParserFactory;
import org.geotools.data.wfs.internal.parsers.GetFeatureResponseParserFactory;
import org.geotools.data.wfs.internal.parsers.XmlComplexFeatureParser;
import org.geotools.http.HTTPResponse;
import org.geotools.ows.ServiceException;

public class ComplexGetFeatureResponseParserFactory
extends AbstractGetFeatureResponseParserFactory {
    @Override
    public boolean canProcess(WFSRequest request, String contentType) {
        if (!super.canProcess(request, contentType)) {
            return false;
        }
        return !(this.getRequestedType((GetFeatureRequest)request) instanceof SimpleFeatureType);
    }

    @Override
    public List<String> getSupportedOutputFormats() {
        return GetFeatureResponseParserFactory.SUPPORTED_FORMATS;
    }

    @Override
    protected List<String> getSupportedVersions() {
        return GetFeatureResponseParserFactory.SUPPORTED_VERSIONS;
    }

    @Override
    protected WFSResponse createResponseImpl(WFSRequest request, HTTPResponse response, InputStream in) throws IOException {
        FeatureType schema = ((GetFeatureRequest)request).getQueryType() == null ? ((GetFeatureRequest)request).getFullType() : ((GetFeatureRequest)request).getQueryType();
        XmlComplexFeatureParser parser = new XmlComplexFeatureParser(in, schema, request.getTypeName(), null, request.getStrategy());
        try {
            return new ComplexGetFeatureResponse(request, response, parser);
        }
        catch (ServiceException e) {
            throw new IOException("Server responded with error: " + e.getMessage(), e);
        }
    }

    @Override
    protected GetParser<SimpleFeature> parser(GetFeatureRequest request, InputStream in) throws IOException {
        throw new UnsupportedOperationException("We don't support parsing SimpleFeature's.");
    }
}

