/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptedMetricAggContexts;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.ScriptedMetricAggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ScriptedMetricAggregationBuilder
extends AbstractAggregationBuilder<ScriptedMetricAggregationBuilder> {
    public static final String NAME = "scripted_metric";
    private static final ParseField INIT_SCRIPT_FIELD = new ParseField("init_script", new String[0]);
    private static final ParseField MAP_SCRIPT_FIELD = new ParseField("map_script", new String[0]);
    private static final ParseField COMBINE_SCRIPT_FIELD = new ParseField("combine_script", new String[0]);
    private static final ParseField REDUCE_SCRIPT_FIELD = new ParseField("reduce_script", new String[0]);
    private static final ParseField PARAMS_FIELD = new ParseField("params", new String[0]);
    public static final ConstructingObjectParser<ScriptedMetricAggregationBuilder, String> PARSER = new ConstructingObjectParser("scripted_metric", false, (args, name) -> {
        ScriptedMetricAggregationBuilder builder = new ScriptedMetricAggregationBuilder((String)name);
        builder.mapScript((Script)args[0]);
        return builder;
    });
    private Script initScript;
    private Script mapScript;
    private Script combineScript;
    private Script reduceScript;
    private Map<String, Object> params;

    public ScriptedMetricAggregationBuilder(String name) {
        super(name);
    }

    protected ScriptedMetricAggregationBuilder(ScriptedMetricAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.initScript = clone.initScript;
        this.mapScript = clone.mapScript;
        this.combineScript = clone.combineScript;
        this.reduceScript = clone.reduceScript;
        this.params = clone.params;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new ScriptedMetricAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public ScriptedMetricAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.initScript = in.readOptionalWriteable(Script::new);
        this.mapScript = in.readOptionalWriteable(Script::new);
        this.combineScript = in.readOptionalWriteable(Script::new);
        this.reduceScript = in.readOptionalWriteable(Script::new);
        if (in.readBoolean()) {
            this.params = in.readGenericMap();
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.initScript);
        out.writeOptionalWriteable(this.mapScript);
        out.writeOptionalWriteable(this.combineScript);
        out.writeOptionalWriteable(this.reduceScript);
        boolean hasParams = this.params != null;
        out.writeBoolean(hasParams);
        if (hasParams) {
            out.writeGenericMap(this.params);
        }
    }

    @Override
    public boolean supportsSampling() {
        return true;
    }

    public ScriptedMetricAggregationBuilder initScript(Script initScript) {
        if (initScript == null) {
            throw new IllegalArgumentException("[initScript] must not be null: [" + this.name + "]");
        }
        this.initScript = initScript;
        return this;
    }

    public ScriptedMetricAggregationBuilder mapScript(Script mapScript) {
        if (mapScript == null) {
            throw new IllegalArgumentException("[mapScript] must not be null: [" + this.name + "]");
        }
        this.mapScript = mapScript;
        return this;
    }

    public ScriptedMetricAggregationBuilder combineScript(Script combineScript) {
        if (combineScript == null) {
            throw new IllegalArgumentException("[combineScript] must not be null: [" + this.name + "]");
        }
        this.combineScript = combineScript;
        return this;
    }

    public ScriptedMetricAggregationBuilder reduceScript(Script reduceScript) {
        if (reduceScript == null) {
            throw new IllegalArgumentException("[reduceScript] must not be null: [" + this.name + "]");
        }
        this.reduceScript = reduceScript;
        return this;
    }

    public ScriptedMetricAggregationBuilder params(Map<String, Object> params) {
        if (params == null) {
            throw new IllegalArgumentException("[params] must not be null: [" + this.name + "]");
        }
        this.params = params;
        return this;
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.NONE;
    }

    @Override
    protected ScriptedMetricAggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
        Map<String, Object> initScriptParams;
        ScriptedMetricAggContexts.InitScript.Factory compiledInitScript;
        if (this.combineScript == null) {
            throw new IllegalArgumentException("[combineScript] must not be null: [" + this.name + "]");
        }
        if (this.reduceScript == null) {
            throw new IllegalArgumentException("[reduceScript] must not be null: [" + this.name + "]");
        }
        if (this.initScript != null) {
            compiledInitScript = context.compile(this.initScript, ScriptedMetricAggContexts.InitScript.CONTEXT);
            initScriptParams = this.initScript.getParams();
        } else {
            compiledInitScript = null;
            initScriptParams = Collections.emptyMap();
        }
        ScriptedMetricAggContexts.MapScript.Factory compiledMapScript = context.compile(this.mapScript, ScriptedMetricAggContexts.MapScript.CONTEXT);
        Map<String, Object> mapScriptParams = this.mapScript.getParams();
        ScriptedMetricAggContexts.CombineScript.Factory compiledCombineScript = context.compile(this.combineScript, ScriptedMetricAggContexts.CombineScript.CONTEXT);
        Map<String, Object> combineScriptParams = this.combineScript.getParams();
        return new ScriptedMetricAggregatorFactory(this.name, compiledMapScript, mapScriptParams, compiledInitScript, initScriptParams, compiledCombineScript, combineScriptParams, this.reduceScript, this.params, context, parent, subfactoriesBuilder, this.metadata);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        builder.startObject();
        if (this.initScript != null) {
            builder.field(INIT_SCRIPT_FIELD.getPreferredName(), (ToXContent)this.initScript);
        }
        if (this.mapScript != null) {
            builder.field(MAP_SCRIPT_FIELD.getPreferredName(), (ToXContent)this.mapScript);
        }
        if (this.combineScript != null) {
            builder.field(COMBINE_SCRIPT_FIELD.getPreferredName(), (ToXContent)this.combineScript);
        }
        if (this.reduceScript != null) {
            builder.field(REDUCE_SCRIPT_FIELD.getPreferredName(), (ToXContent)this.reduceScript);
        }
        if (this.params != null) {
            builder.field(PARAMS_FIELD.getPreferredName());
            builder.map(this.params);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ZERO;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.initScript, this.mapScript, this.combineScript, this.reduceScript, this.params);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ScriptedMetricAggregationBuilder other = (ScriptedMetricAggregationBuilder)obj;
        return Objects.equals(this.initScript, other.initScript) && Objects.equals(this.mapScript, other.mapScript) && Objects.equals(this.combineScript, other.combineScript) && Objects.equals(this.reduceScript, other.reduceScript) && Objects.equals(this.params, other.params);
    }

    static {
        Script.declareScript(PARSER, ScriptedMetricAggregationBuilder::initScript, INIT_SCRIPT_FIELD);
        Script.declareScript(PARSER, ConstructingObjectParser.constructorArg(), MAP_SCRIPT_FIELD);
        Script.declareScript(PARSER, ScriptedMetricAggregationBuilder::combineScript, COMBINE_SCRIPT_FIELD);
        Script.declareScript(PARSER, ScriptedMetricAggregationBuilder::reduceScript, REDUCE_SCRIPT_FIELD);
        PARSER.declareObject(ScriptedMetricAggregationBuilder::params, (p, name) -> p.map(), PARAMS_FIELD);
    }
}

