/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.field.AbstractScriptFieldFactory;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.Field;

public class BooleanDocValuesField
extends AbstractScriptFieldFactory<Boolean>
implements Field<Boolean>,
DocValuesScriptFieldFactory,
ScriptDocValues.Supplier<Boolean> {
    private final SortedNumericDocValues input;
    private final String name;
    private boolean[] values = new boolean[0];
    private int count;
    private ScriptDocValues.Booleans booleans = null;

    public BooleanDocValuesField(SortedNumericDocValues input, String name) {
        this.input = input;
        this.name = name;
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        if (this.input.advanceExact(docId)) {
            this.resize(this.input.docValueCount());
            for (int i = 0; i < this.count; ++i) {
                this.values[i] = this.input.nextValue() == 1L;
            }
        } else {
            this.resize(0);
        }
    }

    private void resize(int newSize) {
        this.count = newSize;
        assert (this.count >= 0) : "size must be positive (got " + this.count + "): likely integer overflow?";
        if (this.values.length < this.count) {
            this.values = Arrays.copyOf(this.values, ArrayUtil.oversize((int)this.count, (int)1));
        }
    }

    public ScriptDocValues<Boolean> toScriptDocValues() {
        if (this.booleans == null) {
            this.booleans = new ScriptDocValues.Booleans(this);
        }
        return this.booleans;
    }

    @Override
    public Boolean getInternal(int index) {
        return this.values[index];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    public boolean get(boolean defaultValue) {
        return this.get(0, defaultValue);
    }

    public boolean get(int index, boolean defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.count) {
            return defaultValue;
        }
        return this.values[index];
    }

    @Override
    public Iterator<Boolean> iterator() {
        return new Iterator<Boolean>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < BooleanDocValuesField.this.count;
            }

            @Override
            public Boolean next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return BooleanDocValuesField.this.values[this.index++];
            }
        };
    }
}

