/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ScriptLanguagesInfo
implements ToXContentObject,
Writeable {
    public static final ParseField TYPES_ALLOWED = new ParseField("types_allowed", new String[0]);
    public static final ParseField LANGUAGE_CONTEXTS = new ParseField("language_contexts", new String[0]);
    public static final ParseField LANGUAGE = new ParseField("language", new String[0]);
    public static final ParseField CONTEXTS = new ParseField("contexts", new String[0]);
    public final Set<String> typesAllowed;
    public final Map<String, Set<String>> languageContexts;

    public ScriptLanguagesInfo(Set<String> typesAllowed, Map<String, Set<String>> languageContexts) {
        this.typesAllowed = typesAllowed != null ? Set.copyOf(typesAllowed) : Collections.emptySet();
        this.languageContexts = languageContexts != null ? Map.copyOf(languageContexts) : Collections.emptyMap();
    }

    public ScriptLanguagesInfo(StreamInput in) throws IOException {
        this.typesAllowed = in.readCollectionAsImmutableSet(StreamInput::readString);
        this.languageContexts = in.readImmutableMap(sin -> sin.readCollectionAsImmutableSet(StreamInput::readString));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.typesAllowed);
        out.writeMap(this.languageContexts, StreamOutput::writeStringCollection);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptLanguagesInfo that = (ScriptLanguagesInfo)o;
        return Objects.equals(this.typesAllowed, that.typesAllowed) && Objects.equals(this.languageContexts, that.languageContexts);
    }

    public int hashCode() {
        return Objects.hash(this.typesAllowed, this.languageContexts);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().startArray(TYPES_ALLOWED.getPreferredName());
        for (String type : this.typesAllowed.stream().sorted().toList()) {
            builder.value(type);
        }
        builder.endArray().startArray(LANGUAGE_CONTEXTS.getPreferredName());
        List languagesByName = this.languageContexts.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList();
        for (Map.Entry languageContext : languagesByName) {
            builder.startObject().field(LANGUAGE.getPreferredName(), (String)languageContext.getKey()).startArray(CONTEXTS.getPreferredName());
            for (String context : ((Set)languageContext.getValue()).stream().sorted().toList()) {
                builder.value(context);
            }
            builder.endArray().endObject();
        }
        return builder.endArray().endObject();
    }
}

