/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.action;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsUpdater;
import org.elasticsearch.reservedstate.ReservedClusterStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.xcontent.XContentParser;

public class ReservedClusterSettingsAction
implements ReservedClusterStateHandler<Map<String, Object>> {
    private static final Logger logger = LogManager.getLogger(ReservedClusterSettingsAction.class);
    public static final String NAME = "cluster_settings";
    private final ClusterSettings clusterSettings;

    public ReservedClusterSettingsAction(ClusterSettings clusterSettings) {
        this.clusterSettings = clusterSettings;
    }

    @Override
    public String name() {
        return NAME;
    }

    private static ClusterUpdateSettingsRequest prepare(Object input, Set<String> previouslySet) {
        Settings.Builder newSettings = Settings.builder().loadFromMap((Map)input);
        HashSet<String> toDelete = new HashSet<String>(previouslySet);
        toDelete.removeAll(newSettings.keys());
        toDelete.forEach(k -> newSettings.put((String)k, (String)null));
        ClusterUpdateSettingsRequest clusterUpdateSettingsRequest = new ClusterUpdateSettingsRequest();
        clusterUpdateSettingsRequest.persistentSettings(newSettings);
        return clusterUpdateSettingsRequest;
    }

    @Override
    public TransformState transform(Object input, TransformState prevState) {
        ClusterUpdateSettingsRequest request = ReservedClusterSettingsAction.prepare(input, prevState.keys());
        if (!request.persistentSettings().isEmpty()) {
            this.validate(request);
        }
        ClusterState state = new SettingsUpdater(this.clusterSettings).updateSettings(prevState.state(), request.transientSettings(), request.persistentSettings(), logger);
        Set<String> currentKeys = request.persistentSettings().keySet().stream().filter(k -> request.persistentSettings().hasValue((String)k)).collect(Collectors.toSet());
        return new TransformState(state, currentKeys);
    }

    @Override
    public Map<String, Object> fromXContent(XContentParser parser) throws IOException {
        return parser.map();
    }
}

