/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.SingleObjectCache;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.monitor.os.OsStats;
import org.elasticsearch.node.ReportingService;

public class OsService
implements ReportingService<OsInfo> {
    private static final Logger logger = LogManager.getLogger(OsService.class);
    private final OsProbe probe = OsProbe.getInstance();
    private final OsInfo info;
    private final SingleObjectCache<OsStats> osStatsCache;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.os.refresh_interval", TimeValue.timeValueSeconds((long)1L), TimeValue.timeValueSeconds((long)1L), Setting.Property.NodeScope);

    public OsService(Settings settings) throws IOException {
        TimeValue refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.info = this.probe.osInfo(refreshInterval.millis(), EsExecutors.nodeProcessors(settings));
        this.osStatsCache = new OsStatsCache(refreshInterval, this.probe.osStats());
        logger.debug("using refresh_interval [{}]", (Object)refreshInterval);
    }

    @Override
    public OsInfo info() {
        return this.info;
    }

    public OsStats stats() {
        return this.osStatsCache.getOrRefresh();
    }

    private class OsStatsCache
    extends SingleObjectCache<OsStats> {
        OsStatsCache(TimeValue interval, OsStats initValue) {
            super(interval, initValue);
        }

        @Override
        protected OsStats refresh() {
            return OsService.this.probe.osStats();
        }
    }
}

