/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.field.vectors.DenseVector;

public class DenseVectorScriptDocValues
extends ScriptDocValues<BytesRef> {
    public static final String MISSING_VECTOR_FIELD_MESSAGE = "A document doesn't have a value for a vector field!";
    private final int dims;
    protected final DenseVectorSupplier dvSupplier;

    public DenseVectorScriptDocValues(DenseVectorSupplier supplier, int dims) {
        super(supplier);
        this.dvSupplier = supplier;
        this.dims = dims;
    }

    public int dims() {
        return this.dims;
    }

    private DenseVector getCheckedVector() {
        DenseVector vector = this.dvSupplier.getInternal();
        if (vector == null) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }
        return vector;
    }

    public float[] getVectorValue() {
        return this.getCheckedVector().getVector();
    }

    public float getMagnitude() {
        return this.getCheckedVector().getMagnitude();
    }

    @Override
    public BytesRef get(int index) {
        throw new UnsupportedOperationException("accessing a vector field's value through 'get' or 'value' is not supported, use 'vectorValue' or 'magnitude' instead.");
    }

    @Override
    public int size() {
        return this.dvSupplier.getInternal() == null ? 0 : 1;
    }

    public static interface DenseVectorSupplier
    extends ScriptDocValues.Supplier<BytesRef> {
        @Override
        default public BytesRef getInternal(int index) {
            throw new UnsupportedOperationException();
        }

        public DenseVector getInternal();
    }
}

