/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.flattened;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.flattened.FlattenedFieldParser;
import org.elasticsearch.xcontent.XContentBuilder;

class FlattenedFieldSyntheticWriterHelper {
    private final SortedSetDocValues dv;

    FlattenedFieldSyntheticWriterHelper(SortedSetDocValues dv) {
        this.dv = dv;
    }

    void write(XContentBuilder b) throws IOException {
        KeyValue curr = new KeyValue(this.dv.lookupOrd(this.dv.nextOrd()));
        KeyValue prev = KeyValue.EMPTY;
        ArrayList<String> values = new ArrayList<String>();
        values.add(curr.value());
        for (int i = 1; i < this.dv.docValueCount(); ++i) {
            KeyValue next = new KeyValue(this.dv.lookupOrd(this.dv.nextOrd()));
            FlattenedFieldSyntheticWriterHelper.writeObject(b, curr, next, curr.start(prev), curr.end(next), values);
            values.add(next.value());
            prev = curr;
            curr = next;
        }
        if (!values.isEmpty()) {
            FlattenedFieldSyntheticWriterHelper.writeObject(b, curr, KeyValue.EMPTY, curr.start(prev), curr.end(KeyValue.EMPTY), values);
        }
    }

    private static void writeObject(XContentBuilder b, KeyValue currKeyValue, KeyValue nextKeyValue, Prefix startPrefix, Prefix endPrefix, List<String> values) throws IOException {
        FlattenedFieldSyntheticWriterHelper.startObject(b, startPrefix.prefix);
        if (!currKeyValue.suffix.equals(nextKeyValue.suffix)) {
            FlattenedFieldSyntheticWriterHelper.writeNestedObject(b, values, currKeyValue.suffix().suffix);
        }
        FlattenedFieldSyntheticWriterHelper.endObject(b, endPrefix.prefix);
    }

    private static void writeNestedObject(XContentBuilder b, List<String> values, List<String> currSuffix) throws IOException {
        int i;
        for (i = 0; i < currSuffix.size() - 1; ++i) {
            b.startObject(currSuffix.get(i));
        }
        FlattenedFieldSyntheticWriterHelper.writeField(b, values, currSuffix);
        for (i = 0; i < currSuffix.size() - 1; ++i) {
            b.endObject();
        }
        values.clear();
    }

    private static void endObject(XContentBuilder b, List<String> objects) throws IOException {
        for (String ignored : objects) {
            b.endObject();
        }
    }

    private static void startObject(XContentBuilder b, List<String> objects) throws IOException {
        for (String object : objects) {
            b.startObject(object);
        }
    }

    private static void writeField(XContentBuilder b, List<String> values, List<String> currSuffix) throws IOException {
        if (values.size() > 1) {
            b.field(currSuffix.get(currSuffix.size() - 1), values);
        } else {
            b.field(currSuffix.get(currSuffix.size() - 1), values.get(0));
        }
    }

    private static class KeyValue {
        public static final KeyValue EMPTY = new KeyValue(null, new Prefix(), new Suffix());
        private final String value;
        private final Prefix prefix;
        private final Suffix suffix;

        private KeyValue(String value, Prefix prefix, Suffix suffix) {
            this.value = value;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        KeyValue(BytesRef keyValue) {
            this(FlattenedFieldParser.extractKey(keyValue).utf8ToString(), FlattenedFieldParser.extractValue(keyValue).utf8ToString());
        }

        private KeyValue(String key, String value) {
            this(value, new Prefix(key), new Suffix(key));
        }

        public Suffix suffix() {
            return this.suffix;
        }

        public Prefix start(KeyValue other) {
            return this.prefix.diff(this.prefix.shared(other.prefix));
        }

        public Prefix end(KeyValue other) {
            return this.start(other).reverse();
        }

        public String value() {
            assert (this.value != null);
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.value, this.prefix, this.suffix);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyValue other = (KeyValue)obj;
            return Objects.equals(this.value, other.value) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.suffix, other.suffix);
        }
    }

    private record Prefix(List<String> prefix) {
        Prefix() {
            this(Collections.emptyList());
        }

        Prefix(String key) {
            this(key.split("\\."));
        }

        Prefix(String[] keyAsArray) {
            this(List.of(keyAsArray).subList(0, keyAsArray.length - 1));
        }

        private Prefix shared(Prefix other) {
            return Prefix.shared(this.prefix, other.prefix);
        }

        private static Prefix shared(List<String> curr, List<String> next) {
            ArrayList<String> shared = new ArrayList<String>();
            for (int i = 0; i < Math.min(curr.size(), next.size()); ++i) {
                if (!curr.get(i).equals(next.get(i))) continue;
                shared.add(curr.get(i));
            }
            return new Prefix(shared);
        }

        private Prefix diff(Prefix other) {
            return Prefix.diff(this.prefix, other.prefix);
        }

        private static Prefix diff(List<String> a, List<String> b) {
            int i;
            if (a.size() > b.size()) {
                return Prefix.diff(b, a);
            }
            ArrayList<String> diff = new ArrayList<String>();
            if (a.isEmpty()) {
                diff.addAll(b);
                return new Prefix(diff);
            }
            for (i = 0; i < a.size() && a.get(i).equals(b.get(i)); ++i) {
            }
            while (i < b.size()) {
                diff.add(b.get(i));
                ++i;
            }
            return new Prefix(diff);
        }

        private Prefix reverse() {
            Prefix p = new Prefix(this.prefix);
            Collections.reverse(p.prefix);
            return p;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.prefix);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Prefix other = (Prefix)obj;
            return Objects.equals(this.prefix, other.prefix);
        }
    }

    private record Suffix(List<String> suffix) {
        Suffix() {
            this(Collections.emptyList());
        }

        Suffix(String key) {
            this(key.split("\\."));
        }

        Suffix(String[] keyAsArray) {
            this(List.of(keyAsArray).subList(keyAsArray.length - 1, keyAsArray.length));
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.suffix);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Suffix other = (Suffix)obj;
            return Objects.equals(this.suffix, other.suffix);
        }
    }
}

