/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DynamicTemplate;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperErrors;
import org.elasticsearch.index.mapper.MapperMergeContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.PassThroughObjectMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class RootObjectMapper
extends ObjectMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(RootObjectMapper.class);
    private static final int MAX_NESTING_LEVEL_FOR_PASS_THROUGH_OBJECTS = 20;
    static final String TOXCONTENT_SKIP_RUNTIME = "skip_runtime";
    private final Explicit<DateFormatter[]> dynamicDateTimeFormatters;
    private final Explicit<Boolean> dateDetection;
    private final Explicit<Boolean> numericDetection;
    private final Explicit<DynamicTemplate[]> dynamicTemplates;
    private final Map<String, RuntimeField> runtimeFields;

    private static String concatStrings(String[] parts, int last) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i <= last; ++i) {
            builder.append('.');
            builder.append(parts[i]);
        }
        return builder.toString();
    }

    private static boolean isConflictingObject(Mapper mapper, String[] parts) {
        for (int i = 0; i < parts.length - 1; ++i) {
            if (mapper == null) {
                return true;
            }
            if (!(mapper instanceof ObjectMapper)) {
                return true;
            }
            ObjectMapper objectMapper = (ObjectMapper)mapper;
            mapper = objectMapper.getMapper(parts[i + 1]);
        }
        return mapper == null;
    }

    RootObjectMapper(String name, Explicit<Boolean> enabled, Explicit<Boolean> subobjects, ObjectMapper.Dynamic dynamic, Map<String, Mapper> mappers, Map<String, RuntimeField> runtimeFields, Explicit<DateFormatter[]> dynamicDateTimeFormatters, Explicit<DynamicTemplate[]> dynamicTemplates, Explicit<Boolean> dateDetection, Explicit<Boolean> numericDetection) {
        super(name, name, enabled, subobjects, dynamic, mappers);
        this.runtimeFields = runtimeFields;
        this.dynamicTemplates = dynamicTemplates;
        this.dynamicDateTimeFormatters = dynamicDateTimeFormatters;
        this.dateDetection = dateDetection;
        this.numericDetection = numericDetection;
    }

    @Override
    public Builder newBuilder(IndexVersion indexVersionCreated) {
        Builder builder = new Builder(this.name(), this.subobjects);
        builder.enabled = this.enabled;
        builder.dynamic = this.dynamic;
        return builder;
    }

    @Override
    RootObjectMapper withoutMappers() {
        return new RootObjectMapper(this.simpleName(), this.enabled, this.subobjects, this.dynamic, Map.of(), Map.of(), this.dynamicDateTimeFormatters, this.dynamicTemplates, this.dateDetection, this.numericDetection);
    }

    public boolean dateDetection() {
        return this.dateDetection.value();
    }

    public boolean numericDetection() {
        return this.numericDetection.value();
    }

    public DateFormatter[] dynamicDateTimeFormatters() {
        return this.dynamicDateTimeFormatters.value();
    }

    public DynamicTemplate[] dynamicTemplates() {
        return this.dynamicTemplates.value();
    }

    Collection<RuntimeField> runtimeFields() {
        return this.runtimeFields.values();
    }

    RuntimeField getRuntimeField(String name) {
        return this.runtimeFields.get(name);
    }

    @Override
    protected MapperMergeContext createChildContext(MapperMergeContext mapperMergeContext, String name) {
        assert (Objects.equals(mapperMergeContext.getMapperBuilderContext().buildFullName("foo"), "foo"));
        return mapperMergeContext.createChildContext(null, this.dynamic);
    }

    @Override
    public RootObjectMapper merge(Mapper mergeWith, MapperMergeContext parentMergeContext) {
        Explicit<DynamicTemplate[]> dynamicTemplates;
        if (!(mergeWith instanceof RootObjectMapper)) {
            MapperErrors.throwObjectMappingConflictError(mergeWith.name());
        }
        RootObjectMapper mergeWithObject = (RootObjectMapper)mergeWith;
        ObjectMapper.MergeResult mergeResult = ObjectMapper.MergeResult.build(this, mergeWithObject, parentMergeContext);
        Explicit<Boolean> numericDetection = mergeWithObject.numericDetection.explicit() ? mergeWithObject.numericDetection : this.numericDetection;
        Explicit<Boolean> dateDetection = mergeWithObject.dateDetection.explicit() ? mergeWithObject.dateDetection : this.dateDetection;
        Explicit<DateFormatter[]> dynamicDateTimeFormatters = mergeWithObject.dynamicDateTimeFormatters.explicit() ? mergeWithObject.dynamicDateTimeFormatters : this.dynamicDateTimeFormatters;
        if (mergeWithObject.dynamicTemplates.explicit()) {
            if (parentMergeContext.getMapperBuilderContext().getMergeReason() == MapperService.MergeReason.INDEX_TEMPLATE) {
                LinkedHashMap<String, Object> templatesByKey = new LinkedHashMap<String, Object>();
                for (DynamicTemplate dynamicTemplate : this.dynamicTemplates.value()) {
                    templatesByKey.put(dynamicTemplate.name(), dynamicTemplate);
                }
                for (DynamicTemplate dynamicTemplate : mergeWithObject.dynamicTemplates.value()) {
                    templatesByKey.put(dynamicTemplate.name(), dynamicTemplate);
                }
                DynamicTemplate[] mergedTemplates = templatesByKey.values().toArray(new DynamicTemplate[0]);
                dynamicTemplates = new Explicit<DynamicTemplate[]>(mergedTemplates, true);
            } else {
                dynamicTemplates = mergeWithObject.dynamicTemplates;
            }
        } else {
            dynamicTemplates = this.dynamicTemplates;
        }
        HashMap<String, RuntimeField> runtimeFields = new HashMap<String, RuntimeField>(this.runtimeFields);
        for (Map.Entry entry : mergeWithObject.runtimeFields.entrySet()) {
            if (entry.getValue() == null) {
                runtimeFields.remove(entry.getKey());
                continue;
            }
            if (runtimeFields.containsKey(entry.getKey())) {
                runtimeFields.put((String)entry.getKey(), (RuntimeField)entry.getValue());
                continue;
            }
            if (!parentMergeContext.decrementFieldBudgetIfPossible(1)) continue;
            runtimeFields.put(((RuntimeField)entry.getValue()).name(), (RuntimeField)entry.getValue());
        }
        return new RootObjectMapper(this.simpleName(), mergeResult.enabled(), mergeResult.subObjects(), mergeResult.dynamic(), mergeResult.mappers(), Map.copyOf(runtimeFields), dynamicDateTimeFormatters, dynamicTemplates, dateDetection, numericDetection);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (this.dynamicDateTimeFormatters.explicit() || includeDefaults) {
            builder.startArray("dynamic_date_formats");
            for (DateFormatter dateTimeFormatter : this.dynamicDateTimeFormatters.value()) {
                builder.value(dateTimeFormatter.pattern());
            }
            builder.endArray();
        }
        if (this.dynamicTemplates.explicit() || includeDefaults) {
            builder.startArray("dynamic_templates");
            for (DynamicTemplate dynamicTemplate : this.dynamicTemplates.value()) {
                builder.startObject();
                builder.field(dynamicTemplate.name(), (ToXContent)dynamicTemplate);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.dateDetection.explicit() || includeDefaults) {
            builder.field("date_detection", this.dateDetection.value());
        }
        if (this.numericDetection.explicit() || includeDefaults) {
            builder.field("numeric_detection", this.numericDetection.value());
        }
        if (this.runtimeFields.size() > 0 && !params.paramAsBoolean(TOXCONTENT_SKIP_RUNTIME, false)) {
            builder.startObject("runtime");
            List<RuntimeField> sortedRuntimeFields = this.runtimeFields.values().stream().sorted(Comparator.comparing(RuntimeField::name)).toList();
            for (RuntimeField fieldType : sortedRuntimeFields) {
                fieldType.toXContent(builder, params);
            }
            builder.endObject();
        }
    }

    private static void validateDynamicTemplate(MappingParserContext parserContext, DynamicTemplate template) {
        if (RootObjectMapper.containsSnippet(template.getMapping(), "{name}")) {
            return;
        }
        DynamicTemplate.XContentFieldType[] types = template.getXContentFieldTypes();
        Exception lastError = null;
        for (DynamicTemplate.XContentFieldType fieldType : types) {
            String dynamicType = template.isRuntimeMapping() ? fieldType.defaultRuntimeMappingType() : fieldType.defaultMappingType();
            String mappingType = template.mappingType(dynamicType);
            try {
                if (template.isRuntimeMapping()) {
                    RuntimeField.Parser parser = parserContext.runtimeFieldParser(mappingType);
                    if (parser == null) {
                        throw new IllegalArgumentException("No runtime field found for type [" + mappingType + "]");
                    }
                    RootObjectMapper.validate(template, dynamicType, (name, mapping) -> parser.parse((String)name, (Map<String, Object>)mapping, parserContext));
                } else {
                    Mapper.TypeParser typeParser = parserContext.typeParser(mappingType);
                    if (typeParser == null) {
                        throw new IllegalArgumentException("No mapper found for type [" + mappingType + "]");
                    }
                    RootObjectMapper.validate(template, dynamicType, (name, mapping) -> typeParser.parse((String)name, (Map<String, Object>)mapping, parserContext).build(MapperBuilderContext.root(false, false)));
                }
                lastError = null;
                break;
            }
            catch (Exception e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            String format = "dynamic template [%s] has invalid content [%s], attempted to validate it with the following match_mapping_type: %s";
            String message = String.format(Locale.ROOT, format, template.getName(), Strings.toString((ToXContent)template), Arrays.toString((Object[])types));
            boolean failInvalidDynamicTemplates = parserContext.indexVersionCreated().onOrAfter(IndexVersions.V_8_0_0);
            if (failInvalidDynamicTemplates) {
                throw new IllegalArgumentException(message, lastError);
            }
            DEPRECATION_LOGGER.warn(DeprecationCategory.TEMPLATES, "invalid_dynamic_template", "{}, last error: [{}]", message, lastError.getMessage());
        }
    }

    private static void validate(DynamicTemplate template, String dynamicType, BiConsumer<String, Map<String, Object>> mappingConsumer) {
        String templateName = "__dynamic__" + template.name();
        Map<String, Object> fieldTypeConfig = template.mappingForName(templateName, dynamicType);
        mappingConsumer.accept(templateName, fieldTypeConfig);
        fieldTypeConfig.remove("type");
        if (!fieldTypeConfig.isEmpty()) {
            throw new IllegalArgumentException("Unknown mapping attributes [" + fieldTypeConfig + "]");
        }
    }

    private static boolean containsSnippet(Map<?, ?> map, String snippet) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            if (key.contains(snippet)) {
                return true;
            }
            Object value = entry.getValue();
            if (!RootObjectMapper.containsSnippet(value, snippet)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSnippet(List<?> list, String snippet) {
        for (Object value : list) {
            if (!RootObjectMapper.containsSnippet(value, snippet)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSnippet(Object value, String snippet) {
        if (value instanceof Map) {
            return RootObjectMapper.containsSnippet((Map)value, snippet);
        }
        if (value instanceof List) {
            return RootObjectMapper.containsSnippet((List)value, snippet);
        }
        if (value instanceof String) {
            return ((String)value).contains(snippet);
        }
        return false;
    }

    @Override
    protected void startSyntheticField(XContentBuilder b) throws IOException {
        b.startObject();
    }

    public static Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
        Explicit<Boolean> subobjects = ObjectMapper.TypeParser.parseSubobjects(node);
        Builder builder = new Builder(name, subobjects);
        Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
        while (iterator.hasNext()) {
            Object fieldNode;
            Map.Entry<String, Object> entry = iterator.next();
            String fieldName = entry.getKey();
            if (!ObjectMapper.TypeParser.parseObjectOrDocumentTypeProperties(fieldName, fieldNode = entry.getValue(), parserContext, builder) && !RootObjectMapper.processField(builder, fieldName, fieldNode, parserContext)) continue;
            iterator.remove();
        }
        return builder;
    }

    private static boolean processField(Builder builder, String fieldName, Object fieldNode, MappingParserContext parserContext) {
        if (fieldName.equals("date_formats") || fieldName.equals("dynamic_date_formats")) {
            if (fieldNode instanceof List) {
                ArrayList<DateFormatter> formatters = new ArrayList<DateFormatter>();
                for (Object formatter : (List)fieldNode) {
                    if (formatter.toString().startsWith("epoch_")) {
                        throw new MapperParsingException("Epoch [" + formatter + "] is not supported as dynamic date format");
                    }
                    formatters.add(TypeParsers.parseDateTimeFormatter(formatter));
                }
                builder.dynamicDateTimeFormatter(formatters);
            } else if ("none".equals(fieldNode.toString())) {
                builder.dynamicDateTimeFormatter(Collections.emptyList());
            } else {
                builder.dynamicDateTimeFormatter(Collections.singleton(TypeParsers.parseDateTimeFormatter(fieldNode)));
            }
            return true;
        }
        if (fieldName.equals("dynamic_templates")) {
            if (!(fieldNode instanceof List)) {
                throw new MapperParsingException("Dynamic template syntax error. An array of named objects is expected.");
            }
            List tmplNodes = (List)fieldNode;
            ArrayList<DynamicTemplate> templates = new ArrayList<DynamicTemplate>();
            for (Object tmplNode : tmplNodes) {
                Map tmpl = (Map)tmplNode;
                if (tmpl.size() != 1) {
                    throw new MapperParsingException("A dynamic template must be defined with a name");
                }
                Map.Entry entry = tmpl.entrySet().iterator().next();
                String templateName = (String)entry.getKey();
                Map templateParams = (Map)entry.getValue();
                DynamicTemplate template = DynamicTemplate.parse(templateName, templateParams);
                RootObjectMapper.validateDynamicTemplate(parserContext, template);
                templates.add(template);
            }
            builder.dynamicTemplates(templates);
            return true;
        }
        if (fieldName.equals("date_detection")) {
            builder.dateDetection = Explicit.explicitBoolean(XContentMapValues.nodeBooleanValue(fieldNode, "date_detection"));
            return true;
        }
        if (fieldName.equals("numeric_detection")) {
            builder.numericDetection = Explicit.explicitBoolean(XContentMapValues.nodeBooleanValue(fieldNode, "numeric_detection"));
            return true;
        }
        if (fieldName.equals("runtime")) {
            if (fieldNode instanceof Map) {
                Map<String, RuntimeField> fields = RuntimeField.parseRuntimeFields((Map)fieldNode, parserContext, true);
                builder.addRuntimeFields(fields);
                return true;
            }
            throw new ElasticsearchParseException("runtime must be a map type", new Object[0]);
        }
        return false;
    }

    @Override
    public int getTotalFieldsCount() {
        return this.mappers.values().stream().mapToInt(Mapper::getTotalFieldsCount).sum() + this.runtimeFields.size();
    }

    public static class Builder
    extends ObjectMapper.Builder {
        protected Explicit<DynamicTemplate[]> dynamicTemplates = Defaults.DYNAMIC_TEMPLATES;
        protected Explicit<DateFormatter[]> dynamicDateTimeFormatters = Defaults.DYNAMIC_DATE_TIME_FORMATTERS;
        protected final Map<String, RuntimeField> runtimeFields = new HashMap<String, RuntimeField>();
        protected Explicit<Boolean> dateDetection = Defaults.DATE_DETECTION;
        protected Explicit<Boolean> numericDetection = Defaults.NUMERIC_DETECTION;
        private static final Logger logger = LogManager.getLogger(Builder.class);

        public Builder(String name, Explicit<Boolean> subobjects) {
            super(name, subobjects);
        }

        public Builder dynamicDateTimeFormatter(Collection<DateFormatter> dateTimeFormatters) {
            this.dynamicDateTimeFormatters = new Explicit<DateFormatter[]>(dateTimeFormatters.toArray(new DateFormatter[0]), true);
            return this;
        }

        public Builder dynamicTemplates(Collection<DynamicTemplate> templates) {
            this.dynamicTemplates = new Explicit<DynamicTemplate[]>(templates.toArray(new DynamicTemplate[0]), true);
            return this;
        }

        @Override
        public Builder add(Mapper.Builder builder) {
            super.add(builder);
            return this;
        }

        public Builder addRuntimeField(RuntimeField runtimeField) {
            this.runtimeFields.put(runtimeField.name(), runtimeField);
            return this;
        }

        public Builder addRuntimeFields(Map<String, RuntimeField> runtimeFields) {
            this.runtimeFields.putAll(runtimeFields);
            return this;
        }

        @Override
        public RootObjectMapper build(MapperBuilderContext context) {
            Map<String, Mapper> mappers = this.buildMappers(context.createChildContext(null, this.dynamic));
            mappers.putAll(this.getAliasMappers(mappers, context));
            return new RootObjectMapper(this.name(), this.enabled, this.subobjects, this.dynamic, mappers, new HashMap<String, RuntimeField>(this.runtimeFields), this.dynamicDateTimeFormatters, this.dynamicTemplates, this.dateDetection, this.numericDetection);
        }

        Map<String, Mapper> getAliasMappers(Map<String, Mapper> mappers, MapperBuilderContext context) {
            HashMap<String, Mapper> newMappers = new HashMap<String, Mapper>();
            HashMap<String, ObjectMapper.Builder> objectIntermediates = new HashMap<String, ObjectMapper.Builder>(1);
            HashMap<String, ObjectMapper.Builder> objectIntermediatesFullName = new HashMap<String, ObjectMapper.Builder>(1);
            this.getAliasMappers(mappers, mappers, newMappers, objectIntermediates, objectIntermediatesFullName, context, 0);
            for (Map.Entry entry : objectIntermediates.entrySet()) {
                newMappers.put((String)entry.getKey(), ((ObjectMapper.Builder)entry.getValue()).build(context));
            }
            return newMappers;
        }

        void getAliasMappers(Map<String, Mapper> mappers, Map<String, Mapper> topLevelMappers, Map<String, Mapper> aliasMappers, Map<String, ObjectMapper.Builder> objectIntermediates, Map<String, ObjectMapper.Builder> objectIntermediatesFullName, MapperBuilderContext context, int level) {
            if (level >= 20) {
                logger.warn("Exceeded maximum nesting level for searching for pass-through object fields within object fields.");
                return;
            }
            for (Mapper mapper : mappers.values()) {
                if (mapper instanceof PassThroughObjectMapper) {
                    PassThroughObjectMapper passthroughMapper = (PassThroughObjectMapper)mapper;
                    for (Mapper internalMapper : passthroughMapper.mappers.values()) {
                        if (!(internalMapper instanceof FieldMapper)) continue;
                        FieldMapper fieldMapper = (FieldMapper)internalMapper;
                        Mapper conflict = mappers.get(fieldMapper.simpleName());
                        if (conflict != null) {
                            if (conflict.typeName().equals("alias") && ((FieldAliasMapper)conflict).path().equals(fieldMapper.mappedFieldType.name())) continue;
                            logger.warn("Root alias for field " + fieldMapper.name() + " conflicts with existing field or alias, skipping alias creation.");
                            continue;
                        }
                        String[] fieldNameParts = fieldMapper.simpleName().split("\\.");
                        if (fieldNameParts.length == 0) {
                            throw new IllegalArgumentException("field name cannot contain only dots");
                        }
                        if (fieldNameParts.length == 1) {
                            FieldAliasMapper aliasMapper = new FieldAliasMapper.Builder(fieldMapper.simpleName()).path(fieldMapper.mappedFieldType.name()).build(context);
                            aliasMappers.put(aliasMapper.simpleName(), aliasMapper);
                            continue;
                        }
                        conflict = topLevelMappers.get(fieldNameParts[0]);
                        if (conflict != null && RootObjectMapper.isConflictingObject(conflict, fieldNameParts)) {
                            throw new IllegalArgumentException("Conflicting objects created during alias generation for pass-through field: [" + conflict.name() + "]");
                        }
                        String realFieldName = fieldNameParts[fieldNameParts.length - 1];
                        Mapper.Builder fieldBuilder = new FieldAliasMapper.Builder(realFieldName).path(fieldMapper.mappedFieldType.name());
                        ObjectMapper.Builder intermediate = null;
                        for (int i = fieldNameParts.length - 2; i >= 0; --i) {
                            String intermediateObjectName = fieldNameParts[i];
                            intermediate = objectIntermediatesFullName.computeIfAbsent(RootObjectMapper.concatStrings(fieldNameParts, i), s -> new ObjectMapper.Builder(intermediateObjectName, ObjectMapper.Defaults.SUBOBJECTS));
                            intermediate.add(fieldBuilder);
                            fieldBuilder = intermediate;
                        }
                        objectIntermediates.putIfAbsent(fieldNameParts[0], intermediate);
                    }
                    continue;
                }
                if (!(mapper instanceof ObjectMapper)) continue;
                ObjectMapper objectMapper = (ObjectMapper)mapper;
                this.getAliasMappers(objectMapper.mappers, topLevelMappers, aliasMappers, objectIntermediates, objectIntermediatesFullName, context, level + 1);
            }
        }
    }

    public static class Defaults {
        public static final Explicit<DateFormatter[]> DYNAMIC_DATE_TIME_FORMATTERS = new Explicit<DateFormatter[]>(new DateFormatter[]{DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER, DateFormatter.forPattern("yyyy/MM/dd HH:mm:ss||yyyy/MM/dd||epoch_millis")}, false);
        public static final Explicit<Boolean> DATE_DETECTION = Explicit.IMPLICIT_TRUE;
        public static final Explicit<Boolean> NUMERIC_DETECTION = Explicit.IMPLICIT_FALSE;
        private static final Explicit<DynamicTemplate[]> DYNAMIC_TEMPLATES = new Explicit<DynamicTemplate[]>(new DynamicTemplate[0], false);
    }
}

