/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ObjectMapper;

public final class MapperMergeContext {
    private final MapperBuilderContext mapperBuilderContext;
    private final NewFieldsBudget newFieldsBudget;

    private MapperMergeContext(MapperBuilderContext mapperBuilderContext, NewFieldsBudget newFieldsBudget) {
        this.mapperBuilderContext = mapperBuilderContext;
        this.newFieldsBudget = newFieldsBudget;
    }

    static MapperMergeContext root(boolean isSourceSynthetic, boolean isDataStream, long newFieldsBudget) {
        return MapperMergeContext.root(isSourceSynthetic, isDataStream, MapperService.MergeReason.MAPPING_UPDATE, newFieldsBudget);
    }

    public static MapperMergeContext root(boolean isSourceSynthetic, boolean isDataStream, MapperService.MergeReason mergeReason, long newFieldsBudget) {
        return new MapperMergeContext(MapperBuilderContext.root(isSourceSynthetic, isDataStream, mergeReason), NewFieldsBudget.of(newFieldsBudget));
    }

    public static MapperMergeContext from(MapperBuilderContext mapperBuilderContext, long newFieldsBudget) {
        return new MapperMergeContext(mapperBuilderContext, NewFieldsBudget.of(newFieldsBudget));
    }

    MapperMergeContext createChildContext(String name, ObjectMapper.Dynamic dynamic) {
        return this.createChildContext(this.mapperBuilderContext.createChildContext(name, dynamic));
    }

    MapperMergeContext createChildContext(MapperBuilderContext childContext) {
        return new MapperMergeContext(childContext, this.newFieldsBudget);
    }

    MapperBuilderContext getMapperBuilderContext() {
        return this.mapperBuilderContext;
    }

    boolean decrementFieldBudgetIfPossible(int fieldSize) {
        return this.newFieldsBudget.decrementIfPossible(fieldSize);
    }

    private static interface NewFieldsBudget {
        public static NewFieldsBudget of(long fieldsBudget) {
            if (fieldsBudget == Long.MAX_VALUE) {
                return Unlimited.INSTANCE;
            }
            return new Limited(fieldsBudget);
        }

        public boolean decrementIfPossible(long var1);

        public static final class Unlimited
        implements NewFieldsBudget {
            private static final Unlimited INSTANCE = new Unlimited();

            private Unlimited() {
            }

            @Override
            public boolean decrementIfPossible(long fieldSize) {
                return true;
            }
        }

        public static final class Limited
        implements NewFieldsBudget {
            private long fieldsBudget;

            Limited(long fieldsBudget) {
                this.fieldsBudget = fieldsBudget;
            }

            @Override
            public boolean decrementIfPossible(long fieldSize) {
                if (this.fieldsBudget >= fieldSize) {
                    this.fieldsBudget -= fieldSize;
                    return true;
                }
                return false;
            }
        }
    }
}

