/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SourceValueFetcherIndexFieldData;
import org.elasticsearch.index.fielddata.SourceValueFetcherSortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceProvider;

public class SourceValueFetcherMultiGeoPointIndexFieldData
extends SourceValueFetcherIndexFieldData<MultiGeoPointValues> {
    protected SourceValueFetcherMultiGeoPointIndexFieldData(String fieldName, ValuesSourceType valuesSourceType, ValueFetcher valueFetcher, SourceProvider sourceProvider, ToScriptFieldFactory<MultiGeoPointValues> toScriptFieldFactory) {
        super(fieldName, valuesSourceType, valueFetcher, sourceProvider, toScriptFieldFactory);
    }

    @Override
    public SourceValueFetcherMultiGeoPointLeafFieldData loadDirect(LeafReaderContext context) throws Exception {
        return new SourceValueFetcherMultiGeoPointLeafFieldData(this.toScriptFieldFactory, context, this.valueFetcher, this.sourceProvider);
    }

    public static class SourceValueFetcherMultiGeoPointLeafFieldData
    extends SourceValueFetcherIndexFieldData.SourceValueFetcherLeafFieldData<MultiGeoPointValues> {
        public SourceValueFetcherMultiGeoPointLeafFieldData(ToScriptFieldFactory<MultiGeoPointValues> toScriptFieldFactory, LeafReaderContext leafReaderContext, ValueFetcher valueFetcher, SourceProvider sourceProvider) {
            super(toScriptFieldFactory, leafReaderContext, valueFetcher, sourceProvider);
        }

        @Override
        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            return this.toScriptFieldFactory.getScriptFieldFactory(new MultiGeoPointValues(new SourceValueFetcherMultiGeoPointDocValues(this.leafReaderContext, this.valueFetcher, this.sourceProvider)), name);
        }
    }

    public static class SourceValueFetcherMultiGeoPointDocValues
    extends SourceValueFetcherSortedNumericIndexFieldData.SourceValueFetcherSortedNumericDocValues {
        public SourceValueFetcherMultiGeoPointDocValues(LeafReaderContext leafReaderContext, ValueFetcher valueFetcher, SourceProvider sourceProvider) {
            super(leafReaderContext, valueFetcher, sourceProvider);
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            this.values.clear();
            Source source = this.sourceProvider.getSource(this.leafReaderContext, doc);
            for (Object value : this.valueFetcher.fetchValues(source, doc, Collections.emptyList())) {
                assert (value instanceof Map && ((Map)value).get("coordinates") instanceof List);
                List coordinates = (List)((Map)value).get("coordinates");
                assert (coordinates.size() == 2 && coordinates.get(1) instanceof Number && coordinates.get(0) instanceof Number);
                this.values.add(new GeoPoint(((Number)coordinates.get(1)).doubleValue(), ((Number)coordinates.get(0)).doubleValue()).getEncoded());
            }
            this.values.sort(Long::compare);
            this.iterator = this.values.iterator();
            return !this.values.isEmpty();
        }
    }

    public static class Builder
    extends SourceValueFetcherIndexFieldData.Builder<MultiGeoPointValues> {
        public Builder(String fieldName, ValuesSourceType valuesSourceType, ValueFetcher valueFetcher, SourceProvider sourceProvider, ToScriptFieldFactory<MultiGeoPointValues> toScriptFieldFactory) {
            super(fieldName, valuesSourceType, valueFetcher, sourceProvider, toScriptFieldFactory);
        }

        public SourceValueFetcherMultiGeoPointIndexFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new SourceValueFetcherMultiGeoPointIndexFieldData(this.fieldName, this.valuesSourceType, this.valueFetcher, this.sourceProvider, this.toScriptFieldFactory);
        }
    }
}

