/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.elasticsearch.Build;
import org.elasticsearch.env.BuildVersion;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public final class NodeMetadata {
    static final String NODE_ID_KEY = "node_id";
    static final String NODE_VERSION_KEY = "node_version";
    static final String OLDEST_INDEX_VERSION_KEY = "oldest_index_version";
    private final String nodeId;
    private final BuildVersion nodeVersion;
    private final BuildVersion previousNodeVersion;
    private final IndexVersion oldestIndexVersion;
    public static final MetadataStateFormat<NodeMetadata> FORMAT = new NodeMetadataStateFormat(false);

    private NodeMetadata(String nodeId, BuildVersion buildVersion, BuildVersion previousBuildVersion, IndexVersion oldestIndexVersion) {
        this.nodeId = Objects.requireNonNull(nodeId);
        this.nodeVersion = Objects.requireNonNull(buildVersion);
        this.previousNodeVersion = Objects.requireNonNull(previousBuildVersion);
        this.oldestIndexVersion = Objects.requireNonNull(oldestIndexVersion);
    }

    public NodeMetadata(String nodeId, BuildVersion buildVersion, IndexVersion oldestIndexVersion) {
        this(nodeId, buildVersion, buildVersion, oldestIndexVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeMetadata that = (NodeMetadata)o;
        return this.nodeId.equals(that.nodeId) && this.nodeVersion.equals(that.nodeVersion) && this.oldestIndexVersion.equals(that.oldestIndexVersion) && Objects.equals(this.previousNodeVersion, that.previousNodeVersion);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.nodeVersion, this.previousNodeVersion, this.oldestIndexVersion);
    }

    public String toString() {
        return "NodeMetadata{nodeId='" + this.nodeId + "', nodeVersion=" + this.nodeVersion + ", previousNodeVersion=" + this.previousNodeVersion + ", oldestIndexVersion=" + this.oldestIndexVersion + "}";
    }

    public String nodeId() {
        return this.nodeId;
    }

    public BuildVersion nodeVersion() {
        return this.nodeVersion;
    }

    public BuildVersion previousNodeVersion() {
        return this.previousNodeVersion;
    }

    public IndexVersion oldestIndexVersion() {
        return this.oldestIndexVersion;
    }

    public void verifyUpgradeToCurrentVersion() {
        if (!this.nodeVersion.onOrAfterMinimumCompatible()) {
            throw new IllegalStateException("cannot upgrade a node from version [" + this.nodeVersion + "] directly to version [" + Build.current().version() + "], upgrade to version [" + Build.current().minWireCompatVersion() + "] first.");
        }
        if (this.nodeVersion.isFutureVersion()) {
            throw new IllegalStateException("cannot downgrade a node from version [" + this.nodeVersion + "] to version [" + Build.current().version() + "]");
        }
    }

    public NodeMetadata upgradeToCurrentVersion() {
        this.verifyUpgradeToCurrentVersion();
        return this.nodeVersion.equals(BuildVersion.current()) ? this : new NodeMetadata(this.nodeId, BuildVersion.current(), this.nodeVersion, this.oldestIndexVersion);
    }

    static class NodeMetadataStateFormat
    extends MetadataStateFormat<NodeMetadata> {
        private ObjectParser<Builder, Void> objectParser;

        NodeMetadataStateFormat(boolean ignoreUnknownFields) {
            super("node-");
            this.objectParser = new ObjectParser("node_meta_data", ignoreUnknownFields, Builder::new);
            this.objectParser.declareString(Builder::setNodeId, new ParseField(NodeMetadata.NODE_ID_KEY, new String[0]));
            this.objectParser.declareInt(Builder::setNodeVersionId, new ParseField(NodeMetadata.NODE_VERSION_KEY, new String[0]));
            this.objectParser.declareInt(Builder::setOldestIndexVersion, new ParseField(NodeMetadata.OLDEST_INDEX_VERSION_KEY, new String[0]));
        }

        @Override
        protected XContentBuilder newXContentBuilder(XContentType type, OutputStream stream) throws IOException {
            XContentBuilder xContentBuilder = super.newXContentBuilder(type, stream);
            xContentBuilder.prettyPrint();
            return xContentBuilder;
        }

        @Override
        public void toXContent(XContentBuilder builder, NodeMetadata nodeMetadata) throws IOException {
            builder.field(NodeMetadata.NODE_ID_KEY, nodeMetadata.nodeId);
            builder.field(NodeMetadata.NODE_VERSION_KEY, nodeMetadata.nodeVersion.id());
            builder.field(NodeMetadata.OLDEST_INDEX_VERSION_KEY, nodeMetadata.oldestIndexVersion.id());
        }

        @Override
        public NodeMetadata fromXContent(XContentParser parser) throws IOException {
            return ((Builder)this.objectParser.apply(parser, null)).build();
        }
    }

    private static class Builder {
        String nodeId;
        BuildVersion nodeVersion;
        BuildVersion previousNodeVersion;
        IndexVersion oldestIndexVersion;

        private Builder() {
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public void setNodeVersionId(int nodeVersionId) {
            this.nodeVersion = BuildVersion.fromVersionId(nodeVersionId);
        }

        public void setOldestIndexVersion(int oldestIndexVersion) {
            this.oldestIndexVersion = IndexVersion.fromId(oldestIndexVersion);
        }

        public NodeMetadata build() {
            if (this.nodeVersion == null) {
                this.nodeVersion = BuildVersion.fromVersionId(0);
            }
            if (this.previousNodeVersion == null) {
                this.previousNodeVersion = this.nodeVersion;
            }
            IndexVersion oldestIndexVersion = this.oldestIndexVersion == null ? IndexVersions.ZERO : this.oldestIndexVersion;
            return new NodeMetadata(this.nodeId, this.nodeVersion, this.previousNodeVersion, oldestIndexVersion);
        }
    }
}

