/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class WriteableZoneId
implements Writeable,
ToXContentFragment {
    private final ZoneId zoneId;

    public WriteableZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.zoneId.getId());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.zoneId.getId());
    }

    public String toString() {
        return this.zoneId.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteableZoneId that = (WriteableZoneId)o;
        return Objects.equals(this.zoneId, that.zoneId);
    }

    public int hashCode() {
        return Objects.hash(this.zoneId);
    }
}

