/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.core.Nullable;

public final class VersionCheckingStreamOutput
extends StreamOutput {
    public VersionCheckingStreamOutput(TransportVersion version) {
        this.setTransportVersion(version);
    }

    @Override
    public void writeByte(byte b) throws IOException {
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void writeNamedWriteable(NamedWriteable namedWriteable) throws IOException {
        if (namedWriteable instanceof VersionedNamedWriteable) {
            VersionedNamedWriteable vnw = (VersionedNamedWriteable)namedWriteable;
            this.checkVersionCompatibility(vnw);
        }
        super.writeNamedWriteable(namedWriteable);
    }

    @Override
    public void writeOptionalNamedWriteable(@Nullable NamedWriteable namedWriteable) throws IOException {
        if (namedWriteable != null && namedWriteable instanceof VersionedNamedWriteable) {
            VersionedNamedWriteable vnw = (VersionedNamedWriteable)namedWriteable;
            this.checkVersionCompatibility(vnw);
        }
        super.writeOptionalNamedWriteable(namedWriteable);
    }

    private void checkVersionCompatibility(VersionedNamedWriteable namedWriteable) {
        if (namedWriteable.getMinimalSupportedVersion().after(this.getTransportVersion())) {
            throw new IllegalArgumentException("[" + namedWriteable.getWriteableName() + "] was released first in version " + namedWriteable.getMinimalSupportedVersion().toReleaseVersion() + ", failed compatibility check trying to send it to node with version " + this.getTransportVersion().toReleaseVersion());
        }
    }
}

