/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.internal;

import org.elasticsearch.common.inject.Scope;
import org.elasticsearch.common.inject.Scopes;

public abstract class Scoping {
    public static final Scoping UNSCOPED = new Scoping(){

        @Override
        public Scope getScopeInstance() {
            return Scopes.NO_SCOPE;
        }

        public String toString() {
            return Scopes.NO_SCOPE.toString();
        }
    };
    public static final Scoping EAGER_SINGLETON = new Scoping(){

        @Override
        public Scope getScopeInstance() {
            return Scopes.SINGLETON;
        }

        public String toString() {
            return "eager singleton";
        }
    };

    public boolean isExplicitlyScoped() {
        return this != UNSCOPED;
    }

    public boolean isNoScope() {
        return this.getScopeInstance() == Scopes.NO_SCOPE;
    }

    public boolean isEagerSingleton() {
        return this == EAGER_SINGLETON;
    }

    public Scope getScopeInstance() {
        return null;
    }

    private Scoping() {
    }
}

