/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.BindingProcessor;
import org.elasticsearch.common.inject.InheritingState;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.InjectorImpl;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.MembersInjectorStore;
import org.elasticsearch.common.inject.MessageProcessor;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.State;
import org.elasticsearch.common.inject.TypeConverterBindingProcessor;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.InternalContext;
import org.elasticsearch.common.inject.internal.InternalFactory;
import org.elasticsearch.common.inject.internal.ProviderInstanceBindingImpl;
import org.elasticsearch.common.inject.internal.Scoping;
import org.elasticsearch.common.inject.internal.SourceProvider;
import org.elasticsearch.common.inject.internal.Stopwatch;
import org.elasticsearch.common.inject.spi.Dependency;
import org.elasticsearch.common.inject.spi.Element;
import org.elasticsearch.common.inject.spi.Elements;
import org.elasticsearch.common.inject.spi.InjectionPoint;

class InjectorShell {
    private final List<Element> elements;
    private final InjectorImpl injector;

    private InjectorShell(List<Element> elements, InjectorImpl injector) {
        this.elements = elements;
        this.injector = injector;
    }

    InjectorImpl getInjector() {
        return this.injector;
    }

    List<Element> getElements() {
        return this.elements;
    }

    private static void bindInjector(InjectorImpl injector) {
        Key<Injector> key = Key.get(Injector.class);
        InjectorFactory injectorFactory = new InjectorFactory(injector);
        injector.state.putBinding(key, new ProviderInstanceBindingImpl<Injector>(injector, key, SourceProvider.UNKNOWN_SOURCE, injectorFactory, Scoping.UNSCOPED, injectorFactory, Collections.emptySet()));
    }

    private static void bindLogger(InjectorImpl injector) {
        Key<Logger> key = Key.get(Logger.class);
        LoggerFactory loggerFactory = new LoggerFactory();
        injector.state.putBinding(key, new ProviderInstanceBindingImpl<Logger>(injector, key, SourceProvider.UNKNOWN_SOURCE, loggerFactory, Scoping.UNSCOPED, loggerFactory, Collections.emptySet()));
    }

    private static class InjectorFactory
    implements InternalFactory<Injector>,
    Provider<Injector> {
        private final Injector injector;

        private InjectorFactory(Injector injector) {
            this.injector = injector;
        }

        @Override
        public Injector get(Errors errors, InternalContext context, Dependency<?> dependency) {
            return this.injector;
        }

        @Override
        public Injector get() {
            return this.injector;
        }

        public String toString() {
            return "Provider<Injector>";
        }
    }

    private static class LoggerFactory
    implements InternalFactory<Logger>,
    Provider<Logger> {
        private LoggerFactory() {
        }

        @Override
        public Logger get(Errors errors, InternalContext context, Dependency<?> dependency) {
            InjectionPoint injectionPoint = dependency.getInjectionPoint();
            return injectionPoint == null ? Logger.getAnonymousLogger() : Logger.getLogger(injectionPoint.getMember().getDeclaringClass().getName());
        }

        @Override
        public Logger get() {
            return Logger.getAnonymousLogger();
        }

        public String toString() {
            return "Provider<Logger>";
        }
    }

    private static class RootModule
    implements Module {
        private RootModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder.withSource(SourceProvider.UNKNOWN_SOURCE);
        }
    }

    static class Builder {
        private final List<Element> elements = new ArrayList<Element>();
        private final List<Module> modules = new ArrayList<Module>();
        private State state;

        Builder() {
        }

        void addModules(Iterable<? extends Module> modules) {
            for (Module module : modules) {
                this.modules.add(module);
            }
        }

        Object lock() {
            return this.getState().lock();
        }

        List<InjectorShell> build(BindingProcessor bindingProcessor, Stopwatch stopwatch, Errors errors) {
            if (this.state == null) {
                throw new IllegalStateException("no state. Did you remember to lock() ?");
            }
            InjectorImpl injector = new InjectorImpl(this.state);
            this.modules.add(0, new RootModule());
            new TypeConverterBindingProcessor(errors).prepareBuiltInConverters(injector);
            this.elements.addAll(Elements.getElements(this.modules));
            stopwatch.resetAndLog("Module execution");
            new MessageProcessor(errors).process(injector, this.elements);
            injector.membersInjectorStore = new MembersInjectorStore(injector);
            stopwatch.resetAndLog("TypeListeners creation");
            stopwatch.resetAndLog("Scopes creation");
            new TypeConverterBindingProcessor(errors).process(injector, this.elements);
            stopwatch.resetAndLog("Converters creation");
            InjectorShell.bindInjector(injector);
            InjectorShell.bindLogger(injector);
            bindingProcessor.process(injector, this.elements);
            stopwatch.resetAndLog("Binding creation");
            ArrayList<InjectorShell> injectorShells = new ArrayList<InjectorShell>();
            injectorShells.add(new InjectorShell(this.elements, injector));
            stopwatch.resetAndLog("Private environment creation");
            return injectorShells;
        }

        private State getState() {
            if (this.state == null) {
                this.state = new InheritingState();
            }
            return this.state;
        }
    }
}

