/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexSettings;

public class DataStreamFailureStoreDefinition {
    public static final String FAILURE_STORE_REFRESH_INTERVAL_SETTING_NAME = "data_streams.failure_store.refresh_interval";
    public static final CompressedXContent DATA_STREAM_FAILURE_STORE_MAPPING;

    public static TimeValue getFailureStoreRefreshInterval(Settings settings) {
        return settings.getAsTime(FAILURE_STORE_REFRESH_INTERVAL_SETTING_NAME, null);
    }

    public static Settings buildFailureStoreIndexSettings(Settings existingSettings, Settings nodeSettings) {
        TimeValue refreshInterval = DataStreamFailureStoreDefinition.getFailureStoreRefreshInterval(nodeSettings);
        if (refreshInterval != null) {
            return Settings.builder().put(existingSettings).put(IndexSettings.INDEX_REFRESH_INTERVAL_SETTING.getKey(), refreshInterval).build();
        }
        return existingSettings;
    }

    public static Settings.Builder applyFailureStoreSettings(Settings nodeSettings, Settings.Builder builder) {
        TimeValue refreshInterval = DataStreamFailureStoreDefinition.getFailureStoreRefreshInterval(nodeSettings);
        if (refreshInterval != null) {
            builder.put(IndexSettings.INDEX_REFRESH_INTERVAL_SETTING.getKey(), refreshInterval);
        }
        return builder;
    }

    static {
        try {
            DATA_STREAM_FAILURE_STORE_MAPPING = new CompressedXContent((builder, params) -> builder.startObject("_doc").field("dynamic", false).startObject("_routing").field("required", false).endObject().startObject("properties").startObject("@timestamp").field("type", "date").field("ignore_malformed", false).endObject().startObject("document").startObject("properties").startObject("id").field("type", "keyword").endObject().startObject("routing").field("type", "keyword").endObject().startObject("index").field("type", "keyword").endObject().endObject().endObject().startObject("error").startObject("properties").startObject("message").field("type", "wildcard").endObject().startObject("stack_trace").field("type", "text").endObject().startObject("type").field("type", "keyword").endObject().startObject("pipeline").field("type", "keyword").endObject().startObject("pipeline_trace").field("type", "keyword").endObject().startObject("processor").field("type", "keyword").endObject().endObject().endObject().endObject().endObject());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

