/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.StartJoinRequest;
import org.elasticsearch.cluster.node.DiscoveryNode;

public abstract class ElectionStrategy {
    public static final ElectionStrategy DEFAULT_INSTANCE = new ElectionStrategy(){

        @Override
        protected boolean satisfiesAdditionalQuorumConstraints(DiscoveryNode localNode, long localCurrentTerm, long localAcceptedTerm, long localAcceptedVersion, CoordinationMetadata.VotingConfiguration lastCommittedConfiguration, CoordinationMetadata.VotingConfiguration lastAcceptedConfiguration, CoordinationState.VoteCollection joinVotes) {
            return true;
        }
    };
    public static final NodeEligibility NODE_MAY_WIN_ELECTION = new NodeEligibility(true, "");
    public static final NodeEligibility NODE_MAY_NOT_WIN_ELECTION = new NodeEligibility(false, "node is ineligible for election, not a voting node in the voting configuration");

    public boolean isElectionQuorum(DiscoveryNode localNode, long localCurrentTerm, long localAcceptedTerm, long localAcceptedVersion, CoordinationMetadata.VotingConfiguration lastCommittedConfiguration, CoordinationMetadata.VotingConfiguration lastAcceptedConfiguration, CoordinationState.VoteCollection joinVotes) {
        return joinVotes.isQuorum(lastCommittedConfiguration) && joinVotes.isQuorum(lastAcceptedConfiguration) && this.satisfiesAdditionalQuorumConstraints(localNode, localCurrentTerm, localAcceptedTerm, localAcceptedVersion, lastCommittedConfiguration, lastAcceptedConfiguration, joinVotes);
    }

    public boolean isPublishQuorum(CoordinationState.VoteCollection voteCollection, CoordinationMetadata.VotingConfiguration lastCommittedConfiguration, CoordinationMetadata.VotingConfiguration latestPublishedConfiguration) {
        return voteCollection.isQuorum(lastCommittedConfiguration) && voteCollection.isQuorum(latestPublishedConfiguration);
    }

    protected abstract boolean satisfiesAdditionalQuorumConstraints(DiscoveryNode var1, long var2, long var4, long var6, CoordinationMetadata.VotingConfiguration var8, CoordinationMetadata.VotingConfiguration var9, CoordinationState.VoteCollection var10);

    public void onNewElection(DiscoveryNode candidateMasterNode, long proposedTerm, ActionListener<StartJoinRequest> listener) {
        listener.onResponse(new StartJoinRequest(candidateMasterNode, proposedTerm));
    }

    public boolean isInvalidReconfiguration(ClusterState clusterState, CoordinationMetadata.VotingConfiguration lastAcceptedConfiguration, CoordinationMetadata.VotingConfiguration lastCommittedConfiguration) {
        return !clusterState.getLastAcceptedConfiguration().equals(lastAcceptedConfiguration) && !lastCommittedConfiguration.equals(lastAcceptedConfiguration);
    }

    public void beforeCommit(long term, long version, ActionListener<Void> listener) {
        listener.onResponse(null);
    }

    public NodeEligibility nodeMayWinElection(ClusterState lastAcceptedState, DiscoveryNode node) {
        String nodeId = node.getId();
        if (lastAcceptedState.getLastCommittedConfiguration().getNodeIds().contains(nodeId) || lastAcceptedState.getLastAcceptedConfiguration().getNodeIds().contains(nodeId) || lastAcceptedState.getVotingConfigExclusions().stream().noneMatch(vce -> vce.getNodeId().equals(nodeId))) {
            return NODE_MAY_WIN_ELECTION;
        }
        return NODE_MAY_NOT_WIN_ELECTION;
    }

    public record NodeEligibility(boolean mayWin, String reason) {
    }
}

