/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.Iterator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;

public abstract class CancellableFanOut<Item, ItemResponse, FinalResponse> {
    private static final Logger logger = LogManager.getLogger(CancellableFanOut.class);

    public final void run(@Nullable Task task, Iterator<Item> itemsIterator, final ActionListener<FinalResponse> listener) {
        CancellableTask ct;
        final CancellableTask cancellableTask = task instanceof CancellableTask ? (ct = (CancellableTask)task) : null;
        SubscribableListener resultListener = new SubscribableListener();
        AtomicReference<Runnable> resultListenerCompleter = new AtomicReference<Runnable>(() -> {
            if (cancellableTask != null && cancellableTask.notifyIfCancelled(resultListener)) {
                return;
            }
            ActionListener.completeWith(resultListener, this::onCompletion);
        });
        SubscribableListener itemCancellationListener = new SubscribableListener();
        if (cancellableTask != null) {
            cancellableTask.addListener(() -> {
                assert (cancellableTask.isCancelled());
                Semaphore semaphore = new Semaphore(0);
                resultListenerCompleter.getAndSet(semaphore::acquireUninterruptibly).run();
                semaphore.release();
                cancellableTask.notifyIfCancelled(itemCancellationListener);
            });
        }
        try (RefCountingRunnable refs = new RefCountingRunnable(new SubtasksCompletionHandler(resultListenerCompleter, resultListener, listener));){
            while (itemsIterator.hasNext()) {
                final Item item = itemsIterator.next();
                ActionListener itemResponseListener = ActionListener.notifyOnce(new ActionListener<ItemResponse>(){

                    @Override
                    public void onResponse(ItemResponse itemResponse) {
                        block2: {
                            try {
                                CancellableFanOut.this.onItemResponse(item, itemResponse);
                            }
                            catch (Exception e) {
                                logger.error(() -> Strings.format("unexpected exception handling [%s] for item [%s] in [%s]", itemResponse, item, CancellableFanOut.this), (Throwable)e);
                                if ($assertionsDisabled) break block2;
                                throw new AssertionError((Object)e);
                            }
                        }
                    }

                    @Override
                    public void onFailure(Exception e) {
                        if (cancellableTask != null && cancellableTask.isCancelled()) {
                            return;
                        }
                        CancellableFanOut.this.onItemFailure(item, e);
                    }

                    public String toString() {
                        return "[" + CancellableFanOut.this + "][" + listener + "][" + item + "]";
                    }
                });
                if (cancellableTask != null) {
                    if (cancellableTask.isCancelled()) {
                        return;
                    }
                    itemCancellationListener.addListener(itemResponseListener);
                }
                ActionListener.run(ActionListener.releaseAfter(itemResponseListener, refs.acquire()), l -> this.sendItemRequest(item, (ActionListener<ItemResponse>)l));
            }
        }
        catch (Exception e) {
            logger.error("unexpected failure in [" + this + "][" + listener + "]", (Throwable)e);
            assert (false) : e;
            throw e;
        }
    }

    protected abstract void sendItemRequest(Item var1, ActionListener<ItemResponse> var2);

    protected abstract void onItemResponse(Item var1, ItemResponse var2);

    protected abstract void onItemFailure(Item var1, Exception var2);

    protected abstract FinalResponse onCompletion() throws Exception;

    private static class SubtasksCompletionHandler<FinalResponse>
    implements Runnable {
        private final AtomicReference<Runnable> resultListenerCompleter;
        private final SubscribableListener<FinalResponse> resultListener;
        private final ActionListener<FinalResponse> listener;

        private SubtasksCompletionHandler(AtomicReference<Runnable> resultListenerCompleter, SubscribableListener<FinalResponse> resultListener, ActionListener<FinalResponse> listener) {
            this.resultListenerCompleter = resultListenerCompleter;
            this.resultListener = resultListener;
            this.listener = listener;
        }

        @Override
        public void run() {
            this.resultListenerCompleter.getAndSet(() -> {}).run();
            assert (this.resultListener.isDone());
            this.resultListener.addListener(this.listener);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.listener.toString() + "]";
        }
    }
}

