/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.SimpleRefCounted;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.transport.LeakTracker;
import org.elasticsearch.xcontent.ToXContent;

public class MultiSearchResponse
extends ActionResponse
implements Iterable<Item>,
ChunkedToXContentObject {
    private final Item[] items;
    private final long tookInMillis;
    private final RefCounted refCounted = LeakTracker.wrap((RefCounted)new SimpleRefCounted());

    public MultiSearchResponse(StreamInput in) throws IOException {
        super(in);
        this.items = in.readArray(Item::new, Item[]::new);
        this.tookInMillis = in.readVLong();
    }

    public MultiSearchResponse(Item[] items, long tookInMillis) {
        this.items = items;
        this.tookInMillis = tookInMillis;
    }

    @Override
    public void incRef() {
        this.refCounted.incRef();
    }

    @Override
    public boolean tryIncRef() {
        return this.refCounted.tryIncRef();
    }

    @Override
    public boolean decRef() {
        if (this.refCounted.decRef()) {
            this.deallocate();
            return true;
        }
        return false;
    }

    private void deallocate() {
        for (int i = 0; i < this.items.length; ++i) {
            Item item = this.items[i];
            SearchResponse r = item.response;
            if (r == null) continue;
            r.decRef();
            this.items[i] = null;
        }
    }

    @Override
    public boolean hasReferences() {
        return this.refCounted.hasReferences();
    }

    @Override
    public Iterator<Item> iterator() {
        assert (this.hasReferences());
        return Iterators.forArray(this.items);
    }

    public Item[] getResponses() {
        assert (this.hasReferences());
        return this.items;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        assert (this.hasReferences());
        out.writeArray(this.items);
        out.writeVLong(this.tookInMillis);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        assert (this.hasReferences());
        return Iterators.concat(ChunkedToXContentHelper.startObject(), Iterators.single((b, p) -> b.field("took", this.tookInMillis).startArray("responses")), Iterators.flatMap(Iterators.forArray(this.items), item -> item.toXContentChunked(params)), Iterators.single((b, p) -> b.endArray()), ChunkedToXContentHelper.endObject());
    }

    public String toString() {
        return Strings.toString(this);
    }

    public static class Item
    implements Writeable,
    ChunkedToXContent {
        private final SearchResponse response;
        private final Exception exception;

        public Item(@Nullable SearchResponse response, @Nullable Exception exception) {
            this.response = response;
            this.exception = exception;
        }

        Item(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                this.response = new SearchResponse(in);
                this.exception = null;
            } else {
                this.exception = in.readException();
                this.response = null;
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (this.response != null) {
                out.writeBoolean(true);
                this.response.writeTo(out);
            } else {
                out.writeBoolean(false);
                out.writeException(this.exception);
            }
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            if (this.isFailure()) {
                return Iterators.concat(ChunkedToXContentHelper.startObject(), Iterators.single((b, p) -> ElasticsearchException.generateFailureXContent(b, p, this.getFailure(), true)), Iterators.single((b, p) -> b.field("status", ExceptionsHelper.status(this.getFailure()).getStatus())), ChunkedToXContentHelper.endObject());
            }
            return Iterators.concat(ChunkedToXContentHelper.startObject(), this.getResponse().innerToXContentChunked(params), Iterators.single((b, p) -> b.field("status", this.getResponse().status().getStatus())), ChunkedToXContentHelper.endObject());
        }

        public boolean isFailure() {
            return this.exception != null;
        }

        @Nullable
        public String getFailureMessage() {
            return this.exception == null ? null : this.exception.getMessage();
        }

        @Nullable
        public SearchResponse getResponse() {
            return this.response;
        }

        public Exception getFailure() {
            return this.exception;
        }
    }

    public static final class Fields {
        public static final String RESPONSES = "responses";
        static final String STATUS = "status";
    }
}

