/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.resolve;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Build;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class ResolveClusterInfo
implements Writeable {
    private final boolean connected;
    private final Boolean skipUnavailable;
    private final Boolean matchingIndices;
    private final Build build;
    private final String error;

    public ResolveClusterInfo(boolean connected, Boolean skipUnavailable) {
        this(connected, skipUnavailable, null, null, null);
    }

    public ResolveClusterInfo(boolean connected, Boolean skipUnavailable, String error) {
        this(connected, skipUnavailable, null, null, error);
    }

    public ResolveClusterInfo(boolean connected, Boolean skipUnavailable, Boolean matchingIndices, Build build) {
        this(connected, skipUnavailable, matchingIndices, build, null);
    }

    public ResolveClusterInfo(ResolveClusterInfo copyFrom, boolean skipUnavailable) {
        this(copyFrom.isConnected(), skipUnavailable, copyFrom.getMatchingIndices(), copyFrom.getBuild(), copyFrom.getError());
    }

    private ResolveClusterInfo(boolean connected, Boolean skipUnavailable, Boolean matchingIndices, Build build, String error) {
        this.connected = connected;
        this.skipUnavailable = skipUnavailable;
        this.matchingIndices = matchingIndices;
        this.build = build;
        this.error = error;
        assert (error != null || matchingIndices != null || !connected) : "If matchingIndices is null, connected must be false";
    }

    public ResolveClusterInfo(StreamInput in) throws IOException {
        this.connected = in.readBoolean();
        this.skipUnavailable = in.readOptionalBoolean();
        this.matchingIndices = in.readOptionalBoolean();
        this.error = in.readOptionalString();
        boolean buildIsPresent = in.readBoolean();
        this.build = buildIsPresent ? Build.readBuild(in) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().before(TransportVersions.RESOLVE_CLUSTER_ENDPOINT_ADDED)) {
            throw new UnsupportedOperationException("ResolveClusterAction requires at least Transport Version " + TransportVersions.RESOLVE_CLUSTER_ENDPOINT_ADDED.toReleaseVersion() + " but was " + out.getTransportVersion().toReleaseVersion());
        }
        out.writeBoolean(this.connected);
        out.writeOptionalBoolean(this.skipUnavailable);
        out.writeOptionalBoolean(this.matchingIndices);
        out.writeOptionalString(this.error);
        boolean buildIsPresent = this.build != null;
        out.writeBoolean(buildIsPresent);
        if (buildIsPresent) {
            Build.writeBuild(this.build, out);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Boolean getSkipUnavailable() {
        return this.skipUnavailable;
    }

    public Boolean getMatchingIndices() {
        return this.matchingIndices;
    }

    public Build getBuild() {
        return this.build;
    }

    public String getError() {
        return this.error;
    }

    public String toString() {
        return "ResolveClusterInfo{connected=" + this.connected + ", skipUnavailable=" + this.skipUnavailable + ", matchingIndices=" + this.matchingIndices + ", build=" + this.build + ", error=" + this.error + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolveClusterInfo that = (ResolveClusterInfo)o;
        return this.connected == that.connected && Objects.equals(this.skipUnavailable, that.skipUnavailable) && Objects.equals(this.matchingIndices, that.matchingIndices) && Objects.equals(this.build, that.build) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(this.connected, this.skipUnavailable, this.matchingIndices, this.build, this.error);
    }
}

