/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.preallocate;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.security.AccessController;
import org.elasticsearch.preallocate.AbstractPosixPreallocator;

final class LinuxPreallocator
extends AbstractPosixPreallocator {
    LinuxPreallocator() {
        super(new AbstractPosixPreallocator.PosixConstants(144, 48, 64));
    }

    @Override
    public boolean useNative() {
        return Natives.NATIVES_AVAILABLE && super.useNative();
    }

    @Override
    public int preallocate(int fd, long currentSize, long fileSize) {
        int rc = Natives.fallocate(fd, 0, currentSize, fileSize - currentSize);
        return rc == 0 ? 0 : Native.getLastError();
    }

    private static class Natives {
        public static final boolean NATIVES_AVAILABLE = AccessController.doPrivileged(() -> {
            try {
                Native.register(Natives.class, (String)Platform.C_LIBRARY_NAME);
            }
            catch (UnsatisfiedLinkError e) {
                return false;
            }
            return true;
        });

        private Natives() {
        }

        static native int fallocate(int var0, int var1, long var2, long var4);
    }
}

