/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.inspireatom;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.inspireatom.harvester.InspireAtomHarvester;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/{portal}/api/atom"})
@Tag(name="atom", description="ATOM")
@RestController
public class AtomHarvester {
    @Operation(summary="Scan records for ATOM feeds", description="Check in the settings which protocol identify ATOM feeds in your catalogue.Only applies to ISO19139 records.")
    @GetMapping(value={"/scan"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Scan completed."), @ApiResponse(responseCode="204", description="Not authenticated.", content={@Content(schema=@Schema(hidden=true))})})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public Object scan(@Parameter(hidden=true) HttpServletRequest request) throws IOException {
        ServiceContext context = ApiUtils.createServiceContext((HttpServletRequest)request);
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        InspireAtomHarvester inspireAtomHarvester = new InspireAtomHarvester(gc);
        Element scanReport = inspireAtomHarvester.harvest();
        return Xml.getJSON((Element)scanReport);
    }
}

