/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jwtheaders.token;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.geoserver.security.jwtheaders.JwtConfiguration;

public class TokenSignatureValidator {
    public static LoadingCache<String, JWKSet> jwks = CacheBuilder.newBuilder().maximumSize(50000L).expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, JWKSet>(){

        public JWKSet load(String urlStr) throws Exception {
            return TokenSignatureValidator.loadJWKSet(urlStr);
        }
    });
    public static Cache<Object, Object> validAccessKeys = CacheBuilder.newBuilder().maximumSize(50000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
    JwtConfiguration jwtHeadersConfig;

    public static JWKSet loadJWKSet(String urlStr) throws Exception {
        URL url = new URL(urlStr);
        try (InputStream stream = url.openStream();){
            JWKSet jWKSet = JWKSet.load((InputStream)stream);
            return jWKSet;
        }
    }

    public TokenSignatureValidator(JwtConfiguration config) {
        this.jwtHeadersConfig = config;
    }

    public void validate(String accessToken) throws Exception {
        if (!this.jwtHeadersConfig.isValidateTokenSignature()) {
            return;
        }
        if (validAccessKeys.getIfPresent((Object)accessToken) != null) {
            return;
        }
        JWSObject jwsToken = JWSObject.parse((String)accessToken);
        String keyId = jwsToken.getHeader().getKeyID();
        JWKSet publicKeys = (JWKSet)jwks.get((Object)this.jwtHeadersConfig.getValidateTokenSignatureURL());
        RSAKey rsaKey = (RSAKey)publicKeys.getKeyByKeyId(keyId);
        this.validateSignature(rsaKey, jwsToken);
        validAccessKeys.put((Object)accessToken, (Object)Boolean.TRUE);
    }

    public void validateSignature(RSAKey rsaPublicKey, JWSObject token) throws Exception {
        RSASSAVerifier verifier = new RSASSAVerifier(rsaPublicKey);
        boolean valid = token.verify((JWSVerifier)verifier);
        if (!valid) {
            throw new Exception("Could not verify signature of the JWT with the given RSA Public Key");
        }
    }
}

