/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jwtheaders.token;

import com.nimbusds.jose.JWSObject;
import java.time.Instant;
import java.util.Date;
import org.geoserver.security.jwtheaders.JwtConfiguration;

public class TokenExpiryValidator {
    JwtConfiguration jwtHeadersConfig;

    public TokenExpiryValidator(JwtConfiguration config) {
        this.jwtHeadersConfig = config;
    }

    public void validate(JWSObject jwsToken) throws Exception {
        if (!this.jwtHeadersConfig.isValidateTokenExpiry()) {
            return;
        }
        Long exp = (Long)jwsToken.getPayload().toJSONObject().get("exp");
        long exp_ms = exp * 1000L;
        Instant exp_instant = new Date(exp_ms).toInstant();
        if (exp_instant.isBefore(Instant.now())) {
            throw new Exception("token has expired!");
        }
    }
}

