/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;

public class Sinusoidal
extends ProjectionImpl {
    private final double earthRadius;
    private double centMeridian;
    private double falseEasting;
    private double falseNorthing;

    @Override
    public ProjectionImpl constructCopy() {
        Sinusoidal result = new Sinusoidal(this.getCentMeridian(), this.getFalseEasting(), this.getFalseNorthing(), this.getEarthRadius());
        result.setDefaultMapArea(this.defaultMapArea);
        result.setName(this.name);
        return result;
    }

    public Sinusoidal() {
        this(0.0, 0.0, 0.0, EARTH_RADIUS);
    }

    public Sinusoidal(double centMeridian, double false_easting, double false_northing, double radius) {
        super("sinusoidal", false);
        this.centMeridian = centMeridian;
        this.falseEasting = false_easting;
        this.falseNorthing = false_northing;
        this.earthRadius = radius;
        this.addParameter("grid_mapping_name", "sinusoidal");
        this.addParameter("longitude_of_central_meridian", centMeridian);
        this.addParameter("earth_radius", this.earthRadius * 1000.0);
        if (false_easting != 0.0 || false_northing != 0.0) {
            this.addParameter("false_easting", false_easting);
            this.addParameter("false_northing", false_northing);
            this.addParameter("units", "km");
        }
    }

    public double getCentMeridian() {
        return this.centMeridian;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public double getEarthRadius() {
        return this.earthRadius;
    }

    public void setCentMeridian(double centMeridian) {
        this.centMeridian = centMeridian;
    }

    public void setFalseEasting(double falseEasting) {
        this.falseEasting = falseEasting;
    }

    public void setFalseNorthing(double falseNorthing) {
        this.falseNorthing = falseNorthing;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sinusoidal that = (Sinusoidal)o;
        if (Double.compare(that.centMeridian, this.centMeridian) != 0) {
            return false;
        }
        if (Double.compare(that.earthRadius, this.earthRadius) != 0) {
            return false;
        }
        if (Double.compare(that.falseEasting, this.falseEasting) != 0) {
            return false;
        }
        return Double.compare(that.falseNorthing, this.falseNorthing) == 0;
    }

    public int hashCode() {
        long temp = this.earthRadius != 0.0 ? Double.doubleToLongBits(this.earthRadius) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.centMeridian != 0.0 ? Double.doubleToLongBits(this.centMeridian) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseEasting != 0.0 ? Double.doubleToLongBits(this.falseEasting) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseNorthing != 0.0 ? Double.doubleToLongBits(this.falseNorthing) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sinusoidal");
        sb.append("{earthRadius=").append(this.earthRadius);
        sb.append(", centMeridian=").append(this.centMeridian);
        sb.append(", falseEasting=").append(this.falseEasting);
        sb.append(", falseNorthing=").append(this.falseNorthing);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String paramsToString() {
        return this.toString();
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        double x2;
        if (ProjectionPointImpl.isInfinite(pt1) || ProjectionPointImpl.isInfinite(pt2)) {
            return true;
        }
        double x1 = pt1.getX() - this.falseEasting;
        return x1 * (x2 = pt2.getX() - this.falseEasting) < 0.0 && Math.abs(x1 - x2) > this.earthRadius;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double deltaLon = LatLonPointImpl.range180(latLon.getLongitude() - this.centMeridian);
        double fromLat_r = Math.toRadians(latLon.getLatitude());
        double toX = this.earthRadius * Math.toRadians(deltaLon) * Math.cos(fromLat_r);
        double toY = this.earthRadius * fromLat_r;
        result.setLocation(toX + this.falseEasting, toY + this.falseNorthing);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double fromX = world.getX() - this.falseEasting;
        double fromY = world.getY() - this.falseNorthing;
        double toLat_r = fromY / this.earthRadius;
        double toLon_r = this.centMeridian;
        if (!Misc.closeEnough(toLat_r, 1.5707963267948966, 1.0E-10)) {
            toLon_r += fromX / (this.earthRadius * Math.cos(toLat_r));
        }
        result.setLatitude(Math.toDegrees(toLat_r));
        result.setLongitude(Math.toDegrees(toLon_r));
        return result;
    }
}

