/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.model;

import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.ows.wmts.model.TileMatrixSet;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class TileMatrix {
    private static final GeometryFactory gf = new GeometryFactory();
    String identifier;
    double denominator;
    double resolution;
    double pixelWidth = 2.8E-4;
    Point topLeft;
    int tileWidth = 256;
    int tileHeight = 256;
    int matrixWidth;
    int matrixHeight;
    private TileMatrixSet parent;

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public double getDenominator() {
        return this.denominator;
    }

    public double getResolution() {
        return this.resolution;
    }

    public void setDenominator(double denominator) {
        this.denominator = denominator;
        this.resolution = denominator * this.pixelWidth;
    }

    public Point getTopLeft() {
        return this.topLeft;
    }

    public void setTopLeft(Point topLeft) {
        this.topLeft = topLeft;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
    }

    public int getMatrixWidth() {
        return this.matrixWidth;
    }

    public void setMatrixWidth(int matrixWidth) {
        this.matrixWidth = matrixWidth;
    }

    public int getMatrixHeight() {
        return this.matrixHeight;
    }

    public void setMatrixHeight(int matrixHeight) {
        this.matrixHeight = matrixHeight;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getIdentifier()).append("\t").append(this.getDenominator()).append("\t").append(this.getResolution()).append("\t");
        sb.append(this.getTopLeft()).append("\t");
        sb.append(this.getTileWidth()).append("x").append(this.getTileHeight()).append("\n");
        return sb.toString();
    }

    public void setTopLeft(double lon, double lat) {
        boolean isLongitudeFirstAxisOrderForced = Boolean.getBoolean("org.geotools.referencing.forceXY") || GeoTools.getDefaultHints().get((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER) == Boolean.TRUE;
        CoordinateReferenceSystem crs = this.getCrs();
        if (isLongitudeFirstAxisOrderForced || crs != null && CRS.getAxisOrder(crs).equals((Object)CRS.AxisOrder.EAST_NORTH)) {
            this.topLeft = gf.createPoint(new Coordinate(lon, lat));
            return;
        }
        this.topLeft = gf.createPoint(new Coordinate(lat, lon));
    }

    public TileMatrixSet getParent() {
        return this.parent;
    }

    public void setParent(TileMatrixSet parent) {
        this.parent = parent;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.parent == null ? null : this.parent.getCoordinateReferenceSystem();
    }
}

