/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.client;

import java.net.URL;
import java.util.logging.Logger;
import org.geotools.ows.wmts.client.WMTSTileFactory;
import org.geotools.ows.wmts.client.WMTSTileIdentifier;
import org.geotools.ows.wmts.client.WMTSTileService;
import org.geotools.tile.Tile;
import org.geotools.tile.TileIdentifier;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.ZoomLevel;
import org.geotools.util.logging.Logging;

class WMTSTile
extends Tile {
    protected static final Logger LOGGER = Logging.getLogger(WMTSTile.class);
    public static final String WMTS_TILE_CACHE_SIZE_PROPERTY_NAME = "wmts.tile.cache.size";
    private URL url = null;

    public WMTSTile(int x, int y, ZoomLevel zoomLevel, TileService service) {
        this(new WMTSTileIdentifier(x, y, zoomLevel, service.getName()), service);
    }

    public WMTSTile(TileIdentifier tileIdentifier, TileService service) {
        this((WMTSTileIdentifier)tileIdentifier, service);
    }

    public WMTSTile(WMTSTileIdentifier tileIdentifier, TileService service) {
        super((TileIdentifier)tileIdentifier, WMTSTileFactory.getExtentFromTileName(tileIdentifier, service), ((WMTSTileService)service).getTileMatrix(tileIdentifier.getZoomLevel().getZoomLevel()).getTileWidth(), service);
    }

    private WMTSTileService getService() {
        return (WMTSTileService)this.service;
    }

    public URL getUrl() {
        if (this.url == null) {
            this.url = this.getService().createURL(this);
        }
        return this.url;
    }
}

